/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.core;

import io.specto.hoverfly.junit.core.config.HoverflyConfiguration;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProxyConfigurer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyConfigurer.class);
    private final HoverflyConfiguration hoverflyConfig;
    private final Map<String, String> originalProxyProperties = new HashMap<String, String>();

    ProxyConfigurer(HoverflyConfiguration hoverflyConfig) {
        this.hoverflyConfig = hoverflyConfig;
    }

    void setProxySystemProperties() {
        if (this.hoverflyConfig.isWebServer()) {
            return;
        }
        this.keepOriginalProxyProperties("http.nonProxyHosts", "http.proxyHost", "http.proxyPort", "https.proxyHost", "https.proxyPort");
        LOGGER.info("Setting proxy host to {}", (Object)this.hoverflyConfig.getHost());
        System.setProperty("http.proxyHost", this.hoverflyConfig.getHost());
        System.setProperty("https.proxyHost", this.hoverflyConfig.getHost());
        if (this.hoverflyConfig.isProxyLocalHost()) {
            System.setProperty("http.nonProxyHosts", "");
        } else {
            System.setProperty("http.nonProxyHosts", "localhost|127.*|[::1]");
        }
        if (this.hoverflyConfig.isRemoteInstance()) {
            String nonProxyHosts = System.getProperty("http.nonProxyHosts");
            nonProxyHosts = StringUtils.isNotBlank((CharSequence)nonProxyHosts) ? String.join((CharSequence)"|", nonProxyHosts, this.hoverflyConfig.getHost()) : this.hoverflyConfig.getHost();
            System.setProperty("http.nonProxyHosts", nonProxyHosts);
        }
        LOGGER.info("Setting proxy proxyPort to {}", (Object)this.hoverflyConfig.getProxyPort());
        System.setProperty("http.proxyPort", String.valueOf(this.hoverflyConfig.getProxyPort()));
        System.setProperty("https.proxyPort", String.valueOf(this.hoverflyConfig.getProxyPort()));
    }

    void restoreProxySystemProperties() {
        if (this.hoverflyConfig.isWebServer()) {
            return;
        }
        for (Map.Entry<String, String> originalProperty : this.originalProxyProperties.entrySet()) {
            String property = originalProperty.getKey();
            String originalValue = originalProperty.getValue();
            if (originalValue == null) {
                System.clearProperty(property);
                continue;
            }
            System.setProperty(property, originalValue);
        }
        this.originalProxyProperties.clear();
    }

    private void keepOriginalProxyProperties(String ... properties) {
        for (String property : properties) {
            this.originalProxyProperties.put(property, System.getProperty(property));
        }
    }
}

