/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.core;

import io.specto.hoverfly.junit.core.SystemConfigFactory;

class SystemConfig {
    private final SystemConfigFactory.OsName osName;
    private final SystemConfigFactory.ArchType archType;
    private final String binaryNameFormat;

    SystemConfig(SystemConfigFactory.OsName osName, SystemConfigFactory.ArchType archType, String binaryNameFormat) {
        this.osName = osName;
        this.archType = archType;
        this.binaryNameFormat = binaryNameFormat;
    }

    SystemConfigFactory.OsName getOsName() {
        return this.osName;
    }

    SystemConfigFactory.ArchType getArchType() {
        return this.archType;
    }

    String getBinaryNameFormat() {
        return this.binaryNameFormat;
    }

    String getHoverflyBinaryName() {
        String extension = "";
        if (this.osName == SystemConfigFactory.OsName.WINDOWS) {
            extension = ".exe";
        }
        return String.format(this.binaryNameFormat, this.osName.getName(), this.archType.getName(), extension);
    }
}

