/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.dsl;

import io.specto.hoverfly.junit.dsl.HttpBodyConverter;

public class SingleQuoteHttpBodyConverter
implements HttpBodyConverter {
    private String convertedBody;

    public SingleQuoteHttpBodyConverter(String json) {
        this.convertedBody = SingleQuoteHttpBodyConverter.convert(json);
    }

    @Override
    public String body() {
        return this.convertedBody;
    }

    @Override
    public String contentType() {
        return "application/json";
    }

    private static String convert(String text) {
        StringBuilder builder = new StringBuilder();
        boolean single_context = false;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '\\') {
                if (++i < text.length()) {
                    ch = text.charAt(i);
                    if (!single_context || ch != '\'') {
                        builder.append('\\');
                    }
                }
            } else if (ch == '\'') {
                ch = '\"';
                single_context = !single_context;
            }
            builder.append(ch);
        }
        return builder.toString();
    }
}

