/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.rule;

import io.specto.hoverfly.junit.core.Hoverfly;
import io.specto.hoverfly.junit.core.HoverflyConfig;
import io.specto.hoverfly.junit.core.HoverflyMode;
import io.specto.hoverfly.junit.rule.HoverflyRule;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class NoDiffAssertionRule
implements TestRule {
    private Hoverfly hoverfly;
    private HoverflyRule hoverflyRule;

    public NoDiffAssertionRule(Hoverfly hoverfly) {
        if (hoverfly == null) {
            throw new IllegalArgumentException("Hoverfly cannot be null");
        }
        this.hoverfly = hoverfly;
    }

    public NoDiffAssertionRule(HoverflyRule hoverflyRule) {
        if (hoverflyRule == null) {
            throw new IllegalArgumentException("HoverflyRule cannot be null");
        }
        this.hoverflyRule = hoverflyRule;
    }

    public NoDiffAssertionRule(HoverflyConfig hoverflyConfig) {
        if (hoverflyConfig == null) {
            throw new IllegalArgumentException("HoverflyConfig cannot be null");
        }
        this.hoverfly = new Hoverfly(hoverflyConfig, HoverflyMode.DIFF);
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                NoDiffAssertionRule.this.cleanDiffs();
                base.evaluate();
                NoDiffAssertionRule.this.performAssertion();
            }
        };
    }

    private void cleanDiffs() {
        if (this.hoverfly != null) {
            this.hoverfly.resetDiffs();
        } else {
            this.hoverflyRule.resetDiffs();
        }
    }

    private void performAssertion() {
        if (this.hoverfly != null) {
            this.hoverfly.assertThatNoDiffIsReported(true);
        } else {
            this.hoverflyRule.assertThatNoDiffIsReported();
        }
    }
}

