/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.experiments;

import com.google.common.base.Preconditions;
import com.google.common.collect.ConcurrentHashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.Sets;
import io.split.client.dtos.Condition;
import io.split.client.dtos.Matcher;
import io.split.client.dtos.MatcherType;
import io.split.client.dtos.Split;
import io.split.client.dtos.SplitChange;
import io.split.client.dtos.Status;
import io.split.engine.SDKReadinessGates;
import io.split.engine.experiments.ParsedSplit;
import io.split.engine.experiments.SplitChangeFetcher;
import io.split.engine.experiments.SplitFetcher;
import io.split.engine.experiments.SplitParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshableSplitFetcher
implements SplitFetcher,
Runnable {
    private static final Logger _log = LoggerFactory.getLogger(RefreshableSplitFetcher.class);
    private final SplitParser _parser;
    private final SplitChangeFetcher _splitChangeFetcher;
    private final AtomicLong _changeNumber;
    private Map<String, ParsedSplit> _concurrentMap = Maps.newConcurrentMap();
    Multiset<String> _concurrentTrafficTypeNameSet = ConcurrentHashMultiset.create();
    private final SDKReadinessGates _gates;
    private final Object _lock = new Object();

    public RefreshableSplitFetcher(SplitChangeFetcher splitChangeFetcher, SplitParser parser, SDKReadinessGates gates) {
        this(splitChangeFetcher, parser, gates, -1L);
    }

    RefreshableSplitFetcher(SplitChangeFetcher splitChangeFetcher, SplitParser parser, SDKReadinessGates gates, long startingChangeNumber) {
        this._splitChangeFetcher = splitChangeFetcher;
        this._parser = parser;
        this._gates = gates;
        this._changeNumber = new AtomicLong(startingChangeNumber);
        Preconditions.checkNotNull((Object)this._parser);
        Preconditions.checkNotNull((Object)this._splitChangeFetcher);
    }

    @Override
    public void forceRefresh() {
        this.run();
    }

    public long changeNumber() {
        return this._changeNumber.get();
    }

    @Override
    public ParsedSplit fetch(String test) {
        return this._concurrentMap.get(test);
    }

    @Override
    public List<ParsedSplit> fetchAll() {
        return Lists.newArrayList(this._concurrentMap.values());
    }

    @Override
    public Set<String> fetchKnownTrafficTypes() {
        return Sets.newHashSet((Iterable)this._concurrentTrafficTypeNameSet.elementSet());
    }

    public Collection<ParsedSplit> fetch() {
        return this._concurrentMap.values();
    }

    public void clear() {
        this._concurrentMap.clear();
        this._concurrentTrafficTypeNameSet.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long start = this._changeNumber.get();
        try {
            this.runWithoutExceptionHandling();
            this._gates.splitsAreReady();
        }
        catch (InterruptedException e) {
            _log.warn("Interrupting split fetcher task");
            Thread.currentThread().interrupt();
        }
        catch (Throwable t) {
            _log.error("RefreshableSplitFetcher failed: " + t.getMessage());
            if (_log.isDebugEnabled()) {
                _log.debug("Reason:", t);
            }
        }
        finally {
            if (_log.isDebugEnabled()) {
                _log.debug("split fetch before: " + start + ", after: " + this._changeNumber.get());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWithoutExceptionHandling() throws InterruptedException {
        SplitChange change = this._splitChangeFetcher.fetch(this._changeNumber.get());
        if (change == null) {
            throw new IllegalStateException("SplitChange was null");
        }
        if (change.till == this._changeNumber.get()) {
            return;
        }
        if (change.since != this._changeNumber.get() || change.till < this._changeNumber.get()) {
            return;
        }
        if (change.splits.isEmpty()) {
            this._changeNumber.set(change.till);
            return;
        }
        HashSet segmentsInUse = Sets.newHashSet();
        Object object = this._lock;
        synchronized (object) {
            if (change.since != this._changeNumber.get() || change.till < this._changeNumber.get()) {
                return;
            }
            HashSet toRemove = Sets.newHashSet();
            HashMap toAdd = Maps.newHashMap();
            ArrayList trafficTypeNamesToRemove = Lists.newArrayList();
            ArrayList trafficTypeNamesToAdd = Lists.newArrayList();
            for (Split split : change.splits) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
                if (split.status != Status.ACTIVE) {
                    toRemove.add(split.name);
                    if (split.trafficTypeName == null) continue;
                    trafficTypeNamesToRemove.add(split.trafficTypeName);
                    continue;
                }
                ParsedSplit parsedSplit = this._parser.parse(split);
                if (parsedSplit == null) {
                    _log.info("We could not parse the experiment definition for: " + split.name + " so we are removing it completely to be careful");
                    toRemove.add(split.name);
                    if (split.trafficTypeName == null) continue;
                    trafficTypeNamesToRemove.add(split.trafficTypeName);
                    continue;
                }
                segmentsInUse.addAll(this.collectSegmentsInUse(split));
                toAdd.put(split.name, parsedSplit);
                if (split.trafficTypeName == null) continue;
                trafficTypeNamesToAdd.add(split.trafficTypeName);
            }
            this._concurrentMap.putAll(toAdd);
            this._concurrentTrafficTypeNameSet.addAll((Collection)trafficTypeNamesToAdd);
            Multisets.removeOccurrences(this._concurrentTrafficTypeNameSet, (Iterable)trafficTypeNamesToRemove);
            for (String remove : toRemove) {
                this._concurrentMap.remove(remove);
            }
            if (!toAdd.isEmpty()) {
                _log.debug("Updated features: " + toAdd.keySet());
            }
            if (!toRemove.isEmpty()) {
                _log.debug("Deleted features: " + toRemove);
            }
            this._changeNumber.set(change.till);
        }
    }

    private List<String> collectSegmentsInUse(Split split) {
        ArrayList result = Lists.newArrayList();
        for (Condition condition : split.conditions) {
            for (Matcher matcher : condition.matcherGroup.matchers) {
                if (matcher.matcherType != MatcherType.IN_SEGMENT || matcher.userDefinedSegmentMatcherData == null || matcher.userDefinedSegmentMatcherData.segmentName == null) continue;
                result.add(matcher.userDefinedSegmentMatcherData.segmentName);
            }
        }
        return result;
    }
}

