/*
 * Decompiled with CFR 0.152.
 */
package split.org.apache.http.client.protocol;

import java.io.IOException;
import split.org.apache.http.HttpEntity;
import split.org.apache.http.HttpEntityEnclosingRequest;
import split.org.apache.http.HttpException;
import split.org.apache.http.HttpRequest;
import split.org.apache.http.HttpRequestInterceptor;
import split.org.apache.http.HttpVersion;
import split.org.apache.http.ProtocolVersion;
import split.org.apache.http.annotation.Immutable;
import split.org.apache.http.client.config.RequestConfig;
import split.org.apache.http.client.protocol.HttpClientContext;
import split.org.apache.http.protocol.HttpContext;
import split.org.apache.http.util.Args;

@Immutable
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

