/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.org.eclipse.sisu.inject;

import com.google.inject.Binding;
import io.spring.gradle.dependencymanagement.org.eclipse.sisu.Priority;
import io.spring.gradle.dependencymanagement.org.eclipse.sisu.inject.QualifyingStrategy;
import io.spring.gradle.dependencymanagement.org.eclipse.sisu.inject.RankingFunction;
import io.spring.gradle.dependencymanagement.org.eclipse.sisu.inject.Sources;
import javax.inject.Inject;

public final class DefaultRankingFunction
implements RankingFunction {
    private final int primaryRank;

    public DefaultRankingFunction(int primaryRank) {
        if (primaryRank < 0) {
            throw new IllegalArgumentException("Primary rank must be zero or more");
        }
        this.primaryRank = primaryRank;
    }

    @Inject
    public DefaultRankingFunction() {
        this(0);
    }

    @Override
    public int maxRank() {
        return Integer.MAX_VALUE;
    }

    @Override
    public <T> int rank(Binding<T> binding) {
        Priority priority = Sources.getAnnotation(binding, Priority.class);
        if (priority != null) {
            return priority.value();
        }
        if (QualifyingStrategy.DEFAULT_QUALIFIER.equals(QualifyingStrategy.qualify(binding.getKey()))) {
            return this.primaryRank;
        }
        return this.primaryRank + Integer.MIN_VALUE;
    }
}

