/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.maven.antora;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.springframework.maven.antora.Node;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="antora", defaultPhase=LifecyclePhase.NONE)
public class AntoraMavenPlugin
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject mavenProject;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession mavenSession;
    @Component
    private BuildPluginManager pluginManager;
    @Parameter
    private String version = "3.2.0-alpha.2";
    @Parameter
    private Map<String, String> environment = new HashMap<String, String>();
    @Parameter
    private List<String> options = new ArrayList<String>();
    @Parameter
    private String playbook = "antora-playbook.yml";
    private final String antoraExecutable = "node_modules/.bin/antora";
    @Parameter
    private Node node = new Node();
    @Parameter
    private List<String> packages = new ArrayList<String>();

    public void execute() throws MojoExecutionException {
        MojoExecutor.executeMojo((Plugin)this.frontendMavenPlugin(), (String)MojoExecutor.goal((String)"install-node-and-npm"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"nodeVersion"), (String)this.node.getVersion())}), (MojoExecutor.ExecutionEnvironment)this.executionEnvironment());
        MojoExecutor.executeMojo((Plugin)this.frontendMavenPlugin(), (String)MojoExecutor.goal((String)"npm"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"arguments"), (String)this.installArguments())}), (MojoExecutor.ExecutionEnvironment)this.executionEnvironment());
        MojoExecutor.executeMojo((Plugin)this.execAntoraPlugin(), (String)MojoExecutor.goal((String)"exec"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"executable"), (String)"node/node"), MojoExecutor.element((String)"arguments", (MojoExecutor.Element[])this.createExecAntoraArguments()), MojoExecutor.element((String)"environmentVariables", (MojoExecutor.Element[])this.createExecAntoraEnvironment()), MojoExecutor.element((String)"inheritIo", (String)"true")}), (MojoExecutor.ExecutionEnvironment)this.executionEnvironment());
    }

    private Plugin frontendMavenPlugin() {
        return MojoExecutor.plugin((String)MojoExecutor.groupId((String)"com.github.eirslett"), (String)MojoExecutor.artifactId((String)"frontend-maven-plugin"), (String)MojoExecutor.version((String)"1.12.1"));
    }

    private String installArguments() {
        StringBuffer installAntoraArgumentsValue = new StringBuffer();
        installAntoraArgumentsValue.append("install");
        if (this.packages.isEmpty()) {
            this.packages.add("@antora/atlas-extension@1.0.0-alpha.1");
            this.packages.add("@antora/collector-extension@1.0.0-alpha.3");
            this.packages.add("@asciidoctor/tabs@1.0.0-beta.3");
            this.packages.add("@springio/antora-extensions@1.5.0");
            this.packages.add("@springio/asciidoctor-extensions@1.0.0-alpha.9");
        }
        this.packages.add(0, "@antora/cli@" + this.version);
        this.packages.add(1, "@antora/site-generator-default@" + this.version);
        this.packages.forEach(dependency -> {
            installAntoraArgumentsValue.append(" ");
            installAntoraArgumentsValue.append((String)dependency);
        });
        return installAntoraArgumentsValue.toString();
    }

    private Plugin execAntoraPlugin() {
        return MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.codehaus.mojo"), (String)MojoExecutor.artifactId((String)"exec-maven-plugin"), (String)MojoExecutor.version((String)"3.1.0"));
    }

    private MojoExecutor.Element[] createExecAntoraEnvironment() {
        return (MojoExecutor.Element[])this.environment.entrySet().stream().map(envEntry -> MojoExecutor.element((String)((String)envEntry.getKey()), (String)((String)envEntry.getValue()))).toArray(MojoExecutor.Element[]::new);
    }

    private MojoExecutor.Element[] createExecAntoraArguments() {
        if (this.options.isEmpty()) {
            this.options.add("--to-dir=target/antora/site");
            this.options.add("--stacktrace");
        }
        this.options.add(0, this.antoraExecutable);
        this.options.add(1, this.playbook);
        return (MojoExecutor.Element[])this.options.stream().map(arg -> MojoExecutor.element((String)"argument", (String)arg)).toArray(MojoExecutor.Element[]::new);
    }

    private MojoExecutor.ExecutionEnvironment executionEnvironment() {
        return MojoExecutor.executionEnvironment((MavenProject)this.mavenProject, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager);
    }
}

