/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema.property.bean;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.classmate.members.ResolvedMember;
import com.fasterxml.classmate.members.ResolvedMethod;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import springfox.documentation.builders.ModelPropertyBuilder;
import springfox.documentation.schema.Annotations;
import springfox.documentation.schema.ModelProperty;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.schema.configuration.ObjectMapperConfigured;
import springfox.documentation.schema.plugins.SchemaPluginsManager;
import springfox.documentation.schema.property.BeanPropertyDefinitions;
import springfox.documentation.schema.property.BeanPropertyNamingStrategy;
import springfox.documentation.schema.property.bean.Accessors;
import springfox.documentation.schema.property.bean.AccessorsProvider;
import springfox.documentation.schema.property.bean.BeanModelProperty;
import springfox.documentation.schema.property.provider.ModelPropertiesProvider;
import springfox.documentation.spi.schema.contexts.ModelContext;
import springfox.documentation.spi.schema.contexts.ModelPropertyContext;

@Component
public class BeanModelPropertyProvider
implements ModelPropertiesProvider {
    private static final Logger LOG = LoggerFactory.getLogger(BeanModelPropertyProvider.class);
    private final AccessorsProvider accessors;
    private final BeanPropertyNamingStrategy namingStrategy;
    private ObjectMapper objectMapper;
    private final TypeResolver typeResolver;
    private final SchemaPluginsManager schemaPluginsManager;
    private final TypeNameExtractor typeNameExtractor;

    @Autowired
    public BeanModelPropertyProvider(AccessorsProvider accessors, TypeResolver typeResolver, BeanPropertyNamingStrategy namingStrategy, SchemaPluginsManager schemaPluginsManager, TypeNameExtractor typeNameExtractor) {
        this.typeResolver = typeResolver;
        this.accessors = accessors;
        this.namingStrategy = namingStrategy;
        this.schemaPluginsManager = schemaPluginsManager;
        this.typeNameExtractor = typeNameExtractor;
    }

    public void onApplicationEvent(ObjectMapperConfigured event) {
        this.objectMapper = event.getObjectMapper();
    }

    @VisibleForTesting
    List<ModelProperty> candidateProperties(AnnotatedMember member, ResolvedMethod childProperty, Optional<BeanPropertyDefinition> jacksonProperty, ModelContext givenContext) {
        if (member instanceof AnnotatedMethod && Annotations.memberIsUnwrapped(member)) {
            if (Accessors.isGetter(((AnnotatedMethod)member).getMember())) {
                LOG.debug("Evaluating unwrapped getter for member {}", (Object)((AnnotatedMethod)member).getMember().getName());
                return this.propertiesFor(childProperty.getReturnType(), ModelContext.fromParent((ModelContext)givenContext, (ResolvedType)childProperty.getReturnType()));
            }
            LOG.debug("Evaluating unwrapped setter for member {}", (Object)((AnnotatedMethod)member).getMember().getName());
            return this.propertiesFor(childProperty.getArgumentType(0), ModelContext.fromParent((ModelContext)givenContext, (ResolvedType)childProperty.getArgumentType(0)));
        }
        LOG.debug("Evaluating property of {}", (Object)childProperty);
        return FluentIterable.from((Iterable)Lists.newArrayList((Object[])new ModelProperty[]{this.beanModelProperty(childProperty, jacksonProperty, givenContext)})).filter(Predicates.not(BeanPropertyDefinitions.ignorable(givenContext))).toList();
    }

    private BeanDescription beanDescription(ResolvedType type, ModelContext context) {
        if (context.isReturnType()) {
            SerializationConfig serializationConfig = this.objectMapper.getSerializationConfig();
            return serializationConfig.introspect(TypeFactory.defaultInstance().constructType((Type)type.getErasedType()));
        }
        DeserializationConfig serializationConfig = this.objectMapper.getDeserializationConfig();
        return serializationConfig.introspect(TypeFactory.defaultInstance().constructType((Type)type.getErasedType()));
    }

    @Override
    public List<ModelProperty> propertiesFor(ResolvedType type, ModelContext givenContext) {
        ArrayList serializationCandidates = Lists.newArrayList();
        BeanDescription beanDescription = this.beanDescription(type, givenContext);
        ImmutableMap propertyLookup = Maps.uniqueIndex((Iterable)beanDescription.findProperties(), BeanPropertyDefinitions.beanPropertyByInternalName());
        for (Map.Entry each : propertyLookup.entrySet()) {
            LOG.debug("Reading property {}", each.getKey());
            BeanPropertyDefinition propertyDefinition = (BeanPropertyDefinition)each.getValue();
            Optional<BeanPropertyDefinition> jacksonProperty = BeanPropertyDefinitions.jacksonPropertyWithSameInternalName(beanDescription, propertyDefinition);
            AnnotatedMember member = propertyDefinition.getPrimaryMember();
            Optional<ResolvedMethod> accessor = this.findAccessorMethod(type, (String)each.getKey(), member);
            if (!accessor.isPresent()) continue;
            LOG.debug("Accessor selected {}", (Object)((ResolvedMethod)accessor.get()).getName());
            serializationCandidates.addAll(this.candidateProperties(member, (ResolvedMethod)accessor.get(), jacksonProperty, givenContext));
        }
        return serializationCandidates;
    }

    private Optional<ResolvedMethod> findAccessorMethod(ResolvedType resolvedType, final String propertyName, final AnnotatedMember member) {
        return Iterables.tryFind(this.accessors.in(resolvedType), (Predicate)new Predicate<ResolvedMethod>(){

            public boolean apply(ResolvedMethod accessorMethod) {
                return BeanModelProperty.accessorMemberIs((ResolvedMember)accessorMethod, Annotations.memberName(member)) && propertyName.equals(Accessors.propertyName((Method)accessorMethod.getRawMember()));
            }
        });
    }

    private ModelProperty beanModelProperty(ResolvedMethod childProperty, Optional<BeanPropertyDefinition> jacksonProperty, ModelContext modelContext) {
        BeanPropertyDefinition beanPropertyDefinition = (BeanPropertyDefinition)jacksonProperty.get();
        String propertyName = BeanPropertyDefinitions.name(beanPropertyDefinition, modelContext.isReturnType(), this.namingStrategy);
        BeanModelProperty beanModelProperty = new BeanModelProperty(propertyName, childProperty, Accessors.isGetter((Method)childProperty.getRawMember()), this.typeResolver, modelContext.getAlternateTypeProvider());
        LOG.debug("Adding property {} to model", (Object)propertyName);
        ModelPropertyBuilder propertyBuilder = new ModelPropertyBuilder().name(beanModelProperty.getName()).type(beanModelProperty.getType()).qualifiedType(beanModelProperty.qualifiedTypeName()).position(beanModelProperty.position()).required(beanModelProperty.isRequired()).isHidden(false).description(beanModelProperty.propertyDescription()).allowableValues(beanModelProperty.allowableValues());
        return this.schemaPluginsManager.property(new ModelPropertyContext(propertyBuilder, beanPropertyDefinition, this.typeResolver, modelContext.getDocumentationType())).updateModelRef(ResolvedTypes.modelRefFactory(modelContext, this.typeNameExtractor));
    }
}

