/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.schema.Collections;
import springfox.documentation.schema.Maps;
import springfox.documentation.schema.Model;
import springfox.documentation.schema.ModelDependencyProvider;
import springfox.documentation.schema.ModelProperty;
import springfox.documentation.schema.ModelProvider;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.schema.Types;
import springfox.documentation.schema.plugins.SchemaPluginsManager;
import springfox.documentation.schema.property.ModelPropertiesProvider;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.spi.schema.contexts.ModelContext;

@Component
public class DefaultModelProvider
implements ModelProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultModelProvider.class);
    private final TypeResolver resolver;
    private final ModelPropertiesProvider propertiesProvider;
    private final ModelDependencyProvider dependencyProvider;
    private final SchemaPluginsManager schemaPluginsManager;
    private final TypeNameExtractor typeNameExtractor;

    @Autowired
    public DefaultModelProvider(TypeResolver resolver, ModelPropertiesProvider propertiesProvider, ModelDependencyProvider dependencyProvider, SchemaPluginsManager schemaPluginsManager, TypeNameExtractor typeNameExtractor) {
        this.resolver = resolver;
        this.propertiesProvider = propertiesProvider;
        this.dependencyProvider = dependencyProvider;
        this.schemaPluginsManager = schemaPluginsManager;
        this.typeNameExtractor = typeNameExtractor;
    }

    @Override
    public Optional<Model> modelFor(ModelContext modelContext) {
        ResolvedType propertiesHost = modelContext.alternateFor(modelContext.resolvedType(this.resolver));
        if (Collections.isContainerType(propertiesHost) || Maps.isMapType(propertiesHost) || propertiesHost.getErasedType().isEnum() || Types.isBaseType(Types.typeNameFor(propertiesHost.getErasedType())) || modelContext.hasSeenBefore(propertiesHost)) {
            LOG.debug("Skipping model of type {} as its either a container type, map, enum or base type, or its already been handled", ResolvedTypes.resolvedTypeSignature(propertiesHost).or((Object)"<null>"));
            return Optional.absent();
        }
        TreeMap properties = com.google.common.collect.Maps.newTreeMap();
        ImmutableMap propertiesIndex = Multimaps.index(this.properties(modelContext, propertiesHost), this.byPropertyName()).asMap();
        LOG.debug("Inferred {} properties. Properties found {}", (Object)propertiesIndex.size(), (Object)Joiner.on((String)", ").join((Iterable)propertiesIndex.keySet()));
        for (Map.Entry each : propertiesIndex.entrySet()) {
            properties.put(each.getKey(), this.merge((Collection)each.getValue()));
        }
        return Optional.of((Object)this.modelBuilder(propertiesHost, properties, modelContext));
    }

    private ModelProperty merge(Collection<ModelProperty> propertyVariants) {
        ModelProperty merged = (ModelProperty)Iterables.getFirst(propertyVariants, null);
        for (ModelProperty each : Iterables.skip(propertyVariants, (int)1)) {
            boolean required = (Boolean)Optional.fromNullable((Object)each.isRequired()).or((Object)false) | merged.isRequired();
            merged = new ModelProperty((String)BuilderDefaults.defaultIfAbsent((Object)each.getName(), (Object)merged.getName()), (ResolvedType)BuilderDefaults.defaultIfAbsent((Object)each.getType(), (Object)merged.getType()), (String)BuilderDefaults.defaultIfAbsent((Object)Strings.emptyToNull((String)each.getQualifiedType()), (Object)merged.getQualifiedType()), each.getPosition() > 0 ? each.getPosition() : merged.getPosition(), Boolean.valueOf(required), each.isHidden() | merged.isHidden(), (String)BuilderDefaults.defaultIfAbsent((Object)Strings.emptyToNull((String)each.getDescription()), (Object)merged.getDescription()), (AllowableValues)BuilderDefaults.defaultIfAbsent((Object)each.getAllowableValues(), (Object)merged.getAllowableValues()));
            merged.updateModelRef(Functions.forSupplier((Supplier)Suppliers.ofInstance((Object)BuilderDefaults.defaultIfAbsent((Object)each.getModelRef(), (Object)merged.getModelRef()))));
        }
        return merged;
    }

    private Model modelBuilder(ResolvedType propertiesHost, Map<String, ModelProperty> properties, ModelContext modelContext) {
        String typeName = this.typeNameExtractor.typeName(ModelContext.fromParent((ModelContext)modelContext, (ResolvedType)propertiesHost));
        modelContext.getBuilder().id(typeName).type(propertiesHost).name(typeName).qualifiedType(ResolvedTypes.simpleQualifiedTypeName(propertiesHost)).properties(properties).description("").baseModel("").discriminator("").subTypes(new ArrayList());
        return this.schemaPluginsManager.model(modelContext);
    }

    @Override
    public Map<String, Model> dependencies(ModelContext modelContext) {
        HashMap models = com.google.common.collect.Maps.newHashMap();
        for (ResolvedType resolvedType : this.dependencyProvider.dependentModels(modelContext)) {
            ModelContext parentContext = ModelContext.fromParent((ModelContext)modelContext, (ResolvedType)resolvedType);
            Optional model = this.modelFor(parentContext).or(this.mapModel(parentContext, resolvedType));
            if (!model.isPresent()) continue;
            models.put(((Model)model.get()).getName(), model.get());
        }
        return models;
    }

    private Optional<Model> mapModel(ModelContext parentContext, ResolvedType resolvedType) {
        if (Maps.isMapType(resolvedType) && !parentContext.hasSeenBefore(resolvedType)) {
            String typeName = this.typeNameExtractor.typeName(parentContext);
            return Optional.of((Object)parentContext.getBuilder().id(typeName).type(resolvedType).name(typeName).qualifiedType(ResolvedTypes.simpleQualifiedTypeName(resolvedType)).properties(new HashMap()).description("").baseModel("").discriminator("").subTypes(new ArrayList()).build());
        }
        return Optional.absent();
    }

    private Function<ModelProperty, String> byPropertyName() {
        return new Function<ModelProperty, String>(){

            public String apply(ModelProperty input) {
                return input.getName();
            }
        };
    }

    private List<ModelProperty> properties(ModelContext context, ResolvedType propertiesHost) {
        return this.propertiesProvider.propertiesFor(propertiesHost, context);
    }
}

