/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.parameter;

import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.ParameterContext;
import springfox.documentation.spring.web.DescriptionResolver;

@Component
@Order(value=-2147483648)
public class ParameterDefaultReader
implements ParameterBuilderPlugin {
    private final DescriptionResolver descriptions;

    @Autowired
    public ParameterDefaultReader(DescriptionResolver descriptions) {
        this.descriptions = descriptions;
    }

    public void apply(ParameterContext context) {
        String defaultValue = this.findAnnotatedDefaultValue(context.resolvedMethodParameter());
        boolean isSkip = "\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(defaultValue);
        if (!isSkip) {
            context.parameterBuilder().defaultValue(defaultValue);
        }
    }

    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    private String findAnnotatedDefaultValue(ResolvedMethodParameter methodParameter) {
        Optional requestParam = methodParameter.findAnnotation(RequestParam.class);
        if (requestParam.isPresent()) {
            return this.descriptions.resolve(((RequestParam)requestParam.get()).defaultValue());
        }
        Optional requestHeader = methodParameter.findAnnotation(RequestHeader.class);
        if (requestHeader.isPresent()) {
            return this.descriptions.resolve(((RequestHeader)requestHeader.get()).defaultValue());
        }
        return null;
    }
}

