/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger1.mappers;

import io.swagger.models.Contact;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import springfox.documentation.schema.Model;
import springfox.documentation.schema.ModelProperty;
import springfox.documentation.service.ApiListing;
import springfox.documentation.service.ApiListingReference;
import springfox.documentation.service.Operation;
import springfox.documentation.swagger1.dto.ApiDescription;
import springfox.documentation.swagger1.dto.ApiInfo;
import springfox.documentation.swagger1.dto.ModelDto;
import springfox.documentation.swagger1.dto.ModelPropertyDto;
import springfox.documentation.swagger1.dto.Parameter;
import springfox.documentation.swagger1.dto.ResourceListing;
import springfox.documentation.swagger1.dto.ResponseMessage;
import springfox.documentation.swagger1.mappers.AllowableValuesMapper;
import springfox.documentation.swagger1.mappers.AuthorizationTypesMapper;
import springfox.documentation.swagger1.mappers.DataTypeMapper;

@Mapper(uses={AllowableValuesMapper.class, DataTypeMapper.class, AuthorizationTypesMapper.class})
public interface ServiceModelToSwaggerMapper {
    public ApiDescription toSwaggerApiDescription(springfox.documentation.service.ApiDescription var1);

    @Mappings(value={@Mapping(target="contact", source="contact.name")})
    public ApiInfo toSwaggerApiInfo(springfox.documentation.service.ApiInfo var1);

    public Contact map(springfox.documentation.service.Contact var1);

    @Mappings(value={@Mapping(target="responseModel", source="responseModel", qualifiedBy={DataTypeMapper.ResponseTypeName.class})})
    public ResponseMessage toSwaggerResponseMessage(springfox.documentation.service.ResponseMessage var1);

    public springfox.documentation.swagger1.dto.ApiListingReference toSwaggerApiListingReference(ApiListingReference var1);

    public ModelDto toSwaggerModelDto(Model var1);

    @Mappings(value={@Mapping(target="swaggerVersion", constant="1.2"), @Mapping(target="authorizations", source="securityReferences")})
    public springfox.documentation.swagger1.dto.ApiListing toSwaggerApiListing(ApiListing var1);

    @Mappings(value={@Mapping(target="type", source="modelRef", qualifiedBy={DataTypeMapper.Type.class})})
    public ModelPropertyDto toSwaggerModelPropertyDto(ModelProperty var1);

    @Mappings(value={@Mapping(target="dataType", source="responseModel", qualifiedBy={DataTypeMapper.OperationType.class}), @Mapping(target="nickname", source="uniqueId"), @Mapping(target="authorizations", source="securityReferences")})
    public springfox.documentation.swagger1.dto.Operation toSwaggerOperation(Operation var1);

    @Mappings(value={@Mapping(target="parameterType", source="modelRef", qualifiedBy={DataTypeMapper.OperationType.class})})
    public Parameter toSwaggerParameter(springfox.documentation.service.Parameter var1);

    @Mappings(value={@Mapping(target="swaggerVersion", constant="1.2"), @Mapping(target="authorizations", source="securitySchemes")})
    public ResourceListing toSwaggerResourceListing(springfox.documentation.service.ResourceListing var1);
}

