/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger1.mappers;

import io.swagger.models.Contact;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.Model;
import springfox.documentation.schema.ModelProperty;
import springfox.documentation.service.ApiListing;
import springfox.documentation.service.ApiListingReference;
import springfox.documentation.service.Operation;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.swagger1.dto.ApiDescription;
import springfox.documentation.swagger1.dto.ApiInfo;
import springfox.documentation.swagger1.dto.Authorization;
import springfox.documentation.swagger1.dto.AuthorizationScope;
import springfox.documentation.swagger1.dto.AuthorizationType;
import springfox.documentation.swagger1.dto.ModelDto;
import springfox.documentation.swagger1.dto.ModelPropertyDto;
import springfox.documentation.swagger1.dto.Parameter;
import springfox.documentation.swagger1.dto.ResourceListing;
import springfox.documentation.swagger1.dto.ResponseMessage;
import springfox.documentation.swagger1.mappers.AllowableValuesMapper;
import springfox.documentation.swagger1.mappers.AuthorizationTypesMapper;
import springfox.documentation.swagger1.mappers.DataTypeMapper;
import springfox.documentation.swagger1.mappers.ServiceModelToSwaggerMapper;

@Component
public class ServiceModelToSwaggerMapperImpl
implements ServiceModelToSwaggerMapper {
    @Autowired
    private AllowableValuesMapper allowableValuesMapper;
    @Autowired
    private DataTypeMapper dataTypeMapper;
    @Autowired
    private AuthorizationTypesMapper authorizationTypesMapper;

    @Override
    public ApiDescription toSwaggerApiDescription(springfox.documentation.service.ApiDescription from) {
        if (from == null) {
            return null;
        }
        ApiDescription apiDescription = new ApiDescription();
        apiDescription.setPath(from.getPath());
        apiDescription.setDescription(from.getDescription());
        List<springfox.documentation.swagger1.dto.Operation> list = this.operationListToOperationList(from.getOperations());
        if (list != null) {
            apiDescription.setOperations(list);
        }
        apiDescription.setHidden(from.isHidden());
        return apiDescription;
    }

    @Override
    public ApiInfo toSwaggerApiInfo(springfox.documentation.service.ApiInfo from) {
        if (from == null) {
            return null;
        }
        ApiInfo apiInfo = new ApiInfo();
        apiInfo.setContact(this.fromContactName(from));
        apiInfo.setTitle(from.getTitle());
        apiInfo.setDescription(from.getDescription());
        apiInfo.setTermsOfServiceUrl(from.getTermsOfServiceUrl());
        apiInfo.setLicense(from.getLicense());
        apiInfo.setLicenseUrl(from.getLicenseUrl());
        return apiInfo;
    }

    @Override
    public Contact map(springfox.documentation.service.Contact from) {
        if (from == null) {
            return null;
        }
        Contact contact = new Contact();
        contact.setName(from.getName());
        contact.setUrl(from.getUrl());
        contact.setEmail(from.getEmail());
        return contact;
    }

    @Override
    public ResponseMessage toSwaggerResponseMessage(springfox.documentation.service.ResponseMessage from) {
        if (from == null) {
            return null;
        }
        ResponseMessage responseMessage = new ResponseMessage();
        responseMessage.setResponseModel(this.dataTypeMapper.responseTypeName(from.getResponseModel()));
        responseMessage.setCode(from.getCode());
        responseMessage.setMessage(from.getMessage());
        return responseMessage;
    }

    @Override
    public springfox.documentation.swagger1.dto.ApiListingReference toSwaggerApiListingReference(ApiListingReference from) {
        if (from == null) {
            return null;
        }
        springfox.documentation.swagger1.dto.ApiListingReference apiListingReference = new springfox.documentation.swagger1.dto.ApiListingReference();
        apiListingReference.setPath(from.getPath());
        apiListingReference.setDescription(from.getDescription());
        apiListingReference.setPosition(from.getPosition());
        return apiListingReference;
    }

    @Override
    public ModelDto toSwaggerModelDto(Model from) {
        if (from == null) {
            return null;
        }
        ModelDto modelDto = new ModelDto();
        modelDto.setId(from.getId());
        modelDto.setName(from.getName());
        modelDto.setQualifiedType(from.getQualifiedType());
        Map<String, ModelPropertyDto> map = this.stringModelPropertyMapToStringModelPropertyDtoMap(from.getProperties());
        if (map != null) {
            modelDto.setProperties(map);
        }
        modelDto.setDescription(from.getDescription());
        modelDto.setBaseModel(from.getBaseModel());
        modelDto.setDiscriminator(from.getDiscriminator());
        List list = from.getSubTypes();
        if (list != null) {
            modelDto.setSubTypes(new ArrayList<String>(list));
        }
        return modelDto;
    }

    @Override
    public springfox.documentation.swagger1.dto.ApiListing toSwaggerApiListing(ApiListing from) {
        Map<String, ModelDto> map;
        List<ApiDescription> list_;
        Set set__;
        Set set_;
        if (from == null) {
            return null;
        }
        springfox.documentation.swagger1.dto.ApiListing apiListing = new springfox.documentation.swagger1.dto.ApiListing();
        List<Authorization> list = this.securityReferenceListToAuthorizationList(from.getSecurityReferences());
        if (list != null) {
            apiListing.setAuthorizations(list);
        }
        apiListing.setApiVersion(from.getApiVersion());
        apiListing.setBasePath(from.getBasePath());
        apiListing.setResourcePath(from.getResourcePath());
        Set set = from.getProduces();
        if (set != null) {
            apiListing.setProduces(new HashSet<String>(set));
        }
        if ((set_ = from.getConsumes()) != null) {
            apiListing.setConsumes(new HashSet<String>(set_));
        }
        if ((set__ = from.getProtocols()) != null) {
            apiListing.setProtocols(new HashSet<String>(set__));
        }
        if ((list_ = this.apiDescriptionListToApiDescriptionList(from.getApis())) != null) {
            apiListing.setApis(list_);
        }
        if ((map = this.stringModelMapToStringModelDtoMap(from.getModels())) != null) {
            apiListing.setModels(map);
        }
        apiListing.setDescription(from.getDescription());
        apiListing.setPosition(from.getPosition());
        apiListing.setSwaggerVersion("1.2");
        return apiListing;
    }

    @Override
    public ModelPropertyDto toSwaggerModelPropertyDto(ModelProperty from) {
        if (from == null) {
            return null;
        }
        ModelPropertyDto modelPropertyDto_ = new ModelPropertyDto();
        modelPropertyDto_.setType(this.dataTypeMapper.typeFromModelRef(from.getModelRef()));
        modelPropertyDto_.setQualifiedType(from.getQualifiedType());
        modelPropertyDto_.setPosition(from.getPosition());
        modelPropertyDto_.setDescription(from.getDescription());
        modelPropertyDto_.setAllowableValues(this.allowableValuesMapper.toSwaggerAllowableValues(from.getAllowableValues()));
        modelPropertyDto_.setName(from.getName());
        modelPropertyDto_.setRequired(from.isRequired());
        return modelPropertyDto_;
    }

    @Override
    public springfox.documentation.swagger1.dto.Operation toSwaggerOperation(Operation from) {
        Set<ResponseMessage> set___;
        List<Parameter> list;
        Set set__;
        Set set_;
        if (from == null) {
            return null;
        }
        springfox.documentation.swagger1.dto.Operation operation_ = new springfox.documentation.swagger1.dto.Operation();
        operation_.setDataType(this.dataTypeMapper.operationTypeFromModelRef(from.getResponseModel()));
        Map<String, List<AuthorizationScope>> map = this.stringListMapToStringListMap(from.getSecurityReferences());
        if (map != null) {
            operation_.setAuthorizations(map);
        }
        operation_.setNickname(from.getUniqueId());
        if (from.getMethod() != null) {
            operation_.setMethod(from.getMethod().name());
        }
        operation_.setSummary(from.getSummary());
        operation_.setNotes(from.getNotes());
        operation_.setPosition(from.getPosition());
        Set set = from.getProduces();
        if (set != null) {
            operation_.setProduces(new ArrayList<String>(set));
        }
        if ((set_ = from.getConsumes()) != null) {
            operation_.setConsumes(new ArrayList<String>(set_));
        }
        if ((set__ = from.getProtocol()) != null) {
            operation_.setProtocol(new ArrayList<String>(set__));
        }
        if ((list = this.parameterListToParameterList(from.getParameters())) != null) {
            operation_.setParameters(list);
        }
        if ((set___ = this.responseMessageSetToResponseMessageSet(from.getResponseMessages())) != null) {
            operation_.setResponseMessages(set___);
        }
        operation_.setDeprecated(from.getDeprecated());
        return operation_;
    }

    @Override
    public Parameter toSwaggerParameter(springfox.documentation.service.Parameter from) {
        if (from == null) {
            return null;
        }
        Parameter parameter_ = new Parameter();
        parameter_.setParameterType(this.dataTypeMapper.operationTypeFromModelRef(from.getModelRef()));
        parameter_.setName(from.getName());
        parameter_.setDescription(from.getDescription());
        parameter_.setDefaultValue(from.getDefaultValue());
        parameter_.setAllowableValues(this.allowableValuesMapper.toSwaggerAllowableValues(from.getAllowableValues()));
        parameter_.setParamType(from.getParamType());
        parameter_.setParamAccess(from.getParamAccess());
        parameter_.setRequired(from.isRequired());
        parameter_.setAllowMultiple(from.isAllowMultiple());
        return parameter_;
    }

    @Override
    public ResourceListing toSwaggerResourceListing(springfox.documentation.service.ResourceListing from) {
        if (from == null) {
            return null;
        }
        ResourceListing resourceListing = new ResourceListing();
        List<AuthorizationType> list = this.authorizationTypesMapper.toSwaggerAuthorizationTypes(from.getSecuritySchemes());
        if (list != null) {
            resourceListing.setAuthorizations(list);
        }
        resourceListing.setApiVersion(from.getApiVersion());
        List<springfox.documentation.swagger1.dto.ApiListingReference> list_ = this.apiListingReferenceListToApiListingReferenceList(from.getApis());
        if (list_ != null) {
            resourceListing.setApis(list_);
        }
        resourceListing.setInfo(this.toSwaggerApiInfo(from.getInfo()));
        resourceListing.setSwaggerVersion("1.2");
        return resourceListing;
    }

    protected List<springfox.documentation.swagger1.dto.Operation> operationListToOperationList(List<Operation> list) {
        if (list == null) {
            return null;
        }
        ArrayList<springfox.documentation.swagger1.dto.Operation> list_ = new ArrayList<springfox.documentation.swagger1.dto.Operation>();
        for (Operation operation : list) {
            list_.add(this.toSwaggerOperation(operation));
        }
        return list_;
    }

    private String fromContactName(springfox.documentation.service.ApiInfo apiInfo) {
        if (apiInfo == null) {
            return null;
        }
        springfox.documentation.service.Contact contact = apiInfo.getContact();
        if (contact == null) {
            return null;
        }
        String name = contact.getName();
        if (name == null) {
            return null;
        }
        return name;
    }

    protected Map<String, ModelPropertyDto> stringModelPropertyMapToStringModelPropertyDtoMap(Map<String, ModelProperty> map) {
        if (map == null) {
            return null;
        }
        HashMap<String, ModelPropertyDto> map_ = new HashMap<String, ModelPropertyDto>();
        for (Map.Entry<String, ModelProperty> entry : map.entrySet()) {
            String key = entry.getKey();
            ModelPropertyDto value = this.toSwaggerModelPropertyDto(entry.getValue());
            map_.put(key, value);
        }
        return map_;
    }

    protected List<Authorization> securityReferenceListToAuthorizationList(List<SecurityReference> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Authorization> list_ = new ArrayList<Authorization>();
        for (SecurityReference securityReference : list) {
            list_.add(this.authorizationTypesMapper.toSwaggerSecurityReference(securityReference));
        }
        return list_;
    }

    protected List<ApiDescription> apiDescriptionListToApiDescriptionList(List<springfox.documentation.service.ApiDescription> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ApiDescription> list_ = new ArrayList<ApiDescription>();
        for (springfox.documentation.service.ApiDescription apiDescription : list) {
            list_.add(this.toSwaggerApiDescription(apiDescription));
        }
        return list_;
    }

    protected Map<String, ModelDto> stringModelMapToStringModelDtoMap(Map<String, Model> map) {
        if (map == null) {
            return null;
        }
        HashMap<String, ModelDto> map_ = new HashMap<String, ModelDto>();
        for (Map.Entry<String, Model> entry : map.entrySet()) {
            String key = entry.getKey();
            ModelDto value = this.toSwaggerModelDto(entry.getValue());
            map_.put(key, value);
        }
        return map_;
    }

    protected Map<String, List<AuthorizationScope>> stringListMapToStringListMap(Map<String, List<springfox.documentation.service.AuthorizationScope>> map) {
        if (map == null) {
            return null;
        }
        HashMap<String, List<AuthorizationScope>> map_ = new HashMap<String, List<AuthorizationScope>>();
        for (Map.Entry<String, List<springfox.documentation.service.AuthorizationScope>> entry : map.entrySet()) {
            String key = entry.getKey();
            List<AuthorizationScope> value = this.authorizationTypesMapper.toSwaggerAuthorizationScopes(entry.getValue());
            map_.put(key, value);
        }
        return map_;
    }

    protected List<Parameter> parameterListToParameterList(List<springfox.documentation.service.Parameter> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Parameter> list_ = new ArrayList<Parameter>();
        for (springfox.documentation.service.Parameter parameter : list) {
            list_.add(this.toSwaggerParameter(parameter));
        }
        return list_;
    }

    protected Set<ResponseMessage> responseMessageSetToResponseMessageSet(Set<springfox.documentation.service.ResponseMessage> set) {
        if (set == null) {
            return null;
        }
        HashSet<ResponseMessage> set_ = new HashSet<ResponseMessage>();
        for (springfox.documentation.service.ResponseMessage responseMessage : set) {
            set_.add(this.toSwaggerResponseMessage(responseMessage));
        }
        return set_;
    }

    protected List<springfox.documentation.swagger1.dto.ApiListingReference> apiListingReferenceListToApiListingReferenceList(List<ApiListingReference> list) {
        if (list == null) {
            return null;
        }
        ArrayList<springfox.documentation.swagger1.dto.ApiListingReference> list_ = new ArrayList<springfox.documentation.swagger1.dto.ApiListingReference>();
        for (ApiListingReference apiListingReference : list) {
            list_.add(this.toSwaggerApiListingReference(apiListingReference));
        }
        return list_;
    }
}

