/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.test.container;

import com.github.dockerjava.api.command.InspectContainerResponse;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.strimzi.test.container.KafkaVersionService;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.images.builder.Transferable;

@SuppressFBWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"})
public class StrimziZookeeperContainer
extends GenericContainer<StrimziZookeeperContainer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StrimziZookeeperContainer.class);
    private static final String STARTER_SCRIPT = "/testcontainers_start.sh";
    public static final int ZOOKEEPER_PORT = 2181;
    private final CompletableFuture<String> imageNameProvider;
    private String kafkaVersion;

    public StrimziZookeeperContainer() {
        this(new CompletableFuture<String>());
    }

    public StrimziZookeeperContainer(String dockerImageName) {
        this(CompletableFuture.completedFuture(dockerImageName));
    }

    private StrimziZookeeperContainer(CompletableFuture<String> imageName) {
        super(imageName);
        this.imageNameProvider = imageName;
        super.setNetwork(Network.SHARED);
        super.setExposedPorts(Collections.singletonList(2181));
        super.setNetworkAliases(Collections.singletonList("zookeeper"));
        super.addEnv("LOG_DIR", "/tmp");
        super.addEnv("ZOOKEEPER_CLIENT_PORT", String.valueOf(2181));
        super.addEnv("ZOO_4LW_COMMANDS_WHITELIST", "ruok");
    }

    protected void doStart() {
        if (!this.imageNameProvider.isDone()) {
            this.imageNameProvider.complete(KafkaVersionService.strimziTestContainerImageName(this.kafkaVersion));
        }
        this.withCommand(new String[]{"sh", "-c", "while [ ! -f /testcontainers_start.sh ]; do sleep 0.1; done; /testcontainers_start.sh"});
        super.doStart();
    }

    protected void containerIsStarting(InspectContainerResponse containerInfo, boolean reused) {
        super.containerIsStarting(containerInfo, reused);
        int zookeeperDynamicExposedPort = this.getMappedPort(2181);
        LOGGER.info("This is mapped port {}", (Object)zookeeperDynamicExposedPort);
        String command = "#!/bin/bash \nbin/zookeeper-server-start.sh config/zookeeper.properties\n";
        LOGGER.info("Copying command to 'STARTER_SCRIPT' script.");
        this.copyFileToContainer(Transferable.of((byte[])"#!/bin/bash \nbin/zookeeper-server-start.sh config/zookeeper.properties\n".getBytes(StandardCharsets.UTF_8), (int)700), STARTER_SCRIPT);
    }

    public StrimziZookeeperContainer withKafkaVersion(String kafkaVersion) {
        this.kafkaVersion = kafkaVersion;
        return this;
    }
}

