/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.test.container;

import io.strimzi.test.container.WaitException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.function.BooleanSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);

    Utils() {
    }

    static long waitFor(String description, long pollIntervalMs, long timeoutMs, BooleanSupplier ready) {
        LOGGER.debug("Waiting for {}", (Object)description);
        long deadline = System.currentTimeMillis() + timeoutMs;
        String exceptionMessage = null;
        int exceptionCount = 0;
        StringWriter stackTraceError = new StringWriter();
        while (true) {
            boolean result;
            try {
                result = ready.getAsBoolean();
            }
            catch (Exception e) {
                exceptionMessage = e.getMessage();
                if (++exceptionCount == 1 && exceptionMessage != null) {
                    LOGGER.error("Exception waiting for {}, {}", (Object)description, (Object)exceptionMessage);
                    e.printStackTrace(new PrintWriter(stackTraceError));
                }
                result = false;
            }
            long timeLeft = deadline - System.currentTimeMillis();
            if (result) {
                return timeLeft;
            }
            if (timeLeft <= 0L) {
                if (exceptionCount > 1) {
                    LOGGER.error("Exception waiting for {}, {}", (Object)description, (Object)exceptionMessage);
                    if (!stackTraceError.toString().isEmpty()) {
                        LOGGER.error(stackTraceError.toString());
                    }
                }
                WaitException waitException = new WaitException("Timeout after " + timeoutMs + " ms waiting for " + description);
                waitException.addSuppressed(waitException);
                throw waitException;
            }
            long sleepTime = Math.min(pollIntervalMs, timeLeft);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("{} not satisfied, will try again in {} ms ({}ms till timeout)", new Object[]{description, sleepTime, timeLeft});
            }
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                return deadline - System.currentTimeMillis();
            }
        }
    }
}

