/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.generators.java;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.codegen.v3.CodegenArgument;
import io.swagger.codegen.v3.CodegenModel;
import io.swagger.codegen.v3.CodegenOperation;
import io.swagger.codegen.v3.CodegenProperty;
import io.swagger.codegen.v3.CodegenType;
import io.swagger.codegen.v3.SupportingFile;
import io.swagger.codegen.v3.VendorExtendable;
import io.swagger.codegen.v3.generators.handlebars.ExtensionHelper;
import io.swagger.codegen.v3.generators.java.AbstractJavaCodegen;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaInflectorServerCodegen
extends AbstractJavaCodegen {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaInflectorServerCodegen.class);
    protected String title = "Swagger Inflector";
    protected String implFolder = "src/main/java";

    public JavaInflectorServerCodegen() {
        this.sourceFolder = "src/gen/java";
        this.apiTestTemplateFiles.clear();
        this.invokerPackage = "io.swagger.controllers";
        this.artifactId = "swagger-inflector-server";
        this.dateLibrary = "legacy";
        this.modelDocTemplateFiles.remove("model_doc.mustache");
        this.apiDocTemplateFiles.remove("api_doc.mustache");
        this.apiPackage = System.getProperty("swagger.codegen.inflector.apipackage", "io.swagger.controllers");
        this.modelPackage = System.getProperty("swagger.codegen.inflector.modelpackage", "io.swagger.model");
        this.additionalProperties.put("title", this.title);
        this.additionalProperties.put("jackson", "true");
    }

    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    public String getName() {
        return "inflector";
    }

    public String getHelp() {
        return "Generates a Java Inflector Server application.";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.writeOptional(this.outputFolder, new SupportingFile("pom.mustache", "", "pom.xml"));
        this.writeOptional(this.outputFolder, new SupportingFile("README.mustache", "", "README.md"));
        this.writeOptional(this.outputFolder, new SupportingFile("web.mustache", "src/main/webapp/WEB-INF", "web.xml"));
        this.writeOptional(this.outputFolder, new SupportingFile("inflector.mustache", "", "inflector.yaml"));
        this.supportingFiles.add(new SupportingFile("openapi3.mustache", "src/main/resources", "openapi3.yaml"));
        this.supportingFiles.add(new SupportingFile("StringUtil.mustache", (this.sourceFolder + '/' + this.invokerPackage).replace(".", "/"), "StringUtil.java"));
    }

    @Override
    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        int pos;
        String basePath = resourcePath;
        if (basePath.startsWith("/")) {
            basePath = basePath.substring(1);
        }
        if ((pos = basePath.indexOf("/")) > 0) {
            basePath = basePath.substring(0, pos);
        }
        if (basePath == "") {
            basePath = "default";
        } else {
            if (co.path.startsWith("/" + basePath)) {
                co.path = co.path.substring(("/" + basePath).length());
            }
            co.subresourceOperation = !co.path.isEmpty();
        }
        List<CodegenOperation> opList = operations.get(basePath);
        if (opList == null) {
            opList = new ArrayList<CodegenOperation>();
            operations.put(basePath, opList);
        }
        opList.add(co);
        co.baseName = basePath;
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        Map operations = (Map)objs.get("operations");
        if (operations != null) {
            List ops = (List)operations.get("operation");
            for (CodegenOperation operation : ops) {
                int end;
                String rt;
                if (operation.returnType == null) {
                    operation.returnType = "Void";
                    continue;
                }
                if (operation.returnType.startsWith("List")) {
                    rt = operation.returnType;
                    end = rt.lastIndexOf(">");
                    if (end <= 0) continue;
                    operation.returnType = rt.substring("List<".length(), end);
                    operation.returnContainer = "List";
                    continue;
                }
                if (operation.returnType.startsWith("Map")) {
                    rt = operation.returnType;
                    end = rt.lastIndexOf(">");
                    if (end <= 0) continue;
                    operation.returnType = rt.substring("Map<".length(), end);
                    operation.returnContainer = "Map";
                    continue;
                }
                if (!operation.returnType.startsWith("Set") || (end = (rt = operation.returnType).lastIndexOf(">")) <= 0) continue;
                operation.returnType = rt.substring("Set<".length(), end);
                operation.returnContainer = "Set";
            }
        }
        return objs;
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        boolean isEnum = ExtensionHelper.getBooleanValue((VendorExtendable)model, "x-is-enum");
        if (!BooleanUtils.toBoolean((Boolean)isEnum)) {
            model.imports.add("JsonProperty");
            boolean hasEnums = ExtensionHelper.getBooleanValue((VendorExtendable)model, "x-has-enums");
            if (BooleanUtils.toBoolean((Boolean)hasEnums)) {
                model.imports.add("JsonValue");
            }
        }
    }

    @Override
    public Map<String, Object> postProcessModelsEnum(Map<String, Object> objs) {
        objs = super.postProcessModelsEnum(objs);
        List imports = (List)objs.get("imports");
        List models = (List)objs.get("models");
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            CodegenModel cm = (CodegenModel)mo.get("model");
            boolean isEnum = ExtensionHelper.getBooleanValue((VendorExtendable)cm, "x-is-enum");
            if (!Boolean.TRUE.equals(isEnum) || cm.allowableValues == null) continue;
            cm.imports.add(this.importMapping.get("JsonValue"));
            HashMap item = new HashMap();
            item.put("import", this.importMapping.get("JsonValue"));
            imports.add(item);
        }
        return objs;
    }

    @Override
    protected String getOrGenerateOperationId(Operation operation, String path, String httpMethod) {
        return super.getOrGenerateOperationId(operation, path, httpMethod.toUpperCase());
    }

    @Override
    public void setLanguageArguments(List<CodegenArgument> languageArguments) {
        if (languageArguments == null) {
            languageArguments = new ArrayList<CodegenArgument>();
        }
        if (!languageArguments.stream().anyMatch(codegenArgument -> "--model-docs".equalsIgnoreCase(codegenArgument.getOption()) && StringUtils.isNotBlank((CharSequence)codegenArgument.getValue()))) {
            languageArguments.add(new CodegenArgument().option("--model-docs").type("boolean").value(Boolean.FALSE.toString()));
        }
        if (!languageArguments.stream().anyMatch(codegenArgument -> "--api-docs".equalsIgnoreCase(codegenArgument.getOption()) && StringUtils.isNotBlank((CharSequence)codegenArgument.getValue()))) {
            languageArguments.add(new CodegenArgument().option("--api-docs").type("boolean").value(Boolean.FALSE.toString()));
        }
        if (!languageArguments.stream().anyMatch(codegenArgument -> "--model-tests".equalsIgnoreCase(codegenArgument.getOption()) && StringUtils.isNotBlank((CharSequence)codegenArgument.getValue()))) {
            languageArguments.add(new CodegenArgument().option("--model-tests").type("boolean").value(Boolean.FALSE.toString()));
        }
        if (!languageArguments.stream().anyMatch(codegenArgument -> "--api-tests".equalsIgnoreCase(codegenArgument.getOption()) && StringUtils.isNotBlank((CharSequence)codegenArgument.getValue()))) {
            languageArguments.add(new CodegenArgument().option("--api-tests").type("boolean").value(Boolean.FALSE.toString()));
        }
        super.setLanguageArguments(languageArguments);
    }

    @Override
    public String apiFilename(String templateName, String tag) {
        String result = super.apiFilename(templateName, tag);
        if (templateName.endsWith("api.mustache")) {
            int ix = result.indexOf(this.sourceFolder);
            String beg = result.substring(0, ix);
            String end = result.substring(ix + this.sourceFolder.length());
            new File(beg + this.implFolder).mkdirs();
            result = beg + this.implFolder + end;
        }
        return result;
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        OpenAPI openAPI = (OpenAPI)objs.get("openAPI");
        if (openAPI != null) {
            try {
                objs.put("openapi3-yaml", Yaml.mapper().writeValueAsString((Object)openAPI));
            }
            catch (JsonProcessingException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return super.postProcessSupportingFileData(objs);
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultController";
        }
        name = name.replaceAll("[^a-zA-Z0-9]+", "_");
        return JavaInflectorServerCodegen.camelize(name) + "Controller";
    }

    @Override
    public String getArgumentsLocation() {
        return "/arguments/inflector.yaml";
    }

    @Override
    public String getDefaultTemplateDir() {
        return "JavaInflector";
    }
}

