/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.languages.AbstractCSharpCodegen;
import java.io.File;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AspNet5ServerCodegen
extends AbstractCSharpCodegen {
    protected String sourceFolder;
    protected Logger LOGGER;

    public AspNet5ServerCodegen() {
        this.sourceFolder = "src" + File.separator + this.packageName;
        this.LOGGER = LoggerFactory.getLogger(AspNet5ServerCodegen.class);
        this.outputFolder = "generated-code" + File.separator + this.getName();
        this.modelTemplateFiles.put("model.mustache", ".cs");
        this.apiTemplateFiles.put("controller.mustache", ".cs");
        this.setReservedWordsLowerCase(Arrays.asList("var", "async", "await", "dynamic", "yield"));
        this.cliOptions.clear();
        this.addOption("packageName", "C# package name (convention: Title.Case).", this.packageName);
        this.addOption("packageVersion", "C# package version.", this.packageVersion);
        this.addOption("sourceFolder", "source folder for generated code", this.sourceFolder);
        this.addSwitch("sortParamsByRequiredFlag", "Sort method arguments to place required parameters before optional parameters.", this.sortParamsByRequiredFlag);
        this.addSwitch("useDateTimeOffset", "Use DateTimeOffset to model date-time properties", this.useDateTimeOffsetFlag);
        this.addSwitch("useCollection", "Deserialize array types to Collection<T> instead of List<T>.", this.useCollection);
        this.addSwitch("returnICollection", "Return ICollection<T> instead of the concrete type.", this.returnICollection);
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "aspnet5";
    }

    @Override
    public String getHelp() {
        return "Generates an ASP.NET 5 Web API server.";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.apiPackage = this.packageName + ".Controllers";
        this.modelPackage = this.packageName + ".Models";
        this.supportingFiles.add(new SupportingFile("NuGet.Config", "", "NuGet.Config"));
        this.supportingFiles.add(new SupportingFile("global.json", "", "global.json"));
        this.supportingFiles.add(new SupportingFile("build.sh.mustache", "", "build.sh"));
        this.supportingFiles.add(new SupportingFile("build.bat.mustache", "", "build.bat"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("Solution.mustache", "", this.packageName + ".sln"));
        this.supportingFiles.add(new SupportingFile("Dockerfile.mustache", this.sourceFolder, "Dockerfile"));
        this.supportingFiles.add(new SupportingFile("gitignore", this.sourceFolder, ".gitignore"));
        this.supportingFiles.add(new SupportingFile("appsettings.json", this.sourceFolder, "appsettings.json"));
        this.supportingFiles.add(new SupportingFile("project.json.mustache", this.sourceFolder, "project.json"));
        this.supportingFiles.add(new SupportingFile("Startup.mustache", this.sourceFolder, "Startup.cs"));
        this.supportingFiles.add(new SupportingFile("Program.mustache", this.sourceFolder, "Program.cs"));
        this.supportingFiles.add(new SupportingFile("web.config", this.sourceFolder, "web.config"));
        this.supportingFiles.add(new SupportingFile("Project.xproj.mustache", this.sourceFolder, this.packageName + ".xproj"));
        this.supportingFiles.add(new SupportingFile("Properties" + File.separator + "launchSettings.json", this.sourceFolder + File.separator + "Properties", "launchSettings.json"));
        this.supportingFiles.add(new SupportingFile("wwwroot" + File.separator + "README.md", this.sourceFolder + File.separator + "wwwroot", "README.md"));
        this.supportingFiles.add(new SupportingFile("wwwroot" + File.separator + "index.html", this.sourceFolder + File.separator + "wwwroot", "index.html"));
        this.supportingFiles.add(new SupportingFile("wwwroot" + File.separator + "web.config", this.sourceFolder + File.separator + "wwwroot", "web.config"));
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + "Controllers";
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + "Models";
    }

    @Override
    protected void processOperation(CodegenOperation operation) {
        super.processOperation(operation);
        if (operation.path != null) {
            String original = operation.path;
            operation.path = operation.path.replace("?", "/");
            if (!original.equals(operation.path)) {
                this.LOGGER.warn("Normalized " + original + " to " + operation.path + ". Please verify generated source.");
            }
        }
        operation.httpMethod = "Http" + operation.httpMethod.substring(0, 1) + operation.httpMethod.substring(1).toLowerCase();
    }
}

