/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.languages.AbstractCSharpCodegen;
import io.swagger.models.Swagger;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NancyFXServerCodegen
extends AbstractCSharpCodegen {
    private static final Logger log = LoggerFactory.getLogger(NancyFXServerCodegen.class);
    private static final String API_NAMESPACE = "Modules";
    private static final String MODEL_NAMESPACE = "Models";
    private static final String IMMUTABLE_OPTION = "immutable";
    private static final Map<String, Predicate<Property>> propertyToSwaggerTypeMapping = NancyFXServerCodegen.createPropertyToSwaggerTypeMapping();
    private final String packageGuid = "{" + UUID.randomUUID().toString().toUpperCase() + "}";
    private final Map<String, DependencyInfo> dependencies = new HashMap<String, DependencyInfo>();
    private final Set<String> parentModels = new HashSet<String>();
    private final Multimap<String, CodegenModel> childrenByParent = ArrayListMultimap.create();
    private final BiMap<String, String> modelNameMapping = HashBiMap.create();

    public NancyFXServerCodegen() {
        this.outputFolder = "generated-code" + File.separator + this.getName();
        this.apiTemplateFiles.put("api.mustache", ".cs");
        this.setReservedWordsLowerCase(Arrays.asList("var", "async", "await", "dynamic", "yield"));
        this.cliOptions.clear();
        this.addOption("packageName", "C# package name (convention: Title.Case).", this.packageName);
        this.addOption("packageVersion", "C# package version.", this.packageVersion);
        this.addOption("sourceFolder", "source folder for generated code", this.sourceFolder);
        this.addSwitch("sortParamsByRequiredFlag", "Sort method arguments to place required parameters before optional parameters.", this.sortParamsByRequiredFlag);
        this.addSwitch("optionalProjectFile", "Generate {PackageName}.csproj.", this.optionalProjectFileFlag);
        this.addSwitch("useDateTimeOffset", "Use DateTimeOffset to model date-time properties", this.useDateTimeOffsetFlag);
        this.addSwitch("useCollection", "Deserialize array types to Collection<T> instead of List<T>.", this.useCollection);
        this.addSwitch("returnICollection", "Return ICollection<T> instead of the concrete type.", this.returnICollection);
        this.addSwitch(IMMUTABLE_OPTION, "Enabled by default. If disabled generates model classes with setters", true);
        this.typeMapping.putAll(NancyFXServerCodegen.nodaTimeTypesMappings());
        this.languageSpecificPrimitives.addAll(NancyFXServerCodegen.nodaTimePrimitiveTypes());
        this.importMapping.clear();
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "nancyfx";
    }

    @Override
    public String getHelp() {
        return "Generates a NancyFX Web API server.";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.apiPackage = Strings.isNullOrEmpty((String)this.packageName) ? API_NAMESPACE : this.packageName + "." + API_NAMESPACE;
        this.modelPackage = Strings.isNullOrEmpty((String)this.packageName) ? MODEL_NAMESPACE : this.packageName + "." + MODEL_NAMESPACE;
        this.supportingFiles.add(new SupportingFile("parameters.mustache", this.sourceFile("Utils"), "Parameters.cs"));
        this.supportingFiles.add(new SupportingFile("packages.config.mustache", this.sourceFolder(), "packages.config"));
        this.supportingFiles.add(new SupportingFile("nuspec.mustache", this.sourceFolder(), this.packageName + ".nuspec"));
        if (this.optionalProjectFileFlag) {
            this.supportingFiles.add(new SupportingFile("Solution.mustache", "", this.packageName + ".sln"));
            this.supportingFiles.add(new SupportingFile("Project.mustache", this.sourceFolder(), this.packageName + ".csproj"));
        }
        this.additionalProperties.put("packageGuid", this.packageGuid);
        this.setupModelTemplate();
        this.processImportedMappings();
        this.appendDependencies();
    }

    private void setupModelTemplate() {
        Object immutableOption = this.additionalProperties.get(IMMUTABLE_OPTION);
        if (immutableOption != null && "false".equalsIgnoreCase(immutableOption.toString())) {
            log.info("Using mutable model template");
            this.modelTemplateFiles.put("modelMutable.mustache", ".cs");
        } else {
            log.info("Using immutable model template");
            this.modelTemplateFiles.put("model.mustache", ".cs");
        }
    }

    private void processImportedMappings() {
        for (Map.Entry entry : ImmutableSet.copyOf(this.importMapping.entrySet())) {
            String assemblyFramework;
            String model = (String)entry.getKey();
            String[] namespaceInfo = ((String)entry.getValue()).split("\\s");
            String[] namespace = (namespaceInfo.length > 0 ? namespaceInfo[0].trim() : "").split(":");
            String namespaceName = namespace.length > 0 ? namespace[0].trim() : null;
            String modelClass = namespace.length > 1 ? namespace[1].trim() : null;
            String assembly = namespaceInfo.length > 1 ? namespaceInfo[1].trim() : null;
            String assemblyVersion = namespaceInfo.length > 2 ? namespaceInfo[2].trim() : null;
            String string = assemblyFramework = namespaceInfo.length > 3 ? namespaceInfo[3].trim() : "net45";
            if (Strings.isNullOrEmpty((String)model) || Strings.isNullOrEmpty((String)namespaceName)) {
                log.warn(String.format("Could not import: '%s' - invalid namespace: '%s'", model, entry.getValue()));
                this.importMapping.remove(model);
            } else {
                log.info(String.format("Importing: '%s' from '%s' namespace.", model, namespaceName));
                this.importMapping.put(model, namespaceName);
            }
            if (!Strings.isNullOrEmpty((String)modelClass)) {
                log.info(String.format("Mapping: '%s' class to '%s'", model, modelClass));
                this.modelNameMapping.put((Object)model, (Object)modelClass);
            }
            if (assembly == null || assemblyVersion == null) continue;
            log.info(String.format("Adding dependency: '%s', version: '%s', framework: '%s'", assembly, assemblyVersion, assemblyVersion));
            this.dependencies.put(assembly, new DependencyInfo(assemblyVersion, assemblyFramework));
        }
    }

    private void appendDependencies() {
        ArrayList listOfDependencies = new ArrayList();
        for (Map.Entry<String, DependencyInfo> dependency : this.dependencies.entrySet()) {
            HashMap<String, String> dependencyInfo = new HashMap<String, String>();
            dependencyInfo.put("dependency", dependency.getKey());
            dependencyInfo.put("dependencyVersion", dependency.getValue().version);
            dependencyInfo.put("dependencyFramework", dependency.getValue().framework);
            listOfDependencies.add(dependencyInfo);
        }
        this.additionalProperties.put("dependencies", listOfDependencies);
    }

    private String sourceFolder() {
        return "src" + File.separator + this.packageName;
    }

    private String sourceFile(String fileName) {
        return this.sourceFolder() + File.separator + fileName;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder() + File.separator + API_NAMESPACE;
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder() + File.separator + MODEL_NAMESPACE;
    }

    @Override
    protected void processOperation(CodegenOperation operation) {
        super.processOperation(operation);
        if (!Strings.isNullOrEmpty((String)operation.path) && operation.path.contains("?")) {
            operation.path = operation.path.replace("?", "/");
        }
        if (!Strings.isNullOrEmpty((String)operation.httpMethod)) {
            operation.httpMethod = StringUtils.capitalize((String)operation.httpMethod.toLowerCase());
        }
    }

    @Override
    public Map<String, Object> postProcessAllModels(Map<String, Object> models) {
        Map<String, Object> processed = super.postProcessAllModels(models);
        this.postProcessParentModels(models);
        return processed;
    }

    private void postProcessParentModels(Map<String, Object> models) {
        log.debug("Processing parents:  " + this.parentModels);
        for (String parent : this.parentModels) {
            CodegenModel parentModel = this.modelByName(parent, models);
            parentModel.hasChildren = true;
            Collection childrenModels = this.childrenByParent.get((Object)parent);
            for (CodegenModel child : childrenModels) {
                this.processParentPropertiesInChildModel(parentModel, child);
            }
        }
    }

    private CodegenModel modelByName(String name, Map<String, Object> models) {
        Map dataMap;
        Object dataModels;
        Object data = models.get(name);
        if (data instanceof Map && (dataModels = (dataMap = (Map)data).get("models")) instanceof List) {
            List dataModelsList = (List)dataModels;
            for (Object entry : dataModelsList) {
                Map entryMap;
                Object model;
                if (!(entry instanceof Map) || !((model = (entryMap = (Map)entry).get("model")) instanceof CodegenModel)) continue;
                return (CodegenModel)model;
            }
        }
        return null;
    }

    private void processParentPropertiesInChildModel(CodegenModel parent, CodegenModel child) {
        HashMap<String, CodegenProperty> childPropertiesByName = new HashMap<String, CodegenProperty>(child.vars.size());
        for (CodegenProperty property : child.vars) {
            childPropertiesByName.put(property.name, property);
        }
        CodegenProperty previousParentVar = null;
        for (CodegenProperty property : parent.vars) {
            CodegenProperty duplicatedByParent = (CodegenProperty)childPropertiesByName.get(property.name);
            if (duplicatedByParent == null) continue;
            log.info(String.format("Property: '%s' in '%s' model is inherited from '%s'", property.name, child.classname, parent.classname));
            duplicatedByParent.isInherited = true;
            CodegenProperty parentVar = duplicatedByParent.clone();
            parentVar.hasMore = false;
            child.parentVars.add(parentVar);
            if (previousParentVar != null) {
                previousParentVar.hasMore = true;
            }
            previousParentVar = parentVar;
        }
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        if (!Strings.isNullOrEmpty((String)model.parent)) {
            this.parentModels.add(model.parent);
            if (!this.childrenByParent.containsEntry((Object)model.parent, (Object)model)) {
                this.childrenByParent.put((Object)model.parent, (Object)model);
            }
        }
    }

    @Override
    public String toEnumVarName(String name, String datatype) {
        String enumName = NancyFXServerCodegen.camelize(this.sanitizeName(name).replaceFirst("^_", "").replaceFirst("_$", "").replaceAll("-", "_"));
        String result = enumName.matches("\\d.*") ? "_" + enumName : enumName;
        log.debug(String.format("toEnumVarName('%s', %s) = '%s'", name, datatype, enumName));
        return result;
    }

    @Override
    public String toApiName(String name) {
        String apiName = Strings.isNullOrEmpty((String)name) ? "Default" : StringUtils.capitalize((String)name);
        log.debug(String.format("toApiName('%s') = '%s'", name, apiName));
        return apiName;
    }

    @Override
    public String toApiFilename(String name) {
        return super.toApiFilename(name) + "Module";
    }

    @Override
    public String toModelImport(String name) {
        String modelName;
        String result = this.modelNameMapping.containsValue((Object)name) ? (this.importMapping.containsKey(modelName = (String)this.modelNameMapping.inverse().get((Object)name)) ? (String)this.importMapping.get(modelName) : super.toModelImport(name)) : (this.importMapping.containsKey(name) ? (String)this.importMapping.get(name) : null);
        log.debug(String.format("toModelImport('%s') = '%s'", name, result));
        return result;
    }

    @Override
    public String toModelName(String name) {
        String modelName = super.toModelName(name);
        String mappedModelName = (String)this.modelNameMapping.get((Object)modelName);
        return Strings.isNullOrEmpty((String)mappedModelName) ? modelName : mappedModelName;
    }

    @Override
    public void preprocessSwagger(Swagger swagger) {
        this.additionalProperties.put("packageContext", this.sanitizeName(swagger.getBasePath()));
        this.additionalProperties.put("baseContext", swagger.getBasePath());
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        return this.sanitizeName(NancyFXServerCodegen.camelize(property.name)) + "Enum";
    }

    @Override
    public String getSwaggerType(Property property) {
        for (Map.Entry<String, Predicate<Property>> entry : propertyToSwaggerTypeMapping.entrySet()) {
            if (!entry.getValue().apply((Object)property)) continue;
            return entry.getKey();
        }
        return super.getSwaggerType(property);
    }

    private static Map<String, Predicate<Property>> createPropertyToSwaggerTypeMapping() {
        ImmutableMap.Builder mapping = ImmutableMap.builder();
        mapping.put((Object)"time", NancyFXServerCodegen.timeProperty());
        return mapping.build();
    }

    private static Predicate<Property> timeProperty() {
        return new Predicate<Property>(){

            public boolean apply(Property property) {
                return property instanceof StringProperty && "time".equalsIgnoreCase(property.getFormat());
            }
        };
    }

    private static Map<String, String> nodaTimeTypesMappings() {
        return ImmutableMap.of((Object)"time", (Object)"LocalTime?", (Object)"date", (Object)"ZonedDateTime?", (Object)"datetime", (Object)"ZonedDateTime?");
    }

    private static Set<String> nodaTimePrimitiveTypes() {
        return ImmutableSet.of((Object)"LocalTime?", (Object)"ZonedDateTime?");
    }

    private class DependencyInfo {
        private final String version;
        private final String framework;

        private DependencyInfo(String version, String framework) {
            this.version = version;
            this.framework = framework;
        }
    }
}

