/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenParameter;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.models.properties.Property;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErlangClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    static Logger LOGGER = LoggerFactory.getLogger(ErlangClientCodegen.class);
    protected String packageName = "swagger";
    protected String packageVersion = "1.0.0";
    protected String sourceFolder = "src";

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "erlang-client";
    }

    @Override
    public String getHelp() {
        return "Generates an Erlang client library (beta).";
    }

    public ErlangClientCodegen() {
        this.outputFolder = "generated-code/erlang";
        this.modelTemplateFiles.put("model.mustache", ".erl");
        this.apiTemplateFiles.put("api.mustache", ".erl");
        this.templateDir = "erlang-client";
        this.embeddedTemplateDir = "erlang-client";
        this.setReservedWordsLowerCase(Arrays.asList("after", "and", "andalso", "band", "begin", "bnot", "bor", "bsl", "bsr", "bxor", "case", "catch", "cond", "div", "end", "fun", "if", "let", "not", "of", "or", "orelse", "receive", "rem", "try", "when", "xor"));
        this.instantiationTypes.clear();
        this.typeMapping.clear();
        this.typeMapping.put("enum", "binary()");
        this.typeMapping.put("date", "calendar:date()");
        this.typeMapping.put("datetime", "calendar:datetime()");
        this.typeMapping.put("date-time", "calendar:datetime()");
        this.typeMapping.put("boolean", "boolean()");
        this.typeMapping.put("string", "binary()");
        this.typeMapping.put("integer", "integer()");
        this.typeMapping.put("int", "integer()");
        this.typeMapping.put("float", "integer()");
        this.typeMapping.put("long", "integer()");
        this.typeMapping.put("double", "float()");
        this.typeMapping.put("array", "list()");
        this.typeMapping.put("map", "maps:map()");
        this.typeMapping.put("number", "integer()");
        this.typeMapping.put("bigdecimal", "float()");
        this.typeMapping.put("List", "list()");
        this.typeMapping.put("object", "maps:map()");
        this.typeMapping.put("file", "binary()");
        this.typeMapping.put("binary", "binary()");
        this.typeMapping.put("bytearray", "binary()");
        this.typeMapping.put("byte", "binary()");
        this.typeMapping.put("uuid", "binary()");
        this.typeMapping.put("password", "binary()");
        this.cliOptions.clear();
        this.cliOptions.add(new CliOption("packageName", "Erlang application name (convention: lowercase).").defaultValue(this.packageName));
        this.cliOptions.add(new CliOption("packageName", "Erlang application version").defaultValue(this.packageVersion));
    }

    @Override
    public String getTypeDeclaration(String name) {
        return name + ":" + name + "()";
    }

    @Override
    public String getTypeDeclaration(Property p) {
        String swaggerType = this.getSwaggerType(p);
        if (this.typeMapping.containsKey(swaggerType)) {
            return (String)this.typeMapping.get(swaggerType);
        }
        return swaggerType;
    }

    @Override
    public String getSwaggerType(Property p) {
        String swaggerType = super.getSwaggerType(p);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = this.getTypeDeclaration(this.toModelName(this.snakeCase(swaggerType)));
        }
        return type;
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
        } else {
            this.setPackageName("swagger");
        }
        if (this.additionalProperties.containsKey("packageVersion")) {
            this.setPackageVersion((String)this.additionalProperties.get("packageVersion"));
        } else {
            this.setPackageVersion("1.0.0");
        }
        this.additionalProperties.put("packageName", this.packageName);
        this.additionalProperties.put("packageVersion", this.packageVersion);
        this.additionalProperties.put("length", new Mustache.Lambda(){

            public void execute(Template.Fragment fragment, Writer writer) throws IOException {
                writer.write(ErlangClientCodegen.this.length(fragment.context()));
            }
        });
        this.additionalProperties.put("qsEncode", new Mustache.Lambda(){

            public void execute(Template.Fragment fragment, Writer writer) throws IOException {
                writer.write(ErlangClientCodegen.this.qsEncode(fragment.context()));
            }
        });
        this.modelPackage = this.packageName;
        this.apiPackage = this.packageName;
        this.supportingFiles.add(new SupportingFile("rebar.config.mustache", "", "rebar.config"));
        this.supportingFiles.add(new SupportingFile("app.src.mustache", "", "src" + File.separator + this.packageName + ".app.src"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
    }

    public String qsEncode(Object o) {
        String r = new String();
        CodegenParameter q = (CodegenParameter)o;
        if (q.required) {
            r = q.isListContainer ? r + "[{<<\"" + q.baseName + "\">>, X} || X <- " + q.paramName + "]" : r + "{<<\"" + q.baseName + "\">>, " + q.paramName + "}";
        }
        return r;
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return ErlangClientCodegen.camelize(name) + '_';
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator;
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator;
    }

    @Override
    public String toVarName(String name) {
        if (this.isReservedWord(name = this.sanitizeName(name.replaceAll("-", "_")))) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        return ErlangClientCodegen.camelize(this.toVarName(name));
    }

    @Override
    public String toModelName(String name) {
        return this.packageName + "_" + ErlangClientCodegen.underscore(name.replaceAll("-", "_"));
    }

    @Override
    public String toApiName(String name) {
        return this.packageName + "_" + ErlangClientCodegen.underscore(name.replaceAll("-", "_"));
    }

    @Override
    public String toModelFilename(String name) {
        return this.packageName + "_" + ErlangClientCodegen.underscore(name);
    }

    @Override
    public String toApiFilename(String name) {
        name = name.replaceAll("-", "_");
        return this.packageName + "_" + ErlangClientCodegen.underscore(name) + "_api";
    }

    @Override
    public String toOperationId(String operationId) {
        if (this.isReservedWord(operationId)) {
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + ErlangClientCodegen.underscore(this.sanitizeName("call_" + operationId)));
            operationId = "call_" + operationId;
        }
        return ErlangClientCodegen.underscore(operationId);
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        Map operations = (Map)objs.get("operations");
        List os = (List)operations.get("operation");
        ArrayList<ExtendedCodegenOperation> newOs = new ArrayList<ExtendedCodegenOperation>();
        Pattern pattern = Pattern.compile("\\{([^\\}]+)\\}");
        for (CodegenOperation o : os) {
            o.httpMethod = o.httpMethod.toLowerCase();
            if (o.isListContainer) {
                o.returnType = "[" + o.returnBaseType + "]";
            }
            ArrayList<String> pathTemplateNames = new ArrayList<String>();
            Matcher matcher = pattern.matcher(o.path);
            StringBuffer buffer = new StringBuffer();
            while (matcher.find()) {
                String pathTemplateName = matcher.group(1);
                matcher.appendReplacement(buffer, "\", " + ErlangClientCodegen.camelize(pathTemplateName) + ", \"");
                pathTemplateNames.add(pathTemplateName);
            }
            matcher.appendTail(buffer);
            ExtendedCodegenOperation eco = new ExtendedCodegenOperation(o);
            if (buffer.toString().isEmpty()) {
                eco.setReplacedPathName(o.path);
            } else {
                eco.setReplacedPathName(buffer.toString());
            }
            eco.setPathTemplateNames(pathTemplateNames);
            newOs.add(eco);
        }
        operations.put("operation", newOs);
        return objs;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    String length(Object os) {
        int l = 1;
        Iterator iterator = ((ExtendedCodegenOperation)os).allParams.iterator();
        while (iterator.hasNext()) {
            CodegenParameter o;
            CodegenParameter q = o = (CodegenParameter)iterator.next();
            if (!q.required) continue;
            ++l;
        }
        return Integer.toString(l);
    }

    int lengthRequired(List<CodegenParameter> allParams) {
        int l = 0;
        Iterator<CodegenParameter> iterator = allParams.iterator();
        while (iterator.hasNext()) {
            CodegenParameter o;
            CodegenParameter q = o = iterator.next();
            if (!q.required && !q.isBodyParam) continue;
            ++l;
        }
        return l;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    class ExtendedCodegenOperation
    extends CodegenOperation {
        private List<String> pathTemplateNames = new ArrayList<String>();
        private String replacedPathName;
        String arityRequired;
        String arityOptional;

        public ExtendedCodegenOperation(CodegenOperation o) {
            this.responseHeaders.addAll(o.responseHeaders);
            this.hasAuthMethods = o.hasAuthMethods;
            this.hasConsumes = o.hasConsumes;
            this.hasProduces = o.hasProduces;
            this.hasParams = o.hasParams;
            this.hasOptionalParams = o.hasOptionalParams;
            this.returnTypeIsPrimitive = o.returnTypeIsPrimitive;
            this.returnSimpleType = o.returnSimpleType;
            this.subresourceOperation = o.subresourceOperation;
            this.isMapContainer = o.isMapContainer;
            this.isListContainer = o.isListContainer;
            this.isMultipart = o.isMultipart;
            this.hasMore = o.hasMore;
            this.isResponseBinary = o.isResponseBinary;
            this.hasReference = o.hasReference;
            this.isRestfulIndex = o.isRestfulIndex;
            this.isRestfulShow = o.isRestfulShow;
            this.isRestfulCreate = o.isRestfulCreate;
            this.isRestfulUpdate = o.isRestfulUpdate;
            this.isRestfulDestroy = o.isRestfulDestroy;
            this.isRestful = o.isRestful;
            this.path = o.path;
            this.operationId = o.operationId;
            this.returnType = o.returnType;
            this.httpMethod = o.httpMethod;
            this.returnBaseType = o.returnBaseType;
            this.returnContainer = o.returnContainer;
            this.summary = o.summary;
            this.unescapedNotes = o.unescapedNotes;
            this.notes = o.notes;
            this.baseName = o.baseName;
            this.defaultResponse = o.defaultResponse;
            this.discriminator = o.discriminator;
            this.consumes = o.consumes;
            this.produces = o.produces;
            this.bodyParam = o.bodyParam;
            this.allParams = o.allParams;
            this.arityRequired = Integer.toString(ErlangClientCodegen.this.lengthRequired(o.allParams));
            this.arityOptional = Integer.toString(ErlangClientCodegen.this.lengthRequired(o.allParams) + 1);
            this.bodyParams = o.bodyParams;
            this.pathParams = o.pathParams;
            this.queryParams = o.queryParams;
            this.headerParams = o.headerParams;
            this.formParams = o.formParams;
            this.authMethods = o.authMethods;
            this.tags = o.tags;
            this.responses = o.responses;
            this.imports = o.imports;
            this.examples = o.examples;
            this.externalDocs = o.externalDocs;
            this.vendorExtensions = o.vendorExtensions;
            this.nickname = o.nickname;
            this.operationIdLowerCase = o.operationIdLowerCase;
            this.operationIdCamelCase = o.operationIdCamelCase;
        }

        public List<String> getPathTemplateNames() {
            return this.pathTemplateNames;
        }

        public void setPathTemplateNames(List<String> pathTemplateNames) {
            this.pathTemplateNames = pathTemplateNames;
        }

        public String getReplacedPathName() {
            return this.replacedPathName;
        }

        public void setReplacedPathName(String replacedPathName) {
            this.replacedPathName = replacedPathName;
        }
    }
}

