/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.samskivert.mustache.Mustache;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenSecurity;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.languages.AbstractCSharpCodegen;
import io.swagger.models.Swagger;
import io.swagger.models.auth.SecuritySchemeDefinition;
import io.swagger.util.Json;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AspNetCoreServerCodegen
extends AbstractCSharpCodegen {
    private String packageGuid = "{" + UUID.randomUUID().toString().toUpperCase() + "}";
    private final String DEFAULT_ASP_NET_CORE_VERSION = "2.2";
    private String aspNetCoreVersion;
    protected Logger LOGGER = LoggerFactory.getLogger(AspNetCoreServerCodegen.class);

    public AspNetCoreServerCodegen() {
        this.setSourceFolder("src");
        this.outputFolder = "generated-code" + File.separator + this.getName();
        this.modelTemplateFiles.put("model.mustache", ".cs");
        this.aspNetCoreVersion = "2.2";
        this.reservedWords.addAll(Arrays.asList("var", "async", "await", "dynamic", "yield"));
        this.cliOptions.clear();
        this.addOption("packageName", "C# package name (convention: Title.Case).", this.packageName);
        this.addOption("packageVersion", "C# package version.", this.packageVersion);
        this.addOption("packageGuid", "The GUID that will be associated with the C# project", null);
        this.addOption("sourceFolder", "source folder for generated code", this.sourceFolder);
        this.addOption("aspnetCoreVersion", "aspnetcore version to use, current options are: 2.0, 2.1 and 2.2 (default)", this.aspNetCoreVersion);
        this.addOption("interface-only", "creates interfaces controller only", null);
        this.addOption("interface-controller", "creates interfaces and default implementation for controllers", null);
        this.addOption("preserveNewlinesInComments", "Preserve newlines in comments", String.valueOf(this.preserveNewLines));
        this.addSwitch("sortParamsByRequiredFlag", "Sort method arguments to place required parameters before optional parameters.", this.sortParamsByRequiredFlag);
        this.addSwitch("useDateTimeOffset", "Use DateTimeOffset to model date-time properties", this.useDateTimeOffsetFlag);
        this.addSwitch("useCollection", "Deserialize array types to Collection<T> instead of List<T>.", this.useCollection);
        this.addSwitch("returnICollection", "Return ICollection<T> instead of the concrete type.", this.returnICollection);
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "aspnetcore";
    }

    @Override
    public String getHelp() {
        return "Generates an ASP.NET Core Web API server.";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("aspnetCoreVersion")) {
            this.setAspNetCoreVersion(String.valueOf(this.additionalProperties.get("aspnetCoreVersion")));
        }
        if (this.additionalProperties.containsKey("packageGuid")) {
            this.setPackageGuid((String)this.additionalProperties.get("packageGuid"));
        }
        String packageFolder = this.sourceFolder + File.separator + this.packageName;
        boolean interfaceOnly = Boolean.valueOf(String.valueOf(this.additionalProperties.get("interface-only")));
        boolean interfaceController = Boolean.valueOf(String.valueOf(this.additionalProperties.get("interface-controller")));
        if (this.aspNetCoreVersion.equals("2.0")) {
            this.apiTemplateFiles.put("controller.mustache", ".cs");
            this.addInterfaceControllerTemplate(interfaceOnly, interfaceController);
            this.supportingFiles.add(new SupportingFile("Program.mustache", packageFolder, "Program.cs"));
            this.supportingFiles.add(new SupportingFile("Project.csproj.mustache", packageFolder, this.packageName + ".csproj"));
            this.supportingFiles.add(new SupportingFile("Dockerfile.mustache", packageFolder, "Dockerfile"));
        } else {
            this.apiTemplateFiles.put("2.1/controller.mustache", ".cs");
            this.addInterfaceControllerTemplate(interfaceOnly, interfaceController);
            this.supportingFiles.add(new SupportingFile("2.1/Program.mustache", packageFolder, "Program.cs"));
            this.supportingFiles.add(new SupportingFile("2.1/Project.csproj.mustache", packageFolder, this.packageName + ".csproj"));
            this.supportingFiles.add(new SupportingFile("2.1/Dockerfile.mustache", packageFolder, "Dockerfile"));
        }
        this.additionalProperties.put("aspNetCoreVersion", this.aspNetCoreVersion);
        this.additionalProperties.put("packageGuid", this.packageGuid);
        this.additionalProperties.put("dockerTag", this.packageName.toLowerCase());
        this.apiPackage = this.packageName + ".Controllers";
        this.modelPackage = this.packageName + ".Models";
        this.supportingFiles.add(new SupportingFile("NuGet.Config", "", "NuGet.Config"));
        this.supportingFiles.add(new SupportingFile("build.sh.mustache", "", "build.sh"));
        this.supportingFiles.add(new SupportingFile("build.bat.mustache", "", "build.bat"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("Solution.mustache", "", this.packageName + ".sln"));
        this.supportingFiles.add(new SupportingFile("Dockerfile.mustache", packageFolder, "Dockerfile"));
        this.supportingFiles.add(new SupportingFile("gitignore", packageFolder, ".gitignore"));
        this.supportingFiles.add(new SupportingFile("appsettings.json", packageFolder, "appsettings.json"));
        this.supportingFiles.add(new SupportingFile("Startup.mustache", packageFolder, "Startup.cs"));
        this.supportingFiles.add(new SupportingFile("validateModel.mustache", packageFolder + File.separator + "Attributes", "ValidateModelStateAttribute.cs"));
        this.supportingFiles.add(new SupportingFile("web.config", packageFolder, "web.config"));
        this.supportingFiles.add(new SupportingFile("Properties" + File.separator + "launchSettings.json", packageFolder + File.separator + "Properties", "launchSettings.json"));
        this.supportingFiles.add(new SupportingFile("Filters" + File.separator + "BasePathFilter.mustache", packageFolder + File.separator + "Filters", "BasePathFilter.cs"));
        this.supportingFiles.add(new SupportingFile("Filters" + File.separator + "GeneratePathParamsValidationFilter.mustache", packageFolder + File.separator + "Filters", "GeneratePathParamsValidationFilter.cs"));
        this.supportingFiles.add(new SupportingFile("wwwroot" + File.separator + "README.md", packageFolder + File.separator + "wwwroot", "README.md"));
        this.supportingFiles.add(new SupportingFile("wwwroot" + File.separator + "index.html", packageFolder + File.separator + "wwwroot", "index.html"));
        this.supportingFiles.add(new SupportingFile("wwwroot" + File.separator + "web.config", packageFolder + File.separator + "wwwroot", "web.config"));
        this.supportingFiles.add(new SupportingFile("wwwroot" + File.separator + "swagger-original.mustache", packageFolder + File.separator + "wwwroot", "swagger-original.json"));
    }

    @Override
    public void setSourceFolder(String sourceFolder) {
        if (sourceFolder == null) {
            this.LOGGER.warn("No sourceFolder specified, using default");
            this.sourceFolder = "src" + File.separator + this.packageName;
        } else if (!sourceFolder.equals("src") && !sourceFolder.startsWith("src")) {
            this.LOGGER.warn("ASP.NET Core requires source code exists under src. Adjusting.");
            this.sourceFolder = "src" + File.separator + sourceFolder;
        } else {
            this.sourceFolder = sourceFolder;
        }
    }

    public void setPackageGuid(String packageGuid) {
        this.packageGuid = packageGuid;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.packageName + File.separator + "Controllers";
    }

    @Override
    public String apiFilename(String templateName, String tag) {
        boolean isInterface = templateName.equalsIgnoreCase("icontroller.mustache");
        String suffix = this.apiTemplateFiles().get(templateName);
        if (isInterface) {
            return this.apiFileFolder() + "/I" + this.toApiFilename(tag) + suffix;
        }
        return this.apiFileFolder() + '/' + this.toApiFilename(tag) + suffix;
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.packageName + File.separator + "Models";
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        Swagger swagger = (Swagger)objs.get("swagger");
        if (swagger != null) {
            try {
                objs.put("swagger-json", Json.pretty().writeValueAsString((Object)swagger).replace("\r\n", "\n"));
            }
            catch (JsonProcessingException e) {
                this.LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return super.postProcessSupportingFileData(objs);
    }

    @Override
    protected void processOperation(CodegenOperation operation) {
        super.processOperation(operation);
        if (operation.path != null) {
            String original = operation.path;
            operation.path = operation.path.replace("?", "/");
            if (!original.equals(operation.path)) {
                this.LOGGER.warn("Normalized " + original + " to " + operation.path + ". Please verify generated source.");
            }
        }
        operation.httpMethod = "Http" + operation.httpMethod.substring(0, 1) + operation.httpMethod.substring(1).toLowerCase();
    }

    @Override
    public Mustache.Compiler processCompiler(Mustache.Compiler compiler) {
        return super.processCompiler(compiler).emptyStringIsFalse(true);
    }

    @Override
    public List<CodegenSecurity> fromSecurity(Map<String, SecuritySchemeDefinition> schemes) {
        List<CodegenSecurity> securities = super.fromSecurity(schemes);
        if (securities == null || securities.isEmpty()) {
            return securities;
        }
        boolean hasBasic = false;
        boolean hasBearer = false;
        boolean hasApiKey = false;
        for (int index = 0; index < securities.size(); ++index) {
            CodegenSecurity codegenSecurity = securities.get(index);
            if (codegenSecurity.isBasic.booleanValue()) {
                hasBasic = true;
            }
            if (!codegenSecurity.isApiKey.booleanValue()) continue;
            hasApiKey = true;
        }
        String packageFolder = this.sourceFolder + File.separator + this.packageName;
        if (hasBasic) {
            this.supportingFiles.add(new SupportingFile("Security/BasicAuthenticationHandler.mustache", packageFolder + File.separator + "Security", "BasicAuthenticationHandler.cs"));
        }
        if (hasBearer) {
            this.supportingFiles.add(new SupportingFile("Security/BearerAuthenticationHandler.mustache", packageFolder + File.separator + "Security", "BearerAuthenticationHandler.cs"));
        }
        if (hasApiKey) {
            this.supportingFiles.add(new SupportingFile("Security/ApiKeyAuthenticationHandler.mustache", packageFolder + File.separator + "Security", "ApiKeyAuthenticationHandler.cs"));
        }
        return securities;
    }

    private void addInterfaceControllerTemplate(boolean interfaceOnly, boolean interfaceController) {
        if (interfaceController) {
            this.apiTemplateFiles.put("icontroller.mustache", ".cs");
            this.additionalProperties.put("interfaceController", Boolean.TRUE);
        }
        if (interfaceOnly) {
            this.apiTemplateFiles.clear();
            this.apiTemplateFiles.put("icontroller.mustache", ".cs");
        }
    }

    private void setAspNetCoreVersion(String optionValue) {
        if (StringUtils.isBlank((CharSequence)optionValue)) {
            return;
        }
        this.aspNetCoreVersion = optionValue;
        if (!(this.aspNetCoreVersion.equals("2.0") || this.aspNetCoreVersion.equals("2.1") || this.aspNetCoreVersion.equals("2.2"))) {
            this.LOGGER.error("version '" + this.aspNetCoreVersion + "' is not supported, switching to default version: '" + "2.2" + "'");
            this.aspNetCoreVersion = "2.2";
        }
    }
}

