/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jaxrs2.integration;

import io.swagger.jaxrs2.integration.ServletConfigContextUtils;
import io.swagger.oas.integration.ClasspathOpenApiConfigurationLoader;
import io.swagger.oas.integration.FileOpenApiConfigurationLoader;
import io.swagger.oas.integration.SwaggerConfiguration;
import io.swagger.oas.integration.api.OpenAPIConfigBuilder;
import io.swagger.oas.integration.api.OpenAPIConfiguration;
import io.swagger.oas.integration.api.OpenApiConfigurationLoader;
import java.io.IOException;
import javax.servlet.ServletConfig;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletOpenApiConfigurationLoader
implements OpenApiConfigurationLoader {
    private static Logger LOGGER = LoggerFactory.getLogger(ServletOpenApiConfigurationLoader.class);
    private ServletConfig servletConfig;
    private FileOpenApiConfigurationLoader fileOpenApiConfigurationLoader = new FileOpenApiConfigurationLoader();
    private ClasspathOpenApiConfigurationLoader classpathOpenApiConfigurationLoader = new ClasspathOpenApiConfigurationLoader();

    public ServletOpenApiConfigurationLoader(ServletConfig servletConfig) {
        this.servletConfig = servletConfig;
    }

    public OpenAPIConfiguration load(String path) throws IOException {
        String builderClassName;
        if (this.servletConfig == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)path)) {
            SwaggerConfiguration configuration = new SwaggerConfiguration().resourcePackages(ServletConfigContextUtils.resolveResourcePackages(this.servletConfig)).filterClass(ServletConfigContextUtils.getInitParam(this.servletConfig, "openApi.configuration.filterClass")).resourceClasses(ServletConfigContextUtils.resolveResourceClasses(this.servletConfig)).readAllResources(ServletConfigContextUtils.getBooleanInitParam(this.servletConfig, "openApi.configuration.readAllResources")).prettyPrint(ServletConfigContextUtils.getBooleanInitParam(this.servletConfig, "openApi.configuration.prettyPrint")).readerClass(ServletConfigContextUtils.getInitParam(this.servletConfig, "openApi.configuration.readerClass")).cacheTTL(ServletConfigContextUtils.getLongInitParam(this.servletConfig, "openApi.configuration.cacheTTL")).scannerClass(ServletConfigContextUtils.getInitParam(this.servletConfig, "openApi.configuration.scannerClass"));
            return configuration;
        }
        String location = ServletConfigContextUtils.getInitParam(this.servletConfig, path);
        if (!StringUtils.isBlank((CharSequence)location)) {
            if (this.classpathOpenApiConfigurationLoader.exists(location)) {
                return this.classpathOpenApiConfigurationLoader.load(location);
            }
            if (this.fileOpenApiConfigurationLoader.exists(location)) {
                return this.fileOpenApiConfigurationLoader.load(location);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(builderClassName = ServletConfigContextUtils.getInitParam(this.servletConfig, "openApi.configuration.builderClass")))) {
            try {
                Class<?> cls = this.getClass().getClassLoader().loadClass(builderClassName);
                OpenAPIConfigBuilder builder = (OpenAPIConfigBuilder)cls.newInstance();
                return builder.build();
            }
            catch (Exception e) {
                LOGGER.error("error loading builder: " + e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public boolean exists(String path) {
        if (this.servletConfig == null) {
            return false;
        }
        String location = ServletConfigContextUtils.getInitParam(this.servletConfig, path);
        if (!StringUtils.isBlank((CharSequence)location)) {
            if (this.classpathOpenApiConfigurationLoader.exists(location)) {
                return true;
            }
            return this.fileOpenApiConfigurationLoader.exists(location);
        }
        return false;
    }
}

