/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jaxrs2.integration;

import io.swagger.jaxrs2.integration.JaxrsOpenApiContext;
import io.swagger.jaxrs2.integration.ServletConfigContextUtils;
import io.swagger.jaxrs2.integration.ServletOpenApiConfigurationLoader;
import io.swagger.jaxrs2.integration.api.WebOpenApiContext;
import io.swagger.oas.integration.api.OpenApiConfigurationLoader;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlWebOpenApiContext<T extends XmlWebOpenApiContext<T>>
extends JaxrsOpenApiContext<T>
implements WebOpenApiContext {
    private ServletContext servletContext;
    private ServletConfig servletConfig;
    Logger LOGGER = LoggerFactory.getLogger(XmlWebOpenApiContext.class);

    @Override
    public ServletContext getServletContext() {
        return this.servletContext;
    }

    @Override
    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public T servletConfig(ServletConfig servletConfig) {
        if (!ServletConfigContextUtils.isServletConfigAvailable(servletConfig)) {
            return (T)this;
        }
        this.servletConfig = servletConfig;
        this.servletContext = servletConfig.getServletContext();
        this.id("openapi.context.id.servlet." + servletConfig.getServletName());
        return (T)this;
    }

    protected List<ImmutablePair<String, String>> getKnownLocations() {
        LinkedList<ImmutablePair<String, String>> locations = new LinkedList<ImmutablePair<String, String>>(Arrays.asList(new ImmutablePair((Object)"servlet", (Object)"openApi.configuration.location"), new ImmutablePair((Object)"file", (Object)"WEB-INF/openapi-configuration.yaml"), new ImmutablePair((Object)"file", (Object)"WEB-INF/openapi-configuration.json")));
        locations.addAll(super.getKnownLocations());
        locations.add((ImmutablePair)new ImmutablePair((Object)"servlet", (Object)""));
        return locations;
    }

    protected Map<String, OpenApiConfigurationLoader> getLocationLoaders() {
        Map map = super.getLocationLoaders();
        map.put("servlet", new ServletOpenApiConfigurationLoader(this.servletConfig));
        return map;
    }
}

