/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal.digest;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class FileDigest
implements Serializable {
    public final long length;
    public final long lastModified;

    public int hashCode() {
        int hash = 31;
        hash = hash * 17 + (int)this.lastModified;
        hash = hash * 17 + (int)this.length;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FileDigest)) {
            return false;
        }
        FileDigest other = (FileDigest)obj;
        return this.lastModified == other.lastModified && this.length == other.length;
    }

    private FileDigest(long length, long lastModified) {
        this.length = length;
        this.lastModified = lastModified;
    }

    public static FileDigest digest(Path file) {
        try {
            return new FileDigest(Files.size(file), Files.getLastModifiedTime(file, new LinkOption[0]).toMillis());
        }
        catch (IOException iOException) {
            return new FileDigest(0L, 0L);
        }
    }
}

