/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal.pathmatcher;

import io.takari.builder.internal.pathmatcher.FileMatcher;
import io.takari.builder.internal.pathmatcher.Plexus_MatchPattern;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;

public class JarEntries {
    private final Node root = new Node("", false);

    public JarEntries(Enumeration<JarEntry> entries) {
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            this.addEntry(entry.getName());
        }
    }

    private void addEntry(String entry) {
        String[] segments = Plexus_MatchPattern.tokenizePathToString(entry, "/");
        int index = 0;
        int len = segments.length;
        Node node = this.root;
        while (index < len) {
            String segment = segments[index];
            Map children = node.children;
            if ((node = (Node)children.get(segment)) == null) {
                String currentPath = this.getCurrentPath(segments, index);
                boolean isFile = currentPath.equals(entry);
                node = new Node(currentPath, isFile);
                children.put(segment, node);
            }
            ++index;
        }
    }

    private String getCurrentPath(String[] segments, int index) {
        return String.join((CharSequence)"/", Arrays.copyOfRange(segments, 0, index + 1));
    }

    private Node getNode(String path) {
        String[] segments = Plexus_MatchPattern.tokenizePathToString(path, "/");
        int index = 0;
        int len = segments.length;
        Node node = this.root;
        while (index < len) {
            String segment = segments[index];
            Map children = node.children;
            if ((node = (Node)children.get(segment)) == null) {
                return null;
            }
            ++index;
        }
        return node;
    }

    public List<String> match(Map<String, FileMatcher> subdirMatchers) {
        ArrayList<String> matchedPaths = new ArrayList<String>();
        for (Map.Entry<String, FileMatcher> entry : subdirMatchers.entrySet()) {
            Node node = this.getNode(entry.getKey());
            if (node == null) continue;
            matchedPaths.addAll(node.matchFiles(entry.getValue()));
        }
        return matchedPaths;
    }

    private static class Node {
        private final Map<String, Node> children;
        private final boolean isFile;
        private final String path;

        private Node(String path, boolean isFile) {
            this.path = path;
            this.isFile = isFile;
            this.children = isFile ? null : new HashMap();
        }

        private List<String> matchFiles(FileMatcher matcher) {
            if (this.isFile) {
                if (matcher.matches("/" + this.path)) {
                    return Collections.singletonList(this.path);
                }
                return Collections.emptyList();
            }
            ArrayList<String> paths = new ArrayList<String>();
            this.matchFiles(matcher, paths);
            return paths;
        }

        private void matchFiles(FileMatcher matcher, List<String> paths) {
            if (this.children == null) {
                return;
            }
            for (Node node : this.children.values()) {
                if (node.isFile) {
                    if (!matcher.matches("/" + node.path)) continue;
                    paths.add(node.path);
                    continue;
                }
                node.matchFiles(matcher, paths);
            }
        }
    }
}

