/*
 * Copyright 2007-present the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.maven.wrapper.cli;

public class ProjectPropertiesCommandLineConverter extends AbstractPropertiesCommandLineConverter {

  @Override
  protected String getPropertyOption() {
    return "P";
  }

  @Override
  protected String getPropertyOptionDetailed() {
    return "project-prop";
  }

  @Override
  protected String getPropertyOptionDescription() {
    return "Set project property for the build script (e.g. -Pmyprop=myvalue).";
  }
}
