/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.compile.javac;

import io.takari.incrementalbuild.BuildContext;
import io.takari.incrementalbuild.spi.DefaultBuildContext;
import io.takari.maven.plugins.compile.javac.AbstractCompilerJavac;
import io.takari.maven.plugins.compile.javac.CompilerJavacForked;
import io.takari.maven.plugins.compile.javac.ProjectClasspathDigester;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ProcessDestroyer;
import org.apache.commons.exec.ShutdownHookProcessDestroyer;

@Named(value="forked-javac")
public class CompilerJavacLauncher
extends AbstractCompilerJavac {
    public static final String ID = "forked-javac";
    private File jar;
    private File basedir;
    private File buildDirectory;
    private String meminitial;
    private String maxmem;

    @Inject
    public CompilerJavacLauncher(DefaultBuildContext<?> context, ProjectClasspathDigester digester) {
        super(context, digester);
    }

    @Override
    public int compile() throws IOException {
        File options = File.createTempFile("javac-forked", ".options", this.buildDirectory);
        File output = File.createTempFile("javac-forked", ".output", this.buildDirectory);
        this.compile(options, output);
        options.delete();
        output.delete();
        return this.sources.size();
    }

    private void compile(File options, File output) throws IOException {
        this.context.deleteStaleOutputs(false);
        new CompilerJavacForked.CompilerConfiguration(this.getSourceEncoding(), this.getCompilerOptions(), this.getSourceFiles()).write(options);
        String executable = String.valueOf(System.getProperty("java.home")) + File.separator + "bin" + File.separator + "java";
        if (File.separatorChar == '\\') {
            executable = String.valueOf(executable) + ".exe";
        }
        CommandLine cli = new CommandLine(executable);
        cli.addArguments(new String[]{"-cp", this.jar.getAbsolutePath()});
        if (this.meminitial != null) {
            cli.addArgument("-Xms" + this.meminitial);
        }
        if (this.maxmem != null) {
            cli.addArgument("-Xmx" + this.maxmem);
        }
        cli.addArgument(CompilerJavacForked.class.getName());
        cli.addArgument(options.getAbsolutePath(), false);
        cli.addArgument(output.getAbsolutePath(), false);
        DefaultExecutor executor = new DefaultExecutor();
        executor.setProcessDestroyer((ProcessDestroyer)new ShutdownHookProcessDestroyer());
        executor.setWorkingDirectory(this.basedir);
        this.log.debug("External java process command line:\n   {}", (Object)cli);
        try {
            executor.execute(cli);
        }
        catch (ExecuteException e) {
            if (!this.log.isDebugEnabled()) {
                this.log.info("External java process command line:\n   {}", (Object)cli);
            }
            throw e;
        }
        final HashMap looseOutputs = new HashMap();
        final HashMap<File, BuildContext.Input> inputs = new HashMap<File, BuildContext.Input>();
        for (BuildContext.InputMetadata source : this.sources) {
            inputs.put((File)source.getResource(), source.process());
        }
        CompilerJavacForked.CompilerOutput.process(output, new CompilerJavacForked.CompilerOutputProcessor(){

            @Override
            public void processOutput(File inputFile, File outputFile) {
                BuildContext.Input input = (BuildContext.Input)inputs.get(inputFile);
                if (input != null) {
                    input.associateOutput(outputFile);
                } else {
                    looseOutputs.put(outputFile, CompilerJavacLauncher.this.context.processOutput(outputFile));
                }
            }

            @Override
            public void addMessage(String path, int line, int column, String message, BuildContext.Severity kind) {
                if (!".".equals(path)) {
                    File file = new File(path);
                    BuildContext.Resource resource = (BuildContext.Resource)inputs.get(file);
                    if (resource == null) {
                        resource = (BuildContext.Resource)looseOutputs.get(file);
                    }
                    if (resource != null) {
                        if (CompilerJavacLauncher.this.isShowWarnings() || kind != BuildContext.Severity.WARNING) {
                            resource.addMessage(line, column, message, kind, null);
                        }
                    } else {
                        CompilerJavacLauncher.this.log.warn("Unexpected java resource {}", (Object)file);
                    }
                }
            }

            @Override
            public void addLogMessage(String message) {
                CompilerJavacLauncher.this.log.warn(message);
            }
        });
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public void setJar(File jar) {
        this.jar = jar;
    }

    public void setBuildDirectory(File buildDirectory) {
        this.buildDirectory = buildDirectory;
    }

    public void setMeminitial(String meminitial) {
        this.meminitial = meminitial;
    }

    public void setMaxmem(String maxmem) {
        this.maxmem = maxmem;
    }

    @Override
    protected String getCompilerId() {
        return ID;
    }
}

