/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.compile.jdt;

import io.takari.incrementalbuild.BuildContext;
import io.takari.incrementalbuild.spi.ResourceHolder;
import io.takari.maven.plugins.compile.jdt.ArtifactFile;
import java.io.File;

class ArtifactFileHolder
implements ResourceHolder<ArtifactFile> {
    private static final long serialVersionUID = 1L;
    private final ArtifactFile artifact;
    private final long length;
    private final long lastModified;

    public ArtifactFileHolder(File file) {
        this.artifact = new ArtifactFile(file);
        this.length = file.length();
        this.lastModified = file.lastModified();
    }

    public ArtifactFile getResource() {
        return this.artifact;
    }

    public BuildContext.ResourceStatus getStatus() {
        File file = this.artifact.file;
        if (file.isFile()) {
            return this.lastModified == file.lastModified() && this.length == file.length() ? BuildContext.ResourceStatus.UNMODIFIED : BuildContext.ResourceStatus.MODIFIED;
        }
        if (file.isDirectory()) {
            return BuildContext.ResourceStatus.UNMODIFIED;
        }
        return BuildContext.ResourceStatus.REMOVED;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ArtifactFileHolder)) {
            return false;
        }
        return this.artifact.equals(((ArtifactFileHolder)obj).artifact);
    }
}

