/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.compile.jdt.classpath;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.CharStreams;
import com.google.common.io.LineProcessor;
import io.takari.maven.plugins.compile.jdt.classpath.ClasspathEntry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.env.AccessRule;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.osgi.framework.util.Headers;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleException;

public abstract class DependencyClasspathEntry
implements ClasspathEntry {
    protected static final String PATH_EXPORT_PACKAGE = "META-INF/takari/export-package";
    protected static final String PATH_MANIFESTMF = "META-INF/MANIFEST.MF";
    protected final File file;
    protected final Set<String> packageNames;
    protected final Set<String> exportedPackages;

    protected DependencyClasspathEntry(File file, Collection<String> packageNames, Collection<String> exportedPackages) {
        this.file = file;
        this.packageNames = ImmutableSet.copyOf(packageNames);
        this.exportedPackages = exportedPackages != null ? ImmutableSet.copyOf(exportedPackages) : null;
    }

    protected AccessRestriction getAccessRestriction(String packageName) {
        if (this.exportedPackages != null && !this.exportedPackages.contains(packageName)) {
            AccessRule rule = new AccessRule(null, 0x1000133, true);
            return new AccessRestriction(rule, 0, this.getEntryName());
        }
        return null;
    }

    @Override
    public Collection<String> getPackageNames() {
        return this.packageNames;
    }

    protected static Collection<String> parseExportPackage(InputStream is) throws IOException {
        LineProcessor<List<String>> processor = new LineProcessor<List<String>>(){
            final List<String> result = new ArrayList<String>();

            public boolean processLine(String line) throws IOException {
                this.result.add(line.replace('.', '/'));
                return true;
            }

            public List<String> getResult() {
                return this.result;
            }
        };
        return (Collection)CharStreams.readLines((Readable)new InputStreamReader(is, Charsets.UTF_8), (LineProcessor)processor);
    }

    protected static Collection<String> parseBundleManifest(InputStream is) throws IOException, BundleException {
        Headers headers = Headers.parseManifest((InputStream)is);
        if (!headers.containsKey((Object)"Bundle-SymbolicName")) {
            return null;
        }
        String exportPackageHeader = (String)headers.get((Object)"Export-Package");
        if (exportPackageHeader == null) {
            return ImmutableSet.of();
        }
        HashSet<String> packages = new HashSet<String>();
        ManifestElement[] manifestElementArray = ManifestElement.parseHeader((String)"Export-Package", (String)exportPackageHeader);
        int n = manifestElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            ManifestElement element = manifestElementArray[n2];
            packages.add(element.getValue().replace('.', '/'));
            ++n2;
        }
        return packages;
    }

    @Override
    public String getEntryDescription() {
        StringBuilder sb = new StringBuilder(this.getEntryName());
        if (this.exportedPackages != null) {
            sb.append("[");
            int idx = 0;
            for (String exportedPackage : this.exportedPackages) {
                if (idx++ > 0) {
                    sb.append(File.pathSeparatorChar);
                }
                sb.append('+').append(exportedPackage).append("/*");
            }
            if (idx > 0) {
                sb.append(File.pathSeparatorChar);
            }
            sb.append("?**/*");
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public NameEnvironmentAnswer findType(String packageName, String binaryFileName) {
        if (!this.packageNames.contains(packageName)) {
            return null;
        }
        return this.findType(packageName, binaryFileName, this.getAccessRestriction(packageName));
    }

    public abstract NameEnvironmentAnswer findType(String var1, String var2, AccessRestriction var3);

    public String getEntryName() {
        return this.file.getAbsolutePath();
    }
}

