/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.compile.jdt.classpath;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.internal.compiler.util.Util;

public class JavaInstallation {
    private static final FilenameFilter POTENTIAL_ZIP_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return Util.isPotentialZipArchive((String)name);
        }
    };
    private final File javaHome;

    public JavaInstallation(File javaHome) {
        this.javaHome = javaHome;
    }

    public List<File> getClasspath() throws IOException {
        ArrayList<File> classpath = new ArrayList<File>();
        File directoryToCheck = this.isAppleJDK() ? new File(this.javaHome, "../Classes") : new File(this.javaHome, "lib");
        this.scanForArchives(classpath, directoryToCheck);
        this.scanForArchives(classpath, new File(this.javaHome, "lib/endorsed"));
        this.scanForArchives(classpath, new File(this.javaHome, "lib/ext"));
        return classpath;
    }

    protected boolean isAppleJDK() {
        return System.getProperty("java.vendor").startsWith("Apple");
    }

    private void scanForArchives(List<File> classPathList, File dir) {
        File[] zipFiles;
        if (dir.isDirectory() && (zipFiles = dir.listFiles(POTENTIAL_ZIP_FILTER)) != null) {
            File[] fileArray = zipFiles;
            int n = zipFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File zipFile = fileArray[n2];
                classPathList.add(zipFile);
                ++n2;
            }
        }
    }

    public static JavaInstallation getDefault() {
        return new JavaInstallation(Util.getJavaHome());
    }
}

