/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.exportpackage;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableSet;
import io.takari.incrementalbuild.BuildContext;
import io.takari.incrementalbuild.spi.DefaultBuildContext;
import io.takari.incrementalbuild.spi.DefaultOutput;
import io.takari.maven.plugins.TakariLifecycleMojo;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="export-package", defaultPhase=LifecyclePhase.PROCESS_CLASSES, threadSafe=true)
public class ExportPackageMojo
extends TakariLifecycleMojo {
    public static final String PATH_EXPORT_PACKAGE = "META-INF/takari/export-package";
    public static final char EOL = '\n';
    @Parameter(defaultValue="${project.build.outputDirectory}/META-INF/takari/export-package")
    private File outputFile;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File classesDirectory;
    @Parameter
    private Set<String> exportIncludes = ImmutableSet.of();
    @Parameter
    private Set<String> exportExcludes = ImmutableSet.of((Object)"**/internal/**", (Object)"**/impl/**");
    @Inject
    private DefaultBuildContext<?> buildContext;

    @Override
    protected void executeMojo() throws MojoExecutionException {
        try {
            this.generateOutput();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not generate export-package file", (Exception)e);
        }
    }

    private void generateOutput() throws IOException {
        block13: {
            this.buildContext.registerAndProcessInputs(this.classesDirectory, this.getIncludes(), this.exportExcludes);
            boolean processingRequired = this.buildContext.isEscalated();
            TreeSet<String> exportedPackages = new TreeSet<String>();
            for (BuildContext.InputMetadata input : this.buildContext.getRegisteredInputs()) {
                BuildContext.ResourceStatus status = input.getStatus();
                if (status == BuildContext.ResourceStatus.NEW || status == BuildContext.ResourceStatus.REMOVED) {
                    processingRequired = true;
                }
                if (status == BuildContext.ResourceStatus.REMOVED) continue;
                exportedPackages.add(ExportPackageMojo.getPackageName(this.classesDirectory, (File)input.getResource()));
            }
            boolean bl = processingRequired = processingRequired || !this.outputFile.isFile();
            if (processingRequired) {
                DefaultOutput output = this.buildContext.processOutput(this.outputFile);
                Object object = null;
                Object var5_6 = null;
                try (BufferedWriter w = new BufferedWriter(new OutputStreamWriter(output.newOutputStream(), Charsets.UTF_8));){
                    for (String exportedPackage : exportedPackages) {
                        w.write(exportedPackage);
                        w.write(10);
                    }
                    break block13;
                }
                catch (Throwable throwable) {
                    if (object == null) {
                        object = throwable;
                    } else if (object != throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    throw object;
                }
            }
            this.buildContext.markOutputAsUptodate(this.outputFile);
        }
    }

    private Collection<String> getIncludes() {
        if (this.exportIncludes.isEmpty()) {
            return ImmutableSet.of((Object)"**/*.class");
        }
        HashSet<String> includes = new HashSet<String>();
        for (String include : this.exportIncludes) {
            if (!(include = include.replace('\\', '/')).endsWith("/")) {
                include = String.valueOf(include) + "/";
            }
            String string = String.valueOf(include) + "*.class";
        }
        return includes;
    }

    static String getPackageName(File basedir, File file) {
        String relpath = basedir.toPath().relativize(file.getParentFile().toPath()).toString();
        return relpath.replace('\\', '/').replace('/', '.');
    }
}

