/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.compile;

import io.takari.incrementalbuild.Incremental;
import io.takari.maven.plugins.compile.AbstractCompileMojo;
import java.io.File;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="testCompile", defaultPhase=LifecyclePhase.TEST_COMPILE, threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST, configurator="takari")
public class TestCompileMojo
extends AbstractCompileMojo {
    @Parameter(defaultValue="${project.testCompileSourceRoots}", readonly=true, required=true)
    private List<String> compileSourceRoots;
    @Parameter
    private Set<String> testIncludes = new HashSet<String>();
    @Parameter
    private Set<String> testExcludes = new HashSet<String>();
    @Incremental(configuration=Incremental.Configuration.ignore)
    @Parameter(defaultValue="${project.testArtifacts}", readonly=true, required=true)
    private List<Artifact> compileArtifacts;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true, readonly=true)
    private File mainOutputDirectory;
    @Parameter(defaultValue="${project.build.testOutputDirectory}", required=true, readonly=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.directory}/generated-test-sources/test-annotations")
    private File generatedTestSourcesDirectory;
    @Incremental(configuration=Incremental.Configuration.ignore)
    @Parameter(property="maven.test.skip")
    private boolean skip;
    @Parameter(defaultValue="${project.compileSourceRoots}", readonly=true, required=true)
    private List<String> mainCompileSourceRoots;

    @Override
    public Set<String> getSourceRoots() {
        return new LinkedHashSet<String>(this.compileSourceRoots);
    }

    @Override
    public Set<String> getIncludes() {
        return this.testIncludes;
    }

    @Override
    public Set<String> getExcludes() {
        return this.testExcludes;
    }

    @Override
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    public List<Artifact> getClasspathArtifacts() {
        return this.compileArtifacts;
    }

    @Override
    public File getGeneratedSourcesDirectory() {
        return this.generatedTestSourcesDirectory;
    }

    @Override
    protected boolean isSkip() {
        return this.skip;
    }

    @Override
    protected File getMainOutputDirectory() {
        return this.mainOutputDirectory;
    }

    @Override
    protected void addGeneratedSources(MavenProject project) {
        String root;
        List roots = project.getTestCompileSourceRoots();
        if (!roots.contains(root = this.generatedTestSourcesDirectory.getAbsolutePath())) {
            roots.add(root);
        }
    }

    @Override
    protected Set<String> getMainSourceRoots() {
        return new LinkedHashSet<String>(this.mainCompileSourceRoots);
    }

    @Override
    protected List<Dependency> getProcessorpathDependencies() {
        return null;
    }
}

