/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.compile.jdt;

import io.takari.maven.plugins.compile.CompilerBuildContext;
import io.takari.maven.plugins.compile.jdt.CompilerJdt;
import io.takari.maven.plugins.compile.jdt.FilerImpl;
import io.takari.maven.plugins.compile.jdt.MessagerImpl;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.StandardJavaFileManager;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.apt.dispatch.BaseProcessingEnvImpl;
import org.eclipse.jdt.internal.compiler.apt.model.ElementsImpl;
import org.eclipse.jdt.internal.compiler.apt.model.Factory;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

class ProcessingEnvImpl
extends BaseProcessingEnvImpl {
    private Set<Consumer<String>> referencedTypeObservers = new LinkedHashSet<Consumer<String>>();
    private final Factory _factory;

    public ProcessingEnvImpl(CompilerBuildContext context, StandardJavaFileManager fileManager, Map<String, String> processorOptions, Compiler compiler, CompilerJdt incrementalCompiler) {
        this._filer = new FilerImpl(context, fileManager, incrementalCompiler, this);
        this._messager = new MessagerImpl(context, this);
        this._processorOptions = processorOptions != null ? processorOptions : Collections.emptyMap();
        this._compiler = compiler;
        this._elementUtils = new ElementsImpl(this){

            public TypeElement getTypeElement(CharSequence name) {
                ProcessingEnvImpl.this.observeType(name.toString());
                return super.getTypeElement(name);
            }

            public PackageElement getPackageElement(CharSequence name) {
                ProcessingEnvImpl.this.observeType(name.toString());
                return super.getPackageElement(name);
            }
        };
        this._factory = new Factory(this){

            private void observeType(Binding binding) {
                if (binding instanceof ImportBinding) {
                    this.observeType(((ImportBinding)binding).compoundName);
                } else if (binding instanceof PackageBinding) {
                    this.observeType(((PackageBinding)binding).compoundName);
                } else if (binding instanceof TypeBinding) {
                    this.observeType((TypeBinding)binding);
                }
            }

            private void observeType(TypeBinding binding) {
                if ((binding = binding.leafComponentType().erasure()) instanceof ReferenceBinding) {
                    ReferenceBinding referenceBinding = (ReferenceBinding)binding;
                    this.observeType(referenceBinding.compoundName);
                    ReferenceBinding[] referenceBindingArray = referenceBinding.memberTypes();
                    int n = referenceBindingArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ReferenceBinding memberType = referenceBindingArray[n2];
                        this.observeType(memberType.compoundName);
                        ++n2;
                    }
                }
            }

            private void observeType(char[][] compoundName) {
                ProcessingEnvImpl.this.observeType(CharOperation.toString((char[][])compoundName));
            }

            public Element newElement(Binding binding, ElementKind kindHint) {
                this.observeType(binding);
                return super.newElement(binding, kindHint);
            }

            public TypeMirror newTypeMirror(Binding binding) {
                this.observeType(binding);
                return super.newTypeMirror(binding);
            }
        };
    }

    private void observeType(String type) {
        this.referencedTypeObservers.forEach(o -> o.accept(type));
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    public Factory getFactory() {
        return this._factory;
    }

    public void incrementalIterationReset() {
        this.reset();
        this.setErrorRaised(false);
        ((FilerImpl)this._filer).incrementalIterationReset();
    }

    public void addReferencedTypeObserver(Consumer<String> observer) {
        this.referencedTypeObservers.add(observer);
    }

    public LookupEnvironment getLookupEnvironment() {
        LookupEnvironment _le = super.getLookupEnvironment();
        return _le;
    }
}

