/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.util;

import com.google.common.base.Charsets;
import com.google.common.io.ByteSource;
import com.google.common.io.CharSource;
import com.google.common.io.CharStreams;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Properties;

public class PropertiesWriter {
    private static final Charset ENCODING = Charsets.ISO_8859_1;

    public static void write(Properties properties, String comment, OutputStream out) throws IOException {
        StringBuilder sb = new StringBuilder();
        properties.store(CharStreams.asWriter((Appendable)sb), comment);
        PropertiesWriter.write(CharSource.wrap((CharSequence)sb.toString()), comment, out);
    }

    public static void write(byte[] properties, OutputStream out) throws IOException {
        PropertiesWriter.write(ByteSource.wrap((byte[])properties).asCharSource(ENCODING), null, out);
    }

    private static void write(CharSource charSource, String comment, OutputStream out) throws IOException {
        ArrayList lines = new ArrayList(charSource.readLines());
        lines.remove(comment != null ? 1 : 0);
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter(out, ENCODING));
        for (String line : lines) {
            w.write(line);
            w.newLine();
        }
        w.flush();
    }
}

