/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot.atom;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Repository;
import org.apache.maven.model.io.ModelWriter;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.maven.polyglot.io.ModelWriterSupport;

@Component(role=ModelWriter.class, hint="atom")
public class AtomModelWriter
extends ModelWriterSupport {
    private static final Pattern ATOM_REGEX = Pattern.compile("\\d+|true|false");
    protected Logger log = LoggerFactory.getLogger(AtomModelWriter.class);
    String indent = "  ";
    private boolean flipBrackets = false;

    public void write(Writer output, Map<String, Object> options, Model model) throws IOException {
        assert (output != null);
        assert (model != null);
        PrintWriter pw = new PrintWriter(output);
        this.repositories(pw, model);
        this.project(pw, model);
        this.id(pw, model);
        this.parent(pw, model);
        this.properties(pw, model);
        this.dependencyManagement(pw, model);
        this.dependencies(pw, model);
        this.modules(pw, model);
        pw.println();
        this.pluginManagement(pw, model);
        this.plugins(pw, "plugin", model);
        pw.flush();
        pw.close();
    }

    private void repositories(PrintWriter pw, Model model) {
        List repositories = model.getRepositories();
        if (!repositories.isEmpty()) {
            pw.print("repositories << \"");
            int i = 0;
            while (i < repositories.size()) {
                pw.print(((Repository)repositories.get(i)).getUrl());
                if (i + 1 != repositories.size()) {
                    pw.print(",");
                }
                ++i;
            }
            pw.println("\"");
            pw.println();
        }
    }

    private void project(PrintWriter pw, Model model) {
        String name = model.getName();
        if (name == null) {
            name = model.getArtifactId();
        }
        String url = model.getUrl() == null ? "" : model.getUrl();
        pw.print("project \"" + name + "\" @ \"" + url + "\"");
        this.packaging(pw, model);
    }

    private void id(PrintWriter pw, Model model) {
        String version;
        String groupId = model.getGroupId();
        if (groupId == null & model.getParent() != null) {
            groupId = model.getParent().getGroupId();
        }
        if ((version = model.getVersion()) == null && model.getParent() != null) {
            version = model.getParent().getVersion();
        }
        pw.println(String.valueOf(this.indent) + "id: " + groupId + ":" + model.getArtifactId() + ":" + version);
    }

    private void parent(PrintWriter pw, Model model) {
        if (model.getParent() != null) {
            pw.print(String.valueOf(this.indent) + "inherits: " + model.getParent().getGroupId() + ":" + model.getParent().getArtifactId() + ":" + model.getParent().getVersion());
            model.getParent().getRelativePath();
            pw.println();
        }
    }

    private void packaging(PrintWriter pw, Model model) {
        pw.println(" as " + model.getPackaging());
    }

    private void properties(PrintWriter pw, Model model) {
        if (!model.getProperties().isEmpty()) {
            ArrayList<Object> keys = new ArrayList<Object>(model.getProperties().keySet());
            pw.print(String.valueOf(this.indent) + "properties: [ ");
            int i = 0;
            while (i < keys.size()) {
                Object value;
                Object key = keys.get(i);
                if (i != 0) {
                    pw.print("                ");
                }
                if ((value = model.getProperties().get(key)) != null) {
                    pw.print(key + ": " + this.toAtom(value.toString()));
                    if (i + 1 != keys.size()) {
                        pw.println();
                    }
                }
                ++i;
            }
            pw.println(" ]");
        }
    }

    private void modules(PrintWriter pw, Model model) {
        List modules = model.getModules();
        if (!modules.isEmpty()) {
            pw.print(String.valueOf(this.indent) + "modules: [ ");
            int i = 0;
            while (i < modules.size()) {
                String module = (String)modules.get(i);
                if (i != 0) {
                    pw.print(String.valueOf(this.indent) + "           ");
                }
                pw.print(module);
                if (i + 1 != modules.size()) {
                    pw.println();
                }
                ++i;
            }
            pw.println(" ]");
        }
    }

    private void dependencyManagement(PrintWriter pw, Model model) {
        if (model.getDependencyManagement() != null) {
            this.deps(pw, "overrides", model.getDependencyManagement().getDependencies());
        }
    }

    private void dependencies(PrintWriter pw, Model model) {
        this.deps(pw, "deps", model.getDependencies());
    }

    private void deps(PrintWriter pw, String elementName, List<Dependency> deps) {
        if (!deps.isEmpty()) {
            pw.print(String.valueOf(this.indent) + elementName + ": [ ");
            int i = 0;
            while (i < deps.size()) {
                Dependency d = deps.get(i);
                if (i != 0) {
                    pw.print("               ");
                }
                if (d.getVersion() != null) {
                    pw.print(String.valueOf(d.getGroupId()) + ":" + d.getArtifactId() + ":" + d.getVersion());
                } else {
                    pw.print(String.valueOf(d.getGroupId()) + ":" + d.getArtifactId());
                }
                if (d.getClassifier() != null) {
                    pw.print("(" + d.getClassifier() + ")");
                }
                if (i + 1 != deps.size()) {
                    pw.println();
                }
                ++i;
            }
            pw.println(" ]");
        }
    }

    private void pluginManagement(PrintWriter pw, Model model) {
        if (model.getBuild() != null && model.getBuild().getPluginManagement() != null) {
            this.plugins(pw, "plugin-override", model.getBuild().getPluginManagement().getPlugins());
        }
    }

    private void plugins(PrintWriter pw, String element, Model model) {
        if (model.getBuild() != null && !model.getBuild().getPlugins().isEmpty()) {
            this.plugins(pw, element, model.getBuild().getPlugins());
        }
    }

    private void plugins(PrintWriter pw, String element, List<Plugin> plugins) {
        if (!plugins.isEmpty()) {
            int i = 0;
            while (i < plugins.size()) {
                Plugin plugin = plugins.get(i);
                pw.println("\n" + element);
                pw.print(String.valueOf(this.indent) + "id: " + plugin.getGroupId() + ":" + plugin.getArtifactId());
                if (plugin.getVersion() != null) {
                    pw.print(":" + plugin.getVersion());
                }
                if (plugin.getConfiguration() != null) {
                    pw.println();
                    Xpp3Dom configuration = (Xpp3Dom)plugin.getConfiguration();
                    this.printChildren(pw, configuration);
                }
                if (i + 1 != plugins.size()) {
                    pw.println();
                }
                ++i;
            }
            pw.println();
        }
    }

    private void printChildren(PrintWriter pw, Xpp3Dom configuration) {
        if (configuration.getChildCount() > 0) {
            int count = configuration.getChildCount();
            int j = 0;
            while (j < count) {
                Xpp3Dom c = configuration.getChild(j);
                if (c.getValue() != null) {
                    pw.print(String.valueOf(this.indent) + c.getName() + ": " + this.toAtom(c.getValue()));
                    if (j + 1 != count) {
                        pw.println();
                    }
                } else {
                    String keyString = String.valueOf(this.indent) + c.getName() + ": " + this.lbraceket();
                    if (c.getChildCount() == 0) {
                        pw.print(keyString);
                    } else {
                        pw.println(keyString);
                    }
                    String oldIndent = this.indent;
                    this.indent = String.valueOf(this.indent) + "  ";
                    this.flipBrackets = !this.flipBrackets;
                    this.printChildren(pw, c);
                    this.flipBrackets = !this.flipBrackets;
                    this.indent = oldIndent;
                    if (c.getChildCount() == 0) {
                        pw.print(this.rbraceket());
                    } else {
                        pw.print("\n" + this.indent + this.rbraceket());
                    }
                }
                ++j;
            }
        }
    }

    private String toAtom(String value) {
        return String.valueOf('\"') + value + '\"';
    }

    private char lbraceket() {
        return this.flipBrackets ? (char)'{' : '[';
    }

    private char rbraceket() {
        return this.flipBrackets ? (char)'}' : ']';
    }
}

