/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot.atom.parsing;

import java.util.HashMap;
import java.util.Map;

public class Token {
    public static final String PLUGIN_OVERRIDE_KEYWORD = "plugin-override";
    public final String value;
    public final Kind kind;

    public Token(String value, Kind kind) {
        this.value = value;
        this.kind = kind;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Token token = (Token)o;
        return this.kind == token.kind && (this.value != null ? this.value.equals(token.value) : token.value == null);
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + (this.kind != null ? this.kind.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Token{value='" + this.value + '\'' + ", kind=" + (Object)((Object)this.kind) + '}';
    }

    public static enum Kind {
        IDENT,
        STRING,
        DOT,
        COLON,
        MINUS,
        DIVIDE,
        STAR,
        MODULUS,
        COMMA,
        AT,
        ARROW,
        HASHROCKET,
        LEFT_WAVE,
        GREATER,
        LEQ,
        GEQ,
        LPAREN,
        RPAREN,
        LBRACKET,
        RBRACKET,
        LBRACE,
        RBRACE,
        REQUIRE,
        SRCS,
        SCM,
        PROJECT,
        REPOSITORIES,
        OR,
        AND,
        NOT,
        DEPS,
        ID,
        PARENT,
        EOL,
        INDENT,
        DASH,
        PACKAGING,
        OVERRIDES,
        PROPS,
        MODULES,
        PLUGIN,
        PLUGIN_OVERRIDE;

        private static final Map<String, Kind> TOKEN_MAP;

        static {
            TOKEN_MAP = new HashMap<String, Kind>();
            TOKEN_MAP.put("@", AT);
            TOKEN_MAP.put(".", DOT);
            TOKEN_MAP.put("-", DASH);
            TOKEN_MAP.put(":", COLON);
            TOKEN_MAP.put("*", STAR);
            TOKEN_MAP.put(",", COMMA);
            TOKEN_MAP.put("->", ARROW);
            TOKEN_MAP.put("<=", LEQ);
            TOKEN_MAP.put(">=", GEQ);
            TOKEN_MAP.put("<<", LEFT_WAVE);
            TOKEN_MAP.put(">", GREATER);
            TOKEN_MAP.put("=>", HASHROCKET);
            TOKEN_MAP.put("(", LPAREN);
            TOKEN_MAP.put(")", RPAREN);
            TOKEN_MAP.put("[", LBRACKET);
            TOKEN_MAP.put("]", RBRACKET);
            TOKEN_MAP.put("{", LBRACE);
            TOKEN_MAP.put("}", RBRACE);
            TOKEN_MAP.put("\n", EOL);
            TOKEN_MAP.put("id", ID);
            TOKEN_MAP.put("inherits", PARENT);
            TOKEN_MAP.put("as", PACKAGING);
            TOKEN_MAP.put("properties", PROPS);
            TOKEN_MAP.put("deps", DEPS);
            TOKEN_MAP.put("overrides", OVERRIDES);
            TOKEN_MAP.put("repositories", REPOSITORIES);
            TOKEN_MAP.put("project", PROJECT);
            TOKEN_MAP.put("srcs", SRCS);
            TOKEN_MAP.put("scm", SCM);
            TOKEN_MAP.put("modules", MODULES);
            TOKEN_MAP.put("plugin", PLUGIN);
            TOKEN_MAP.put(Token.PLUGIN_OVERRIDE_KEYWORD, PLUGIN_OVERRIDE);
            TOKEN_MAP.put("||", OR);
            TOKEN_MAP.put("&&", AND);
            TOKEN_MAP.put("!", NOT);
        }

        public static Kind determine(String value) {
            char first = value.charAt(0);
            if (first == '\"' || first == '\'') {
                return STRING;
            }
            Kind knownKind = TOKEN_MAP.get(value);
            if (knownKind != null) {
                return knownKind;
            }
            return IDENT;
        }
    }
}

