/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.client;

import com.uber.m3.tally.Scope;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.enums.v1.WorkflowExecutionStatus;
import io.temporal.api.query.v1.WorkflowQuery;
import io.temporal.api.workflowservice.v1.QueryWorkflowRequest;
import io.temporal.api.workflowservice.v1.QueryWorkflowResponse;
import io.temporal.api.workflowservice.v1.RequestCancelWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.SignalWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.StartWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.TerminateWorkflowExecutionRequest;
import io.temporal.client.WorkflowClientOptions;
import io.temporal.common.interceptors.WorkflowClientCallsInterceptor;
import io.temporal.internal.client.RootWorkflowClientHelper;
import io.temporal.internal.common.SignalWithStartWorkflowExecutionParameters;
import io.temporal.internal.common.WorkflowExecutionUtils;
import io.temporal.internal.external.GenericWorkflowClientExternal;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;

public class RootWorkflowClientInvoker
implements WorkflowClientCallsInterceptor {
    private final GenericWorkflowClientExternal genericClient;
    private final WorkflowClientOptions clientOptions;
    private final Scope metricsScope;
    private final RootWorkflowClientHelper requestsHelper;

    public RootWorkflowClientInvoker(GenericWorkflowClientExternal genericClient, WorkflowClientOptions clientOptions, Scope metricsScope) {
        this.genericClient = genericClient;
        this.clientOptions = clientOptions;
        this.metricsScope = metricsScope;
        this.requestsHelper = new RootWorkflowClientHelper(clientOptions);
    }

    @Override
    public WorkflowClientCallsInterceptor.WorkflowStartOutput start(WorkflowClientCallsInterceptor.WorkflowStartInput input) {
        StartWorkflowExecutionRequest request = this.requestsHelper.newStartWorkflowExecutionRequest(input);
        return new WorkflowClientCallsInterceptor.WorkflowStartOutput(this.genericClient.start(request));
    }

    @Override
    public WorkflowClientCallsInterceptor.WorkflowSignalOutput signal(WorkflowClientCallsInterceptor.WorkflowSignalInput input) {
        SignalWorkflowExecutionRequest.Builder request = SignalWorkflowExecutionRequest.newBuilder().setSignalName(input.getSignalName()).setWorkflowExecution(input.getWorkflowExecution());
        if (this.clientOptions.getIdentity() != null) {
            request.setIdentity(this.clientOptions.getIdentity());
        }
        if (this.clientOptions.getNamespace() != null) {
            request.setNamespace(this.clientOptions.getNamespace());
        }
        Optional<Payloads> inputArgs = this.clientOptions.getDataConverter().toPayloads(input.getArguments());
        inputArgs.ifPresent(arg_0 -> ((SignalWorkflowExecutionRequest.Builder)request).setInput(arg_0));
        this.genericClient.signal(request.build());
        return new WorkflowClientCallsInterceptor.WorkflowSignalOutput();
    }

    @Override
    public WorkflowClientCallsInterceptor.WorkflowSignalWithStartOutput signalWithStart(WorkflowClientCallsInterceptor.WorkflowSignalWithStartInput input) {
        StartWorkflowExecutionRequest request = this.requestsHelper.newStartWorkflowExecutionRequest(input.getWorkflowStartInput());
        Optional<Payloads> signalInput = this.clientOptions.getDataConverter().toPayloads(input.getSignalArguments());
        SignalWithStartWorkflowExecutionParameters p = new SignalWithStartWorkflowExecutionParameters(request, input.getSignalName(), signalInput);
        return new WorkflowClientCallsInterceptor.WorkflowSignalWithStartOutput(new WorkflowClientCallsInterceptor.WorkflowStartOutput(this.genericClient.signalWithStart(p)));
    }

    @Override
    public <R> WorkflowClientCallsInterceptor.GetResultOutput<R> getResult(WorkflowClientCallsInterceptor.GetResultInput<R> input) throws TimeoutException {
        Optional<Payloads> resultValue = WorkflowExecutionUtils.getWorkflowExecutionResult(this.genericClient.getService(), this.genericClient.getNamespace(), input.getWorkflowExecution(), input.getWorkflowType(), this.metricsScope, this.clientOptions.getDataConverter(), input.getTimeout(), input.getTimeoutUnit());
        return new WorkflowClientCallsInterceptor.GetResultOutput<R>(this.convertResultPayloads(resultValue, input.getResultClass(), input.getResultType()));
    }

    @Override
    public <R> WorkflowClientCallsInterceptor.GetResultAsyncOutput<R> getResultAsync(WorkflowClientCallsInterceptor.GetResultInput<R> input) {
        CompletableFuture<Optional<Payloads>> resultValue = WorkflowExecutionUtils.getWorkflowExecutionResultAsync(this.genericClient.getService(), this.genericClient.getNamespace(), input.getWorkflowExecution(), input.getWorkflowType(), input.getTimeout(), input.getTimeoutUnit(), this.clientOptions.getDataConverter());
        return new WorkflowClientCallsInterceptor.GetResultAsyncOutput(resultValue.thenApply(payloads -> this.convertResultPayloads((Optional<Payloads>)payloads, input.getResultClass(), input.getResultType())));
    }

    @Override
    public <R> WorkflowClientCallsInterceptor.QueryOutput<R> query(WorkflowClientCallsInterceptor.QueryInput<R> input) {
        WorkflowQuery.Builder query = WorkflowQuery.newBuilder().setQueryType(input.getQueryType());
        Optional<Payloads> inputArgs = this.clientOptions.getDataConverter().toPayloads(input.getArguments());
        inputArgs.ifPresent(arg_0 -> ((WorkflowQuery.Builder)query).setQueryArgs(arg_0));
        QueryWorkflowRequest request = QueryWorkflowRequest.newBuilder().setNamespace(this.clientOptions.getNamespace()).setExecution(WorkflowExecution.newBuilder().setWorkflowId(input.getWorkflowExecution().getWorkflowId()).setRunId(input.getWorkflowExecution().getRunId())).setQuery(query).setQueryRejectCondition(this.clientOptions.getQueryRejectCondition()).build();
        QueryWorkflowResponse result = this.genericClient.query(request);
        boolean queryRejected = result.hasQueryRejected();
        WorkflowExecutionStatus rejectStatus = queryRejected ? result.getQueryRejected().getStatus() : null;
        Optional<Payloads> queryResult = result.hasQueryResult() ? Optional.of(result.getQueryResult()) : Optional.empty();
        R resultValue = this.convertResultPayloads(queryResult, input.getResultClass(), input.getResultType());
        return new WorkflowClientCallsInterceptor.QueryOutput<R>(rejectStatus, resultValue);
    }

    @Override
    public WorkflowClientCallsInterceptor.CancelOutput cancel(WorkflowClientCallsInterceptor.CancelInput input) {
        RequestCancelWorkflowExecutionRequest.Builder request = RequestCancelWorkflowExecutionRequest.newBuilder().setRequestId(UUID.randomUUID().toString()).setWorkflowExecution(input.getWorkflowExecution()).setNamespace(this.clientOptions.getNamespace()).setIdentity(this.clientOptions.getIdentity());
        this.genericClient.requestCancel(request.build());
        return new WorkflowClientCallsInterceptor.CancelOutput();
    }

    @Override
    public WorkflowClientCallsInterceptor.TerminateOutput terminate(WorkflowClientCallsInterceptor.TerminateInput input) {
        TerminateWorkflowExecutionRequest.Builder request = TerminateWorkflowExecutionRequest.newBuilder().setNamespace(this.clientOptions.getNamespace()).setWorkflowExecution(input.getWorkflowExecution()).setReason(input.getReason());
        Optional<Payloads> payloads = this.clientOptions.getDataConverter().toPayloads(input.getDetails());
        payloads.ifPresent(arg_0 -> ((TerminateWorkflowExecutionRequest.Builder)request).setDetails(arg_0));
        this.genericClient.terminate(request.build());
        return new WorkflowClientCallsInterceptor.TerminateOutput();
    }

    private <R> R convertResultPayloads(Optional<Payloads> resultValue, Class<R> resultClass, Type resultType) {
        return this.clientOptions.getDataConverter().fromPayloads(0, resultValue, resultClass, resultType);
    }
}

