/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.replay;

import com.google.common.base.Throwables;
import com.google.protobuf.Duration;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Durations;
import com.google.protobuf.util.Timestamps;
import com.uber.m3.tally.Scope;
import com.uber.m3.tally.Stopwatch;
import io.temporal.api.command.v1.Command;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.enums.v1.QueryResultType;
import io.temporal.api.history.v1.HistoryEvent;
import io.temporal.api.history.v1.WorkflowExecutionStartedEventAttributes;
import io.temporal.api.query.v1.WorkflowQuery;
import io.temporal.api.query.v1.WorkflowQueryResult;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueResponseOrBuilder;
import io.temporal.common.converter.DataConverter;
import io.temporal.internal.common.ProtobufTimeUtils;
import io.temporal.internal.replay.ExecuteLocalActivityParameters;
import io.temporal.internal.replay.InternalWorkflowTaskException;
import io.temporal.internal.replay.ReplayWorkflow;
import io.temporal.internal.replay.ReplayWorkflowContextImpl;
import io.temporal.internal.replay.ReplayWorkflowExecutor;
import io.temporal.internal.replay.WorkflowHistoryIterator;
import io.temporal.internal.replay.WorkflowRunTaskHandler;
import io.temporal.internal.replay.WorkflowTaskResult;
import io.temporal.internal.statemachines.EntityManagerListener;
import io.temporal.internal.statemachines.WorkflowStateMachines;
import io.temporal.internal.worker.ActivityTaskHandler;
import io.temporal.internal.worker.LocalActivityWorker;
import io.temporal.internal.worker.SingleWorkerOptions;
import io.temporal.serviceclient.CheckedExceptionWrapper;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.worker.WorkflowImplementationOptions;
import io.temporal.workflow.Functions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;

class ReplayWorkflowRunTaskHandler
implements WorkflowRunTaskHandler {
    public static final double FORCED_DECISION_TIME_COEFFICIENT = 0.8;
    private final WorkflowServiceStubs service;
    private final String namespace;
    private final Scope metricsScope;
    private final WorkflowExecutionStartedEventAttributes startedEvent;
    private final Lock lock = new ReentrantLock();
    private final Functions.Proc1<ActivityTaskHandler.Result> localActivityCompletionSink;
    private final BlockingQueue<ActivityTaskHandler.Result> localActivityCompletionQueue = new LinkedBlockingDeque<ActivityTaskHandler.Result>();
    private final BiFunction<LocalActivityWorker.Task, java.time.Duration, Boolean> localActivityTaskPoller;
    private final Map<String, WorkflowQueryResult> queryResults = new HashMap<String, WorkflowQueryResult>();
    private final DataConverter converter;
    private final WorkflowStateMachines workflowStateMachines;
    private final HistoryEvent firstEvent;
    private int localActivityTaskCount;
    private final ReplayWorkflowExecutor replayWorkflowExecutor;

    ReplayWorkflowRunTaskHandler(WorkflowServiceStubs service, String namespace, ReplayWorkflow workflow, PollWorkflowTaskQueueResponseOrBuilder workflowTask, SingleWorkerOptions options, Scope metricsScope, BiFunction<LocalActivityWorker.Task, java.time.Duration, Boolean> localActivityTaskPoller) {
        this.service = service;
        this.namespace = namespace;
        this.firstEvent = workflowTask.getHistory().getEvents(0);
        if (!this.firstEvent.hasWorkflowExecutionStartedEventAttributes()) {
            throw new IllegalArgumentException("First event in the history is not WorkflowExecutionStarted");
        }
        this.startedEvent = this.firstEvent.getWorkflowExecutionStartedEventAttributes();
        this.workflowStateMachines = new WorkflowStateMachines(new EntityManagerListenerImpl());
        this.metricsScope = metricsScope;
        this.converter = options.getDataConverter();
        this.localActivityTaskPoller = localActivityTaskPoller;
        ReplayWorkflowContextImpl context = new ReplayWorkflowContextImpl(this.workflowStateMachines, namespace, this.startedEvent, workflowTask.getWorkflowExecution(), Timestamps.toMillis((Timestamp)this.firstEvent.getEventTime()), options, metricsScope);
        this.replayWorkflowExecutor = new ReplayWorkflowExecutor(workflow, metricsScope, this.workflowStateMachines, context);
        this.localActivityCompletionSink = historyEvent -> this.localActivityCompletionQueue.add((ActivityTaskHandler.Result)historyEvent);
    }

    private void handleEvent(HistoryEvent event, boolean hasNextEvent) {
        this.workflowStateMachines.handleEvent(event, hasNextEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkflowTaskResult handleWorkflowTask(PollWorkflowTaskQueueResponseOrBuilder workflowTask) {
        this.lock.lock();
        try {
            this.queryResults.clear();
            long startTime = System.currentTimeMillis();
            this.handleWorkflowTaskImpl(workflowTask);
            this.processLocalActivityRequests(startTime);
            List<Command> commands = this.workflowStateMachines.takeCommands();
            this.executeQueries(workflowTask.getQueriesMap());
            WorkflowTaskResult workflowTaskResult = WorkflowTaskResult.newBuilder().setCommands(commands).setQueryResults(this.queryResults).setFinalCommand(this.replayWorkflowExecutor.isCompleted()).setForceWorkflowTask(this.localActivityTaskCount > 0 && !this.replayWorkflowExecutor.isCompleted()).build();
            return workflowTaskResult;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void handleWorkflowTaskImpl(PollWorkflowTaskQueueResponseOrBuilder workflowTask) {
        Stopwatch sw = this.metricsScope.timer("temporal_workflow_task_replay_latency").start();
        boolean timerStopped = false;
        try {
            this.workflowStateMachines.setStartedIds(workflowTask.getPreviousStartedEventId(), workflowTask.getStartedEventId());
            WorkflowHistoryIterator historyEvents = new WorkflowHistoryIterator(this.service, this.namespace, workflowTask, ProtobufTimeUtils.toJavaDuration(this.startedEvent.getWorkflowTaskTimeout()), this.metricsScope);
            while (historyEvents.hasNext()) {
                HistoryEvent event = (HistoryEvent)historyEvents.next();
                this.handleEvent(event, historyEvents.hasNext());
                if (timerStopped || this.workflowStateMachines.isReplaying()) continue;
                sw.stop();
                timerStopped = true;
            }
        }
        catch (Throwable e2) {
            Class<? extends Throwable>[] failTypes;
            WorkflowImplementationOptions implementationOptions = this.replayWorkflowExecutor.getWorkflowImplementationOptions();
            for (Class<? extends Throwable> failType : failTypes = implementationOptions.getFailWorkflowExceptionTypes()) {
                InternalWorkflowTaskException e2;
                if (!failType.isAssignableFrom(e2.getClass())) continue;
                if (!(e2 instanceof InternalWorkflowTaskException)) {
                    e2 = new InternalWorkflowTaskException(e2);
                }
                throw this.replayWorkflowExecutor.mapUnexpectedException(e2);
            }
            this.metricsScope.counter("temporal_workflow_task_no_completion").inc(1L);
            throw CheckedExceptionWrapper.wrap((Throwable)e2);
        }
        finally {
            if (!timerStopped) {
                sw.stop();
            }
            if (this.replayWorkflowExecutor.isCompleted()) {
                this.close();
            }
        }
    }

    private void executeQueries(Map<String, WorkflowQuery> queries) {
        for (Map.Entry<String, WorkflowQuery> entry : queries.entrySet()) {
            WorkflowQuery query = entry.getValue();
            try {
                Optional<Payloads> queryResult = this.replayWorkflowExecutor.query(query);
                WorkflowQueryResult.Builder result = WorkflowQueryResult.newBuilder().setResultType(QueryResultType.QUERY_RESULT_TYPE_ANSWERED);
                if (queryResult.isPresent()) {
                    result.setAnswer(queryResult.get());
                }
                this.queryResults.put(entry.getKey(), result.build());
            }
            catch (Exception e) {
                String stackTrace = Throwables.getStackTraceAsString((Throwable)e);
                this.queryResults.put(entry.getKey(), WorkflowQueryResult.newBuilder().setResultType(QueryResultType.QUERY_RESULT_TYPE_FAILED).setErrorMessage(e.toString() + "\n" + stackTrace).build());
            }
        }
    }

    @Override
    public void close() {
        this.lock.lock();
        try {
            this.replayWorkflowExecutor.close();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<Payloads> handleQueryWorkflowTask(PollWorkflowTaskQueueResponseOrBuilder workflowTask, WorkflowQuery query) {
        this.lock.lock();
        try {
            AtomicReference<Optional<Payloads>> result = new AtomicReference<Optional<Payloads>>();
            this.handleWorkflowTaskImpl(workflowTask);
            result.set(this.replayWorkflowExecutor.query(query));
            Optional optional = (Optional)result.get();
            return optional;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void processLocalActivityRequests(long startTime) {
        long forcedDecisionTimeout = (long)((double)Durations.toMillis((Duration)this.startedEvent.getWorkflowTaskTimeout()) * 0.8);
        long nextForcedDecisionTime = startTime + forcedDecisionTimeout;
        do {
            List<ExecuteLocalActivityParameters> laRequests = this.workflowStateMachines.takeLocalActivityRequests();
            for (ExecuteLocalActivityParameters laRequest : laRequests) {
                java.time.Duration maxWaitTime = java.time.Duration.ofMillis(nextForcedDecisionTime - System.currentTimeMillis());
                if (maxWaitTime.isNegative()) {
                    maxWaitTime = java.time.Duration.ZERO;
                }
                boolean accepted = this.localActivityTaskPoller.apply(new LocalActivityWorker.Task(laRequest, this.localActivityCompletionSink), maxWaitTime);
                ++this.localActivityTaskCount;
                if (accepted) continue;
                throw new Error("Unable to schedule local activity for execution");
            }
            if (this.localActivityTaskCount == 0) break;
            this.waitAndProcessLocalActivityCompletion(nextForcedDecisionTime);
        } while (nextForcedDecisionTime > System.currentTimeMillis());
    }

    private void waitAndProcessLocalActivityCompletion(long nextForcedDecisionTime) {
        ActivityTaskHandler.Result laCompletion;
        long maxWaitTime = nextForcedDecisionTime - System.currentTimeMillis();
        if (maxWaitTime <= 0L) {
            return;
        }
        try {
            laCompletion = this.localActivityCompletionQueue.poll(maxWaitTime, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("interrupted", e);
        }
        if (laCompletion == null) {
            return;
        }
        --this.localActivityTaskCount;
        this.workflowStateMachines.handleLocalActivityCompletion(laCompletion);
    }

    private class EntityManagerListenerImpl
    implements EntityManagerListener {
        private EntityManagerListenerImpl() {
        }

        @Override
        public void start(HistoryEvent startWorkflowEvent) {
            ReplayWorkflowRunTaskHandler.this.replayWorkflowExecutor.start(startWorkflowEvent);
        }

        @Override
        public void eventLoop() {
            ReplayWorkflowRunTaskHandler.this.replayWorkflowExecutor.eventLoop();
        }

        @Override
        public void signal(HistoryEvent signalEvent) {
            ReplayWorkflowRunTaskHandler.this.replayWorkflowExecutor.handleWorkflowExecutionSignaled(signalEvent);
        }

        @Override
        public void cancel(HistoryEvent cancelEvent) {
            ReplayWorkflowRunTaskHandler.this.replayWorkflowExecutor.handleWorkflowExecutionCancelRequested(cancelEvent);
        }
    }
}

