/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.testservice;

import io.grpc.BindableService;
import io.grpc.ManagedChannel;
import io.grpc.Server;
import io.grpc.inprocess.InProcessChannelBuilder;
import io.grpc.inprocess.InProcessServerBuilder;
import io.temporal.internal.testservice.GRPCServerHelper;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class InProcessGRPCServer {
    private final Server server;
    @Nullable
    private final ManagedChannel channel;

    public InProcessGRPCServer(Collection<BindableService> services) {
        this(services, true);
    }

    public InProcessGRPCServer(Collection<BindableService> services, boolean createChannel) {
        String serverName = InProcessServerBuilder.generateName();
        try {
            InProcessServerBuilder inProcessServerBuilder = InProcessServerBuilder.forName((String)serverName);
            GRPCServerHelper.registerServicesAndHealthChecks(services, inProcessServerBuilder);
            this.server = inProcessServerBuilder.build().start();
        }
        catch (IOException unexpected) {
            throw new RuntimeException(unexpected);
        }
        this.channel = createChannel ? ((InProcessChannelBuilder)InProcessChannelBuilder.forName((String)serverName).directExecutor()).build() : null;
    }

    public void shutdown() {
        if (this.channel != null) {
            this.channel.shutdown();
        }
        this.server.shutdown();
    }

    public void shutdownNow() {
        if (this.channel != null) {
            this.channel.shutdownNow();
        }
        this.server.shutdownNow();
    }

    public boolean isShutdown() {
        return (this.channel == null || this.channel.isShutdown()) && this.server.isShutdown();
    }

    public boolean isTerminated() {
        return (this.channel == null || this.channel.isTerminated()) && this.server.isTerminated();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) {
        long start = System.currentTimeMillis();
        long deadline = start + unit.toMillis(timeout);
        long left = deadline - System.currentTimeMillis();
        try {
            if (this.channel != null && !this.channel.awaitTermination(left, TimeUnit.MILLISECONDS)) {
                return false;
            }
            left = deadline - System.currentTimeMillis();
            return this.server.awaitTermination(left, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public Server getServer() {
        return this.server;
    }

    @Nullable
    public ManagedChannel getChannel() {
        return this.channel;
    }
}

