/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.testservice;

import com.google.protobuf.MessageLite;
import io.grpc.BindableService;
import io.grpc.ForwardingServerCallListener;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.Server;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import io.grpc.inprocess.InProcessChannelBuilder;
import io.grpc.inprocess.InProcessServerBuilder;
import io.temporal.internal.testservice.GRPCServerHelper;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class InProcessGRPCServer {
    private final Server server;
    @Nullable
    private final ManagedChannel channel;

    public InProcessGRPCServer(Collection<BindableService> services) {
        this(services, true);
    }

    public InProcessGRPCServer(Collection<BindableService> services, boolean createChannel) {
        String serverName = InProcessServerBuilder.generateName();
        try {
            InProcessServerBuilder inProcessServerBuilder = InProcessServerBuilder.forName((String)serverName);
            GRPCServerHelper.registerServicesAndHealthChecks(services, inProcessServerBuilder, Collections.singletonList(new MessageSizeChecker()));
            this.server = inProcessServerBuilder.build().start();
        }
        catch (IOException unexpected) {
            throw new RuntimeException(unexpected);
        }
        this.channel = createChannel ? ((InProcessChannelBuilder)InProcessChannelBuilder.forName((String)serverName).directExecutor()).build() : null;
    }

    public void shutdown() {
        if (this.channel != null) {
            this.channel.shutdown();
        }
        this.server.shutdown();
    }

    public void shutdownNow() {
        if (this.channel != null) {
            this.channel.shutdownNow();
        }
        this.server.shutdownNow();
    }

    public boolean isShutdown() {
        return (this.channel == null || this.channel.isShutdown()) && this.server.isShutdown();
    }

    public boolean isTerminated() {
        return (this.channel == null || this.channel.isTerminated()) && this.server.isTerminated();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) {
        long start = System.currentTimeMillis();
        long deadline = start + unit.toMillis(timeout);
        long left = deadline - System.currentTimeMillis();
        try {
            if (this.channel != null && !this.channel.awaitTermination(left, TimeUnit.MILLISECONDS)) {
                return false;
            }
            left = deadline - System.currentTimeMillis();
            return this.server.awaitTermination(left, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public Server getServer() {
        return this.server;
    }

    @Nullable
    public ManagedChannel getChannel() {
        return this.channel;
    }

    public static class MessageSizeChecker
    implements ServerInterceptor {
        private final int maxMessageSize;

        public MessageSizeChecker() {
            this(0x400000);
        }

        public MessageSizeChecker(int maxMessageSize) {
            this.maxMessageSize = maxMessageSize;
        }

        public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
            call.request(1);
            return new Listener<ReqT, RespT>(call, headers, next);
        }

        private class Listener<ReqT, RespT>
        extends ForwardingServerCallListener<ReqT> {
            private final ServerCall<ReqT, RespT> call;
            private final Metadata headers;
            private final ServerCallHandler<ReqT, RespT> next;
            private ServerCall.Listener<ReqT> delegate;
            private boolean delegateSet;

            public Listener(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
                this.call = call;
                this.headers = headers;
                this.next = next;
                this.delegate = new ServerCall.Listener<ReqT>(){};
                this.delegateSet = false;
            }

            protected ServerCall.Listener<ReqT> delegate() {
                return this.delegate;
            }

            public void onMessage(ReqT message) {
                int size = ((MessageLite)message).getSerializedSize();
                if (size > MessageSizeChecker.this.maxMessageSize) {
                    this.call.close(Status.RESOURCE_EXHAUSTED.withDescription(String.format("grpc: received message larger than max (%d vs. %d)", size, MessageSizeChecker.this.maxMessageSize)), new Metadata());
                } else {
                    if (!this.delegateSet) {
                        this.delegateSet = true;
                        this.delegate = this.next.startCall(this.call, this.headers);
                    }
                    super.onMessage(message);
                }
            }
        }
    }
}

