/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.arquillian.resolver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.aether.transfer.AbstractTransferListener;
import org.eclipse.aether.transfer.TransferEvent;
import org.wildfly.swarm.arquillian.resolver.CompletableTransferListener;

public class FailureReportingTransferListener
extends AbstractTransferListener
implements CompletableTransferListener {
    private final Map<String, List<TransferEvent>> transfers = new HashMap<String, List<TransferEvent>>();

    public void transferSucceeded(TransferEvent event) {
        this.transfers.remove(event.getResource().getResourceName());
    }

    public void transferFailed(TransferEvent event) {
        String resourceName = event.getResource().getResourceName();
        List<TransferEvent> events = this.transfers.get(resourceName);
        if (events == null) {
            events = new ArrayList<TransferEvent>();
            this.transfers.put(resourceName, events);
        }
        events.add(event);
    }

    @Override
    public void complete() {
        if (this.hasFailures()) {
            System.err.print(this.failuresAsString());
            this.transfers.clear();
        }
    }

    public boolean hasFailures() {
        return !this.transfers.isEmpty();
    }

    public String failuresAsString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, List<TransferEvent>> entry : this.transfers.entrySet()) {
            String resourceName = entry.getKey();
            for (TransferEvent event : entry.getValue()) {
                sb.append("Failed").append(event.getRequestType() == TransferEvent.RequestType.PUT ? " uploading " : " downloading ").append(resourceName).append(event.getRequestType() == TransferEvent.RequestType.PUT ? " into " : " from ").append(event.getResource().getRepositoryUrl()).append(". ");
                if (event.getException() != null) {
                    sb.append("Reason: \n").append(event.getException());
                }
                sb.append('\n');
            }
        }
        return sb.toString();
    }
}

