/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.runtime.invocation;

import java.lang.annotation.Annotation;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Addresses;
import org.wildfly.swarm.config.runtime.invocation.IndexFactory;
import org.wildfly.swarm.config.runtime.model.AddressTemplate;

public class Addressing {
    public static AddressTemplate of(Class<?> entity) {
        Index index = IndexFactory.createIndex(entity);
        ClassInfo clazz = index.getClassByName(DotName.createSimple((String)entity.getCanonicalName()));
        AddressTemplate addr = null;
        for (AnnotationInstance annotation : clazz.classAnnotations()) {
            Annotation meta;
            if (annotation.name().equals((Object)IndexFactory.ADDRESS_META)) {
                meta = entity.getAnnotation(Address.class);
                addr = AddressTemplate.of(meta.value());
                continue;
            }
            if (!annotation.name().equals((Object)IndexFactory.ADDRESSES_META)) continue;
            meta = entity.getAnnotation(Addresses.class);
            StringBuffer sb = new StringBuffer("\n");
            for (String s : meta.value()) {
                sb.append(s).append("\n");
            }
            throw new RuntimeException("Ambiguous resource reference on class " + entity + ": " + sb.toString());
        }
        if (null == addr) {
            throw new RuntimeException("Missing resource reference on class " + entity);
        }
        return addr;
    }
}

