package org.wildfly.swarm.config;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.elytron.CustomPrincipalTransformerConsumer;
import org.wildfly.swarm.config.elytron.CustomPrincipalTransformerSupplier;
import org.wildfly.swarm.config.elytron.CustomPrincipalTransformer;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.elytron.ConstantPrincipalDecoderConsumer;
import org.wildfly.swarm.config.elytron.ConstantPrincipalDecoderSupplier;
import org.wildfly.swarm.config.elytron.ConstantPrincipalDecoder;
import org.wildfly.swarm.config.elytron.AggregateRealmConsumer;
import org.wildfly.swarm.config.elytron.AggregateRealmSupplier;
import org.wildfly.swarm.config.elytron.AggregateRealm;
import org.wildfly.swarm.config.elytron.CustomRoleMapperConsumer;
import org.wildfly.swarm.config.elytron.CustomRoleMapperSupplier;
import org.wildfly.swarm.config.elytron.CustomRoleMapper;
import org.wildfly.swarm.config.elytron.FilesystemRealmConsumer;
import org.wildfly.swarm.config.elytron.FilesystemRealmSupplier;
import org.wildfly.swarm.config.elytron.FilesystemRealm;
import org.wildfly.swarm.config.elytron.CertificateAuthorityAccountConsumer;
import org.wildfly.swarm.config.elytron.CertificateAuthorityAccountSupplier;
import org.wildfly.swarm.config.elytron.CertificateAuthorityAccount;
import org.wildfly.swarm.config.elytron.LogicalPermissionMapperConsumer;
import org.wildfly.swarm.config.elytron.LogicalPermissionMapperSupplier;
import org.wildfly.swarm.config.elytron.LogicalPermissionMapper;
import org.wildfly.swarm.config.elytron.ConstantPrincipalTransformerConsumer;
import org.wildfly.swarm.config.elytron.ConstantPrincipalTransformerSupplier;
import org.wildfly.swarm.config.elytron.ConstantPrincipalTransformer;
import org.wildfly.swarm.config.elytron.CustomRealmConsumer;
import org.wildfly.swarm.config.elytron.CustomRealmSupplier;
import org.wildfly.swarm.config.elytron.CustomRealm;
import org.wildfly.swarm.config.elytron.SASLAuthenticationFactoryConsumer;
import org.wildfly.swarm.config.elytron.SASLAuthenticationFactorySupplier;
import org.wildfly.swarm.config.elytron.SASLAuthenticationFactory;
import org.wildfly.swarm.config.elytron.ServiceLoaderHTTPServerMechanismFactoryConsumer;
import org.wildfly.swarm.config.elytron.ServiceLoaderHTTPServerMechanismFactorySupplier;
import org.wildfly.swarm.config.elytron.ServiceLoaderHTTPServerMechanismFactory;
import org.wildfly.swarm.config.elytron.JDBCRealmConsumer;
import org.wildfly.swarm.config.elytron.JDBCRealmSupplier;
import org.wildfly.swarm.config.elytron.JDBCRealm;
import org.wildfly.swarm.config.elytron.JaspiConfigurationConsumer;
import org.wildfly.swarm.config.elytron.JaspiConfigurationSupplier;
import org.wildfly.swarm.config.elytron.JaspiConfiguration;
import org.wildfly.swarm.config.elytron.CustomRoleDecoderConsumer;
import org.wildfly.swarm.config.elytron.CustomRoleDecoderSupplier;
import org.wildfly.swarm.config.elytron.CustomRoleDecoder;
import org.wildfly.swarm.config.elytron.CredentialStoreConsumer;
import org.wildfly.swarm.config.elytron.CredentialStoreSupplier;
import org.wildfly.swarm.config.elytron.CredentialStore;
import org.wildfly.swarm.config.elytron.KerberosSecurityFactoryConsumer;
import org.wildfly.swarm.config.elytron.KerberosSecurityFactorySupplier;
import org.wildfly.swarm.config.elytron.KerberosSecurityFactory;
import org.wildfly.swarm.config.elytron.ConfigurableHTTPServerMechanismFactoryConsumer;
import org.wildfly.swarm.config.elytron.ConfigurableHTTPServerMechanismFactorySupplier;
import org.wildfly.swarm.config.elytron.ConfigurableHTTPServerMechanismFactory;
import org.wildfly.swarm.config.elytron.ProviderHTTPServerMechanismFactoryConsumer;
import org.wildfly.swarm.config.elytron.ProviderHTTPServerMechanismFactorySupplier;
import org.wildfly.swarm.config.elytron.ProviderHTTPServerMechanismFactory;
import org.wildfly.swarm.config.elytron.LogicalRoleMapperConsumer;
import org.wildfly.swarm.config.elytron.LogicalRoleMapperSupplier;
import org.wildfly.swarm.config.elytron.LogicalRoleMapper;
import org.wildfly.swarm.config.elytron.AggregateRoleMapperConsumer;
import org.wildfly.swarm.config.elytron.AggregateRoleMapperSupplier;
import org.wildfly.swarm.config.elytron.AggregateRoleMapper;
import org.wildfly.swarm.config.elytron.ProviderLoaderConsumer;
import org.wildfly.swarm.config.elytron.ProviderLoaderSupplier;
import org.wildfly.swarm.config.elytron.ProviderLoader;
import org.wildfly.swarm.config.elytron.CustomPrincipalDecoderConsumer;
import org.wildfly.swarm.config.elytron.CustomPrincipalDecoderSupplier;
import org.wildfly.swarm.config.elytron.CustomPrincipalDecoder;
import org.wildfly.swarm.config.elytron.SizeRotatingFileAuditLogConsumer;
import org.wildfly.swarm.config.elytron.SizeRotatingFileAuditLogSupplier;
import org.wildfly.swarm.config.elytron.SizeRotatingFileAuditLog;
import org.wildfly.swarm.config.elytron.ConstantPermissionMapperConsumer;
import org.wildfly.swarm.config.elytron.ConstantPermissionMapperSupplier;
import org.wildfly.swarm.config.elytron.ConstantPermissionMapper;
import org.wildfly.swarm.config.elytron.TokenRealmConsumer;
import org.wildfly.swarm.config.elytron.TokenRealmSupplier;
import org.wildfly.swarm.config.elytron.TokenRealm;
import org.wildfly.swarm.config.elytron.ClientSslContextConsumer;
import org.wildfly.swarm.config.elytron.ClientSslContextSupplier;
import org.wildfly.swarm.config.elytron.ClientSslContext;
import org.wildfly.swarm.config.elytron.SecurityDomainConsumer;
import org.wildfly.swarm.config.elytron.SecurityDomainSupplier;
import org.wildfly.swarm.config.elytron.SecurityDomain;
import org.wildfly.swarm.config.elytron.ConstantRoleMapperConsumer;
import org.wildfly.swarm.config.elytron.ConstantRoleMapperSupplier;
import org.wildfly.swarm.config.elytron.ConstantRoleMapper;
import org.wildfly.swarm.config.elytron.IdentityRealmConsumer;
import org.wildfly.swarm.config.elytron.IdentityRealmSupplier;
import org.wildfly.swarm.config.elytron.IdentityRealm;
import org.wildfly.swarm.config.elytron.FilteringKeyStoreConsumer;
import org.wildfly.swarm.config.elytron.FilteringKeyStoreSupplier;
import org.wildfly.swarm.config.elytron.FilteringKeyStore;
import org.wildfly.swarm.config.elytron.PropertiesRealmConsumer;
import org.wildfly.swarm.config.elytron.PropertiesRealmSupplier;
import org.wildfly.swarm.config.elytron.PropertiesRealm;
import org.wildfly.swarm.config.elytron.AggregatePrincipalDecoderConsumer;
import org.wildfly.swarm.config.elytron.AggregatePrincipalDecoderSupplier;
import org.wildfly.swarm.config.elytron.AggregatePrincipalDecoder;
import org.wildfly.swarm.config.elytron.AggregatePrincipalTransformerConsumer;
import org.wildfly.swarm.config.elytron.AggregatePrincipalTransformerSupplier;
import org.wildfly.swarm.config.elytron.AggregatePrincipalTransformer;
import org.wildfly.swarm.config.elytron.ServerSslSniContextConsumer;
import org.wildfly.swarm.config.elytron.ServerSslSniContextSupplier;
import org.wildfly.swarm.config.elytron.ServerSslSniContext;
import org.wildfly.swarm.config.elytron.CustomCredentialSecurityFactoryConsumer;
import org.wildfly.swarm.config.elytron.CustomCredentialSecurityFactorySupplier;
import org.wildfly.swarm.config.elytron.CustomCredentialSecurityFactory;
import org.wildfly.swarm.config.elytron.PeriodicRotatingFileAuditLogConsumer;
import org.wildfly.swarm.config.elytron.PeriodicRotatingFileAuditLogSupplier;
import org.wildfly.swarm.config.elytron.PeriodicRotatingFileAuditLog;
import org.wildfly.swarm.config.elytron.SimplePermissionMapperConsumer;
import org.wildfly.swarm.config.elytron.SimplePermissionMapperSupplier;
import org.wildfly.swarm.config.elytron.SimplePermissionMapper;
import org.wildfly.swarm.config.elytron.MappedRoleMapperConsumer;
import org.wildfly.swarm.config.elytron.MappedRoleMapperSupplier;
import org.wildfly.swarm.config.elytron.MappedRoleMapper;
import org.wildfly.swarm.config.elytron.ConstantRealmMapperConsumer;
import org.wildfly.swarm.config.elytron.ConstantRealmMapperSupplier;
import org.wildfly.swarm.config.elytron.ConstantRealmMapper;
import org.wildfly.swarm.config.elytron.SimpleRoleDecoderConsumer;
import org.wildfly.swarm.config.elytron.SimpleRoleDecoderSupplier;
import org.wildfly.swarm.config.elytron.SimpleRoleDecoder;
import org.wildfly.swarm.config.elytron.ConfigurableSASLServerFactoryConsumer;
import org.wildfly.swarm.config.elytron.ConfigurableSASLServerFactorySupplier;
import org.wildfly.swarm.config.elytron.ConfigurableSASLServerFactory;
import org.wildfly.swarm.config.elytron.RegexValidatingPrincipalTransformerConsumer;
import org.wildfly.swarm.config.elytron.RegexValidatingPrincipalTransformerSupplier;
import org.wildfly.swarm.config.elytron.RegexValidatingPrincipalTransformer;
import org.wildfly.swarm.config.elytron.ServiceLoaderSASLServerFactoryConsumer;
import org.wildfly.swarm.config.elytron.ServiceLoaderSASLServerFactorySupplier;
import org.wildfly.swarm.config.elytron.ServiceLoaderSASLServerFactory;
import org.wildfly.swarm.config.elytron.PermissionSetConsumer;
import org.wildfly.swarm.config.elytron.PermissionSetSupplier;
import org.wildfly.swarm.config.elytron.PermissionSet;
import org.wildfly.swarm.config.elytron.LdapKeyStoreConsumer;
import org.wildfly.swarm.config.elytron.LdapKeyStoreSupplier;
import org.wildfly.swarm.config.elytron.LdapKeyStore;
import org.wildfly.swarm.config.elytron.X500AttributePrincipalDecoderConsumer;
import org.wildfly.swarm.config.elytron.X500AttributePrincipalDecoderSupplier;
import org.wildfly.swarm.config.elytron.X500AttributePrincipalDecoder;
import org.wildfly.swarm.config.elytron.DirContextConsumer;
import org.wildfly.swarm.config.elytron.DirContextSupplier;
import org.wildfly.swarm.config.elytron.DirContext;
import org.wildfly.swarm.config.elytron.MappedRegexRealmMapperConsumer;
import org.wildfly.swarm.config.elytron.MappedRegexRealmMapperSupplier;
import org.wildfly.swarm.config.elytron.MappedRegexRealmMapper;
import org.wildfly.swarm.config.elytron.SyslogAuditLogConsumer;
import org.wildfly.swarm.config.elytron.SyslogAuditLogSupplier;
import org.wildfly.swarm.config.elytron.SyslogAuditLog;
import org.wildfly.swarm.config.elytron.AggregateSecurityEventListenerConsumer;
import org.wildfly.swarm.config.elytron.AggregateSecurityEventListenerSupplier;
import org.wildfly.swarm.config.elytron.AggregateSecurityEventListener;
import org.wildfly.swarm.config.elytron.ChainedPrincipalTransformerConsumer;
import org.wildfly.swarm.config.elytron.ChainedPrincipalTransformerSupplier;
import org.wildfly.swarm.config.elytron.ChainedPrincipalTransformer;
import org.wildfly.swarm.config.elytron.AuthenticationContextConsumer;
import org.wildfly.swarm.config.elytron.AuthenticationContextSupplier;
import org.wildfly.swarm.config.elytron.AuthenticationContext;
import org.wildfly.swarm.config.elytron.FileAuditLogConsumer;
import org.wildfly.swarm.config.elytron.FileAuditLogSupplier;
import org.wildfly.swarm.config.elytron.FileAuditLog;
import org.wildfly.swarm.config.elytron.KeyStoreRealmConsumer;
import org.wildfly.swarm.config.elytron.KeyStoreRealmSupplier;
import org.wildfly.swarm.config.elytron.KeyStoreRealm;
import org.wildfly.swarm.config.elytron.PolicyConsumer;
import org.wildfly.swarm.config.elytron.PolicySupplier;
import org.wildfly.swarm.config.elytron.Policy;
import org.wildfly.swarm.config.elytron.AuthenticationConfigurationConsumer;
import org.wildfly.swarm.config.elytron.AuthenticationConfigurationSupplier;
import org.wildfly.swarm.config.elytron.AuthenticationConfiguration;
import org.wildfly.swarm.config.elytron.ProviderSASLServerFactoryConsumer;
import org.wildfly.swarm.config.elytron.ProviderSASLServerFactorySupplier;
import org.wildfly.swarm.config.elytron.ProviderSASLServerFactory;
import org.wildfly.swarm.config.elytron.CustomModifiableRealmConsumer;
import org.wildfly.swarm.config.elytron.CustomModifiableRealmSupplier;
import org.wildfly.swarm.config.elytron.CustomModifiableRealm;
import org.wildfly.swarm.config.elytron.AddPrefixRoleMapperConsumer;
import org.wildfly.swarm.config.elytron.AddPrefixRoleMapperSupplier;
import org.wildfly.swarm.config.elytron.AddPrefixRoleMapper;
import org.wildfly.swarm.config.elytron.AggregateHTTPServerMechanismFactoryConsumer;
import org.wildfly.swarm.config.elytron.AggregateHTTPServerMechanismFactorySupplier;
import org.wildfly.swarm.config.elytron.AggregateHTTPServerMechanismFactory;
import org.wildfly.swarm.config.elytron.CustomRealmMapperConsumer;
import org.wildfly.swarm.config.elytron.CustomRealmMapperSupplier;
import org.wildfly.swarm.config.elytron.CustomRealmMapper;
import org.wildfly.swarm.config.elytron.RegexPrincipalTransformerConsumer;
import org.wildfly.swarm.config.elytron.RegexPrincipalTransformerSupplier;
import org.wildfly.swarm.config.elytron.RegexPrincipalTransformer;
import org.wildfly.swarm.config.elytron.TrustManagerConsumer;
import org.wildfly.swarm.config.elytron.TrustManagerSupplier;
import org.wildfly.swarm.config.elytron.TrustManager;
import org.wildfly.swarm.config.elytron.MechanismProviderFilteringSASLServerFactoryConsumer;
import org.wildfly.swarm.config.elytron.MechanismProviderFilteringSASLServerFactorySupplier;
import org.wildfly.swarm.config.elytron.MechanismProviderFilteringSASLServerFactory;
import org.wildfly.swarm.config.elytron.LdapRealmConsumer;
import org.wildfly.swarm.config.elytron.LdapRealmSupplier;
import org.wildfly.swarm.config.elytron.LdapRealm;
import org.wildfly.swarm.config.elytron.AggregateProvidersConsumer;
import org.wildfly.swarm.config.elytron.AggregateProvidersSupplier;
import org.wildfly.swarm.config.elytron.AggregateProviders;
import org.wildfly.swarm.config.elytron.KeyStoreConsumer;
import org.wildfly.swarm.config.elytron.KeyStoreSupplier;
import org.wildfly.swarm.config.elytron.KeyStore;
import org.wildfly.swarm.config.elytron.HTTPAuthenticationFactoryConsumer;
import org.wildfly.swarm.config.elytron.HTTPAuthenticationFactorySupplier;
import org.wildfly.swarm.config.elytron.HTTPAuthenticationFactory;
import org.wildfly.swarm.config.elytron.AggregateSASLServerFactoryConsumer;
import org.wildfly.swarm.config.elytron.AggregateSASLServerFactorySupplier;
import org.wildfly.swarm.config.elytron.AggregateSASLServerFactory;
import org.wildfly.swarm.config.elytron.SimpleRegexRealmMapperConsumer;
import org.wildfly.swarm.config.elytron.SimpleRegexRealmMapperSupplier;
import org.wildfly.swarm.config.elytron.SimpleRegexRealmMapper;
import org.wildfly.swarm.config.elytron.CachingRealmConsumer;
import org.wildfly.swarm.config.elytron.CachingRealmSupplier;
import org.wildfly.swarm.config.elytron.CachingRealm;
import org.wildfly.swarm.config.elytron.KeyManagerConsumer;
import org.wildfly.swarm.config.elytron.KeyManagerSupplier;
import org.wildfly.swarm.config.elytron.KeyManager;
import org.wildfly.swarm.config.elytron.ServerSslContextConsumer;
import org.wildfly.swarm.config.elytron.ServerSslContextSupplier;
import org.wildfly.swarm.config.elytron.ServerSslContext;
import org.wildfly.swarm.config.elytron.AddSuffixRoleMapperConsumer;
import org.wildfly.swarm.config.elytron.AddSuffixRoleMapperSupplier;
import org.wildfly.swarm.config.elytron.AddSuffixRoleMapper;
import org.wildfly.swarm.config.elytron.CustomSecurityEventListenerConsumer;
import org.wildfly.swarm.config.elytron.CustomSecurityEventListenerSupplier;
import org.wildfly.swarm.config.elytron.CustomSecurityEventListener;
import org.wildfly.swarm.config.elytron.CustomPermissionMapperConsumer;
import org.wildfly.swarm.config.elytron.CustomPermissionMapperSupplier;
import org.wildfly.swarm.config.elytron.CustomPermissionMapper;
import org.wildfly.swarm.config.elytron.ConcatenatingPrincipalDecoderConsumer;
import org.wildfly.swarm.config.elytron.ConcatenatingPrincipalDecoderSupplier;
import org.wildfly.swarm.config.elytron.ConcatenatingPrincipalDecoder;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.Map;

/**
 * The Elytron Subsystem
 */
@Address("/subsystem=elytron")
@ResourceType("subsystem")
@Implicit
public class Elytron<T extends Elytron<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private ElytronResources subresources = new ElytronResources();
	@AttributeDocumentation("The default authentication context to be associated with all deployments.")
	private String defaultAuthenticationContext;
	@AttributeDocumentation("Reference to the SSLContext which should be globally registered as the default.")
	private String defaultSslContext;
	@AttributeDocumentation("A list of providers that are not allowed, and will be removed from the providers list.")
	private List<String> disallowedProviders;
	@AttributeDocumentation("Reference to the Providers that should be registered after all existing Providers.")
	private String finalProviders;
	@AttributeDocumentation("Reference to the Providers that should be registered ahead of all existing Providers.")
	private String initialProviders;
	@AttributeDocumentation("Should the Elytron JASPI factory be globally registered?")
	private Boolean registerJaspiFactory;
	@AttributeDocumentation("Security properties to be set.")
	private Map securityProperties;

	public Elytron() {
		super();
		this.key = "elytron";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public ElytronResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all CustomPrincipalTransformer objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of CustomPrincipalTransformer objects.
	 */
	@SuppressWarnings("unchecked")
	public T customPrincipalTransformers(
			java.util.List<CustomPrincipalTransformer> value) {
		this.subresources.customPrincipalTransformers = value;
		return (T) this;
	}

	/**
	 * Add the CustomPrincipalTransformer object to the list of subresources
	 * 
	 * @param value
	 *            The CustomPrincipalTransformer to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T customPrincipalTransformer(CustomPrincipalTransformer value) {
		this.subresources.customPrincipalTransformers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a CustomPrincipalTransformer object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the CustomPrincipalTransformer resource
	 * @param config
	 *            The CustomPrincipalTransformerConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T customPrincipalTransformer(java.lang.String childKey,
			CustomPrincipalTransformerConsumer consumer) {
		CustomPrincipalTransformer<? extends CustomPrincipalTransformer> child = new CustomPrincipalTransformer<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		customPrincipalTransformer(child);
		return (T) this;
	}

	/**
	 * Create and configure a CustomPrincipalTransformer object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the CustomPrincipalTransformer resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T customPrincipalTransformer(java.lang.String childKey) {
		customPrincipalTransformer(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied CustomPrincipalTransformer object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T customPrincipalTransformer(
			CustomPrincipalTransformerSupplier supplier) {
		customPrincipalTransformer(supplier.get());
		return (T) this;
	}

	/**
	 * Add all ConstantPrincipalDecoder objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ConstantPrincipalDecoder objects.
	 */
	@SuppressWarnings("unchecked")
	public T constantPrincipalDecoders(
			java.util.List<ConstantPrincipalDecoder> value) {
		this.subresources.constantPrincipalDecoders = value;
		return (T) this;
	}

	/**
	 * Add the ConstantPrincipalDecoder object to the list of subresources
	 * 
	 * @param value
	 *            The ConstantPrincipalDecoder to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T constantPrincipalDecoder(ConstantPrincipalDecoder value) {
		this.subresources.constantPrincipalDecoders.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ConstantPrincipalDecoder object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ConstantPrincipalDecoder resource
	 * @param config
	 *            The ConstantPrincipalDecoderConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T constantPrincipalDecoder(java.lang.String childKey,
			ConstantPrincipalDecoderConsumer consumer) {
		ConstantPrincipalDecoder<? extends ConstantPrincipalDecoder> child = new ConstantPrincipalDecoder<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		constantPrincipalDecoder(child);
		return (T) this;
	}

	/**
	 * Create and configure a ConstantPrincipalDecoder object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ConstantPrincipalDecoder resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T constantPrincipalDecoder(java.lang.String childKey) {
		constantPrincipalDecoder(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ConstantPrincipalDecoder object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T constantPrincipalDecoder(ConstantPrincipalDecoderSupplier supplier) {
		constantPrincipalDecoder(supplier.get());
		return (T) this;
	}

	/**
	 * Add all AggregateRealm objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of AggregateRealm objects.
	 */
	@SuppressWarnings("unchecked")
	public T aggregateRealms(java.util.List<AggregateRealm> value) {
		this.subresources.aggregateRealms = value;
		return (T) this;
	}

	/**
	 * Add the AggregateRealm object to the list of subresources
	 * 
	 * @param value
	 *            The AggregateRealm to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T aggregateRealm(AggregateRealm value) {
		this.subresources.aggregateRealms.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a AggregateRealm object to the list of subresources
	 * 
	 * @param key
	 *            The key for the AggregateRealm resource
	 * @param config
	 *            The AggregateRealmConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T aggregateRealm(java.lang.String childKey,
			AggregateRealmConsumer consumer) {
		AggregateRealm<? extends AggregateRealm> child = new AggregateRealm<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		aggregateRealm(child);
		return (T) this;
	}

	/**
	 * Create and configure a AggregateRealm object to the list of subresources
	 * 
	 * @param key
	 *            The key for the AggregateRealm resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T aggregateRealm(java.lang.String childKey) {
		aggregateRealm(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied AggregateRealm object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T aggregateRealm(AggregateRealmSupplier supplier) {
		aggregateRealm(supplier.get());
		return (T) this;
	}

	/**
	 * Add all CustomRoleMapper objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of CustomRoleMapper objects.
	 */
	@SuppressWarnings("unchecked")
	public T customRoleMappers(java.util.List<CustomRoleMapper> value) {
		this.subresources.customRoleMappers = value;
		return (T) this;
	}

	/**
	 * Add the CustomRoleMapper object to the list of subresources
	 * 
	 * @param value
	 *            The CustomRoleMapper to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T customRoleMapper(CustomRoleMapper value) {
		this.subresources.customRoleMappers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a CustomRoleMapper object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the CustomRoleMapper resource
	 * @param config
	 *            The CustomRoleMapperConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T customRoleMapper(java.lang.String childKey,
			CustomRoleMapperConsumer consumer) {
		CustomRoleMapper<? extends CustomRoleMapper> child = new CustomRoleMapper<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		customRoleMapper(child);
		return (T) this;
	}

	/**
	 * Create and configure a CustomRoleMapper object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the CustomRoleMapper resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T customRoleMapper(java.lang.String childKey) {
		customRoleMapper(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied CustomRoleMapper object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T customRoleMapper(CustomRoleMapperSupplier supplier) {
		customRoleMapper(supplier.get());
		return (T) this;
	}

	/**
	 * Add all FilesystemRealm objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of FilesystemRealm objects.
	 */
	@SuppressWarnings("unchecked")
	public T filesystemRealms(java.util.List<FilesystemRealm> value) {
		this.subresources.filesystemRealms = value;
		return (T) this;
	}

	/**
	 * Add the FilesystemRealm object to the list of subresources
	 * 
	 * @param value
	 *            The FilesystemRealm to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T filesystemRealm(FilesystemRealm value) {
		this.subresources.filesystemRealms.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a FilesystemRealm object to the list of subresources
	 * 
	 * @param key
	 *            The key for the FilesystemRealm resource
	 * @param config
	 *            The FilesystemRealmConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T filesystemRealm(java.lang.String childKey,
			FilesystemRealmConsumer consumer) {
		FilesystemRealm<? extends FilesystemRealm> child = new FilesystemRealm<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		filesystemRealm(child);
		return (T) this;
	}

	/**
	 * Create and configure a FilesystemRealm object to the list of subresources
	 * 
	 * @param key
	 *            The key for the FilesystemRealm resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T filesystemRealm(java.lang.String childKey) {
		filesystemRealm(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied FilesystemRealm object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T filesystemRealm(FilesystemRealmSupplier supplier) {
		filesystemRealm(supplier.get());
		return (T) this;
	}

	/**
	 * Add all CertificateAuthorityAccount objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of CertificateAuthorityAccount objects.
	 */
	@SuppressWarnings("unchecked")
	public T certificateAuthorityAccounts(
			java.util.List<CertificateAuthorityAccount> value) {
		this.subresources.certificateAuthorityAccounts = value;
		return (T) this;
	}

	/**
	 * Add the CertificateAuthorityAccount object to the list of subresources
	 * 
	 * @param value
	 *            The CertificateAuthorityAccount to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T certificateAuthorityAccount(CertificateAuthorityAccount value) {
		this.subresources.certificateAuthorityAccounts.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a CertificateAuthorityAccount object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the CertificateAuthorityAccount resource
	 * @param config
	 *            The CertificateAuthorityAccountConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T certificateAuthorityAccount(java.lang.String childKey,
			CertificateAuthorityAccountConsumer consumer) {
		CertificateAuthorityAccount<? extends CertificateAuthorityAccount> child = new CertificateAuthorityAccount<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		certificateAuthorityAccount(child);
		return (T) this;
	}

	/**
	 * Create and configure a CertificateAuthorityAccount object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the CertificateAuthorityAccount resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T certificateAuthorityAccount(java.lang.String childKey) {
		certificateAuthorityAccount(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied CertificateAuthorityAccount object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T certificateAuthorityAccount(
			CertificateAuthorityAccountSupplier supplier) {
		certificateAuthorityAccount(supplier.get());
		return (T) this;
	}

	/**
	 * Add all LogicalPermissionMapper objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of LogicalPermissionMapper objects.
	 */
	@SuppressWarnings("unchecked")
	public T logicalPermissionMappers(
			java.util.List<LogicalPermissionMapper> value) {
		this.subresources.logicalPermissionMappers = value;
		return (T) this;
	}

	/**
	 * Add the LogicalPermissionMapper object to the list of subresources
	 * 
	 * @param value
	 *            The LogicalPermissionMapper to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T logicalPermissionMapper(LogicalPermissionMapper value) {
		this.subresources.logicalPermissionMappers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a LogicalPermissionMapper object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the LogicalPermissionMapper resource
	 * @param config
	 *            The LogicalPermissionMapperConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T logicalPermissionMapper(java.lang.String childKey,
			LogicalPermissionMapperConsumer consumer) {
		LogicalPermissionMapper<? extends LogicalPermissionMapper> child = new LogicalPermissionMapper<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		logicalPermissionMapper(child);
		return (T) this;
	}

	/**
	 * Create and configure a LogicalPermissionMapper object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the LogicalPermissionMapper resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T logicalPermissionMapper(java.lang.String childKey) {
		logicalPermissionMapper(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied LogicalPermissionMapper object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T logicalPermissionMapper(LogicalPermissionMapperSupplier supplier) {
		logicalPermissionMapper(supplier.get());
		return (T) this;
	}

	/**
	 * Add all ConstantPrincipalTransformer objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ConstantPrincipalTransformer objects.
	 */
	@SuppressWarnings("unchecked")
	public T constantPrincipalTransformers(
			java.util.List<ConstantPrincipalTransformer> value) {
		this.subresources.constantPrincipalTransformers = value;
		return (T) this;
	}

	/**
	 * Add the ConstantPrincipalTransformer object to the list of subresources
	 * 
	 * @param value
	 *            The ConstantPrincipalTransformer to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T constantPrincipalTransformer(ConstantPrincipalTransformer value) {
		this.subresources.constantPrincipalTransformers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ConstantPrincipalTransformer object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ConstantPrincipalTransformer resource
	 * @param config
	 *            The ConstantPrincipalTransformerConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T constantPrincipalTransformer(java.lang.String childKey,
			ConstantPrincipalTransformerConsumer consumer) {
		ConstantPrincipalTransformer<? extends ConstantPrincipalTransformer> child = new ConstantPrincipalTransformer<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		constantPrincipalTransformer(child);
		return (T) this;
	}

	/**
	 * Create and configure a ConstantPrincipalTransformer object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ConstantPrincipalTransformer resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T constantPrincipalTransformer(java.lang.String childKey) {
		constantPrincipalTransformer(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ConstantPrincipalTransformer object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T constantPrincipalTransformer(
			ConstantPrincipalTransformerSupplier supplier) {
		constantPrincipalTransformer(supplier.get());
		return (T) this;
	}

	/**
	 * Add all CustomRealm objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of CustomRealm objects.
	 */
	@SuppressWarnings("unchecked")
	public T customRealms(java.util.List<CustomRealm> value) {
		this.subresources.customRealms = value;
		return (T) this;
	}

	/**
	 * Add the CustomRealm object to the list of subresources
	 * 
	 * @param value
	 *            The CustomRealm to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T customRealm(CustomRealm value) {
		this.subresources.customRealms.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a CustomRealm object to the list of subresources
	 * 
	 * @param key
	 *            The key for the CustomRealm resource
	 * @param config
	 *            The CustomRealmConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T customRealm(java.lang.String childKey, CustomRealmConsumer consumer) {
		CustomRealm<? extends CustomRealm> child = new CustomRealm<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		customRealm(child);
		return (T) this;
	}

	/**
	 * Create and configure a CustomRealm object to the list of subresources
	 * 
	 * @param key
	 *            The key for the CustomRealm resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T customRealm(java.lang.String childKey) {
		customRealm(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied CustomRealm object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T customRealm(CustomRealmSupplier supplier) {
		customRealm(supplier.get());
		return (T) this;
	}

	/**
	 * Add all SASLAuthenticationFactory objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of SASLAuthenticationFactory objects.
	 */
	@SuppressWarnings("unchecked")
	public T saslAuthenticationFactories(
			java.util.List<SASLAuthenticationFactory> value) {
		this.subresources.saslAuthenticationFactories = value;
		return (T) this;
	}

	/**
	 * Add the SASLAuthenticationFactory object to the list of subresources
	 * 
	 * @param value
	 *            The SASLAuthenticationFactory to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T saslAuthenticationFactory(SASLAuthenticationFactory value) {
		this.subresources.saslAuthenticationFactories.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a SASLAuthenticationFactory object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the SASLAuthenticationFactory resource
	 * @param config
	 *            The SASLAuthenticationFactoryConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T saslAuthenticationFactory(java.lang.String childKey,
			SASLAuthenticationFactoryConsumer consumer) {
		SASLAuthenticationFactory<? extends SASLAuthenticationFactory> child = new SASLAuthenticationFactory<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		saslAuthenticationFactory(child);
		return (T) this;
	}

	/**
	 * Create and configure a SASLAuthenticationFactory object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the SASLAuthenticationFactory resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T saslAuthenticationFactory(java.lang.String childKey) {
		saslAuthenticationFactory(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied SASLAuthenticationFactory object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T saslAuthenticationFactory(
			SASLAuthenticationFactorySupplier supplier) {
		saslAuthenticationFactory(supplier.get());
		return (T) this;
	}

	/**
	 * Add all ServiceLoaderHTTPServerMechanismFactory objects to this
	 * subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ServiceLoaderHTTPServerMechanismFactory objects.
	 */
	@SuppressWarnings("unchecked")
	public T serviceLoaderHttpServerMechanismFactories(
			java.util.List<ServiceLoaderHTTPServerMechanismFactory> value) {
		this.subresources.serviceLoaderHttpServerMechanismFactories = value;
		return (T) this;
	}

	/**
	 * Add the ServiceLoaderHTTPServerMechanismFactory object to the list of
	 * subresources
	 * 
	 * @param value
	 *            The ServiceLoaderHTTPServerMechanismFactory to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T serviceLoaderHttpServerMechanismFactory(
			ServiceLoaderHTTPServerMechanismFactory value) {
		this.subresources.serviceLoaderHttpServerMechanismFactories.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ServiceLoaderHTTPServerMechanismFactory object to
	 * the list of subresources
	 * 
	 * @param key
	 *            The key for the ServiceLoaderHTTPServerMechanismFactory
	 *            resource
	 * @param config
	 *            The ServiceLoaderHTTPServerMechanismFactoryConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T serviceLoaderHttpServerMechanismFactory(java.lang.String childKey,
			ServiceLoaderHTTPServerMechanismFactoryConsumer consumer) {
		ServiceLoaderHTTPServerMechanismFactory<? extends ServiceLoaderHTTPServerMechanismFactory> child = new ServiceLoaderHTTPServerMechanismFactory<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		serviceLoaderHttpServerMechanismFactory(child);
		return (T) this;
	}

	/**
	 * Create and configure a ServiceLoaderHTTPServerMechanismFactory object to
	 * the list of subresources
	 * 
	 * @param key
	 *            The key for the ServiceLoaderHTTPServerMechanismFactory
	 *            resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T serviceLoaderHttpServerMechanismFactory(java.lang.String childKey) {
		serviceLoaderHttpServerMechanismFactory(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ServiceLoaderHTTPServerMechanismFactory object to the
	 * list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T serviceLoaderHttpServerMechanismFactory(
			ServiceLoaderHTTPServerMechanismFactorySupplier supplier) {
		serviceLoaderHttpServerMechanismFactory(supplier.get());
		return (T) this;
	}

	/**
	 * Add all JDBCRealm objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of JDBCRealm objects.
	 */
	@SuppressWarnings("unchecked")
	public T jdbcRealms(java.util.List<JDBCRealm> value) {
		this.subresources.jdbcRealms = value;
		return (T) this;
	}

	/**
	 * Add the JDBCRealm object to the list of subresources
	 * 
	 * @param value
	 *            The JDBCRealm to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T jdbcRealm(JDBCRealm value) {
		this.subresources.jdbcRealms.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a JDBCRealm object to the list of subresources
	 * 
	 * @param key
	 *            The key for the JDBCRealm resource
	 * @param config
	 *            The JDBCRealmConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T jdbcRealm(java.lang.String childKey, JDBCRealmConsumer consumer) {
		JDBCRealm<? extends JDBCRealm> child = new JDBCRealm<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		jdbcRealm(child);
		return (T) this;
	}

	/**
	 * Create and configure a JDBCRealm object to the list of subresources
	 * 
	 * @param key
	 *            The key for the JDBCRealm resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T jdbcRealm(java.lang.String childKey) {
		jdbcRealm(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied JDBCRealm object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T jdbcRealm(JDBCRealmSupplier supplier) {
		jdbcRealm(supplier.get());
		return (T) this;
	}

	/**
	 * Add all JaspiConfiguration objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of JaspiConfiguration objects.
	 */
	@SuppressWarnings("unchecked")
	public T jaspiConfigurations(java.util.List<JaspiConfiguration> value) {
		this.subresources.jaspiConfigurations = value;
		return (T) this;
	}

	/**
	 * Add the JaspiConfiguration object to the list of subresources
	 * 
	 * @param value
	 *            The JaspiConfiguration to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T jaspiConfiguration(JaspiConfiguration value) {
		this.subresources.jaspiConfigurations.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a JaspiConfiguration object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the JaspiConfiguration resource
	 * @param config
	 *            The JaspiConfigurationConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T jaspiConfiguration(java.lang.String childKey,
			JaspiConfigurationConsumer consumer) {
		JaspiConfiguration<? extends JaspiConfiguration> child = new JaspiConfiguration<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		jaspiConfiguration(child);
		return (T) this;
	}

	/**
	 * Create and configure a JaspiConfiguration object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the JaspiConfiguration resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T jaspiConfiguration(java.lang.String childKey) {
		jaspiConfiguration(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied JaspiConfiguration object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T jaspiConfiguration(JaspiConfigurationSupplier supplier) {
		jaspiConfiguration(supplier.get());
		return (T) this;
	}

	/**
	 * Add all CustomRoleDecoder objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of CustomRoleDecoder objects.
	 */
	@SuppressWarnings("unchecked")
	public T customRoleDecoders(java.util.List<CustomRoleDecoder> value) {
		this.subresources.customRoleDecoders = value;
		return (T) this;
	}

	/**
	 * Add the CustomRoleDecoder object to the list of subresources
	 * 
	 * @param value
	 *            The CustomRoleDecoder to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T customRoleDecoder(CustomRoleDecoder value) {
		this.subresources.customRoleDecoders.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a CustomRoleDecoder object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the CustomRoleDecoder resource
	 * @param config
	 *            The CustomRoleDecoderConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T customRoleDecoder(java.lang.String childKey,
			CustomRoleDecoderConsumer consumer) {
		CustomRoleDecoder<? extends CustomRoleDecoder> child = new CustomRoleDecoder<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		customRoleDecoder(child);
		return (T) this;
	}

	/**
	 * Create and configure a CustomRoleDecoder object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the CustomRoleDecoder resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T customRoleDecoder(java.lang.String childKey) {
		customRoleDecoder(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied CustomRoleDecoder object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T customRoleDecoder(CustomRoleDecoderSupplier supplier) {
		customRoleDecoder(supplier.get());
		return (T) this;
	}

	/**
	 * Add all CredentialStore objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of CredentialStore objects.
	 */
	@SuppressWarnings("unchecked")
	public T credentialStores(java.util.List<CredentialStore> value) {
		this.subresources.credentialStores = value;
		return (T) this;
	}

	/**
	 * Add the CredentialStore object to the list of subresources
	 * 
	 * @param value
	 *            The CredentialStore to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T credentialStore(CredentialStore value) {
		this.subresources.credentialStores.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a CredentialStore object to the list of subresources
	 * 
	 * @param key
	 *            The key for the CredentialStore resource
	 * @param config
	 *            The CredentialStoreConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T credentialStore(java.lang.String childKey,
			CredentialStoreConsumer consumer) {
		CredentialStore<? extends CredentialStore> child = new CredentialStore<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		credentialStore(child);
		return (T) this;
	}

	/**
	 * Create and configure a CredentialStore object to the list of subresources
	 * 
	 * @param key
	 *            The key for the CredentialStore resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T credentialStore(java.lang.String childKey) {
		credentialStore(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied CredentialStore object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T credentialStore(CredentialStoreSupplier supplier) {
		credentialStore(supplier.get());
		return (T) this;
	}

	/**
	 * Add all KerberosSecurityFactory objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of KerberosSecurityFactory objects.
	 */
	@SuppressWarnings("unchecked")
	public T kerberosSecurityFactories(
			java.util.List<KerberosSecurityFactory> value) {
		this.subresources.kerberosSecurityFactories = value;
		return (T) this;
	}

	/**
	 * Add the KerberosSecurityFactory object to the list of subresources
	 * 
	 * @param value
	 *            The KerberosSecurityFactory to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T kerberosSecurityFactory(KerberosSecurityFactory value) {
		this.subresources.kerberosSecurityFactories.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a KerberosSecurityFactory object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the KerberosSecurityFactory resource
	 * @param config
	 *            The KerberosSecurityFactoryConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T kerberosSecurityFactory(java.lang.String childKey,
			KerberosSecurityFactoryConsumer consumer) {
		KerberosSecurityFactory<? extends KerberosSecurityFactory> child = new KerberosSecurityFactory<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		kerberosSecurityFactory(child);
		return (T) this;
	}

	/**
	 * Create and configure a KerberosSecurityFactory object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the KerberosSecurityFactory resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T kerberosSecurityFactory(java.lang.String childKey) {
		kerberosSecurityFactory(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied KerberosSecurityFactory object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T kerberosSecurityFactory(KerberosSecurityFactorySupplier supplier) {
		kerberosSecurityFactory(supplier.get());
		return (T) this;
	}

	/**
	 * Add all ConfigurableHTTPServerMechanismFactory objects to this
	 * subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ConfigurableHTTPServerMechanismFactory objects.
	 */
	@SuppressWarnings("unchecked")
	public T configurableHttpServerMechanismFactories(
			java.util.List<ConfigurableHTTPServerMechanismFactory> value) {
		this.subresources.configurableHttpServerMechanismFactories = value;
		return (T) this;
	}

	/**
	 * Add the ConfigurableHTTPServerMechanismFactory object to the list of
	 * subresources
	 * 
	 * @param value
	 *            The ConfigurableHTTPServerMechanismFactory to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T configurableHttpServerMechanismFactory(
			ConfigurableHTTPServerMechanismFactory value) {
		this.subresources.configurableHttpServerMechanismFactories.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ConfigurableHTTPServerMechanismFactory object to
	 * the list of subresources
	 * 
	 * @param key
	 *            The key for the ConfigurableHTTPServerMechanismFactory
	 *            resource
	 * @param config
	 *            The ConfigurableHTTPServerMechanismFactoryConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T configurableHttpServerMechanismFactory(java.lang.String childKey,
			ConfigurableHTTPServerMechanismFactoryConsumer consumer) {
		ConfigurableHTTPServerMechanismFactory<? extends ConfigurableHTTPServerMechanismFactory> child = new ConfigurableHTTPServerMechanismFactory<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		configurableHttpServerMechanismFactory(child);
		return (T) this;
	}

	/**
	 * Create and configure a ConfigurableHTTPServerMechanismFactory object to
	 * the list of subresources
	 * 
	 * @param key
	 *            The key for the ConfigurableHTTPServerMechanismFactory
	 *            resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T configurableHttpServerMechanismFactory(java.lang.String childKey) {
		configurableHttpServerMechanismFactory(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ConfigurableHTTPServerMechanismFactory object to the
	 * list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T configurableHttpServerMechanismFactory(
			ConfigurableHTTPServerMechanismFactorySupplier supplier) {
		configurableHttpServerMechanismFactory(supplier.get());
		return (T) this;
	}

	/**
	 * Add all ProviderHTTPServerMechanismFactory objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ProviderHTTPServerMechanismFactory objects.
	 */
	@SuppressWarnings("unchecked")
	public T providerHttpServerMechanismFactories(
			java.util.List<ProviderHTTPServerMechanismFactory> value) {
		this.subresources.providerHttpServerMechanismFactories = value;
		return (T) this;
	}

	/**
	 * Add the ProviderHTTPServerMechanismFactory object to the list of
	 * subresources
	 * 
	 * @param value
	 *            The ProviderHTTPServerMechanismFactory to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T providerHttpServerMechanismFactory(
			ProviderHTTPServerMechanismFactory value) {
		this.subresources.providerHttpServerMechanismFactories.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ProviderHTTPServerMechanismFactory object to the
	 * list of subresources
	 * 
	 * @param key
	 *            The key for the ProviderHTTPServerMechanismFactory resource
	 * @param config
	 *            The ProviderHTTPServerMechanismFactoryConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T providerHttpServerMechanismFactory(java.lang.String childKey,
			ProviderHTTPServerMechanismFactoryConsumer consumer) {
		ProviderHTTPServerMechanismFactory<? extends ProviderHTTPServerMechanismFactory> child = new ProviderHTTPServerMechanismFactory<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		providerHttpServerMechanismFactory(child);
		return (T) this;
	}

	/**
	 * Create and configure a ProviderHTTPServerMechanismFactory object to the
	 * list of subresources
	 * 
	 * @param key
	 *            The key for the ProviderHTTPServerMechanismFactory resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T providerHttpServerMechanismFactory(java.lang.String childKey) {
		providerHttpServerMechanismFactory(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ProviderHTTPServerMechanismFactory object to the list
	 * of subresources
	 */
	@SuppressWarnings("unchecked")
	public T providerHttpServerMechanismFactory(
			ProviderHTTPServerMechanismFactorySupplier supplier) {
		providerHttpServerMechanismFactory(supplier.get());
		return (T) this;
	}

	/**
	 * Add all LogicalRoleMapper objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of LogicalRoleMapper objects.
	 */
	@SuppressWarnings("unchecked")
	public T logicalRoleMappers(java.util.List<LogicalRoleMapper> value) {
		this.subresources.logicalRoleMappers = value;
		return (T) this;
	}

	/**
	 * Add the LogicalRoleMapper object to the list of subresources
	 * 
	 * @param value
	 *            The LogicalRoleMapper to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T logicalRoleMapper(LogicalRoleMapper value) {
		this.subresources.logicalRoleMappers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a LogicalRoleMapper object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the LogicalRoleMapper resource
	 * @param config
	 *            The LogicalRoleMapperConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T logicalRoleMapper(java.lang.String childKey,
			LogicalRoleMapperConsumer consumer) {
		LogicalRoleMapper<? extends LogicalRoleMapper> child = new LogicalRoleMapper<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		logicalRoleMapper(child);
		return (T) this;
	}

	/**
	 * Create and configure a LogicalRoleMapper object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the LogicalRoleMapper resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T logicalRoleMapper(java.lang.String childKey) {
		logicalRoleMapper(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied LogicalRoleMapper object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T logicalRoleMapper(LogicalRoleMapperSupplier supplier) {
		logicalRoleMapper(supplier.get());
		return (T) this;
	}

	/**
	 * Add all AggregateRoleMapper objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of AggregateRoleMapper objects.
	 */
	@SuppressWarnings("unchecked")
	public T aggregateRoleMappers(java.util.List<AggregateRoleMapper> value) {
		this.subresources.aggregateRoleMappers = value;
		return (T) this;
	}

	/**
	 * Add the AggregateRoleMapper object to the list of subresources
	 * 
	 * @param value
	 *            The AggregateRoleMapper to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T aggregateRoleMapper(AggregateRoleMapper value) {
		this.subresources.aggregateRoleMappers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a AggregateRoleMapper object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the AggregateRoleMapper resource
	 * @param config
	 *            The AggregateRoleMapperConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T aggregateRoleMapper(java.lang.String childKey,
			AggregateRoleMapperConsumer consumer) {
		AggregateRoleMapper<? extends AggregateRoleMapper> child = new AggregateRoleMapper<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		aggregateRoleMapper(child);
		return (T) this;
	}

	/**
	 * Create and configure a AggregateRoleMapper object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the AggregateRoleMapper resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T aggregateRoleMapper(java.lang.String childKey) {
		aggregateRoleMapper(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied AggregateRoleMapper object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T aggregateRoleMapper(AggregateRoleMapperSupplier supplier) {
		aggregateRoleMapper(supplier.get());
		return (T) this;
	}

	/**
	 * Add all ProviderLoader objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ProviderLoader objects.
	 */
	@SuppressWarnings("unchecked")
	public T providerLoaders(java.util.List<ProviderLoader> value) {
		this.subresources.providerLoaders = value;
		return (T) this;
	}

	/**
	 * Add the ProviderLoader object to the list of subresources
	 * 
	 * @param value
	 *            The ProviderLoader to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T providerLoader(ProviderLoader value) {
		this.subresources.providerLoaders.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ProviderLoader object to the list of subresources
	 * 
	 * @param key
	 *            The key for the ProviderLoader resource
	 * @param config
	 *            The ProviderLoaderConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T providerLoader(java.lang.String childKey,
			ProviderLoaderConsumer consumer) {
		ProviderLoader<? extends ProviderLoader> child = new ProviderLoader<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		providerLoader(child);
		return (T) this;
	}

	/**
	 * Create and configure a ProviderLoader object to the list of subresources
	 * 
	 * @param key
	 *            The key for the ProviderLoader resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T providerLoader(java.lang.String childKey) {
		providerLoader(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ProviderLoader object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T providerLoader(ProviderLoaderSupplier supplier) {
		providerLoader(supplier.get());
		return (T) this;
	}

	/**
	 * Add all CustomPrincipalDecoder objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of CustomPrincipalDecoder objects.
	 */
	@SuppressWarnings("unchecked")
	public T customPrincipalDecoders(
			java.util.List<CustomPrincipalDecoder> value) {
		this.subresources.customPrincipalDecoders = value;
		return (T) this;
	}

	/**
	 * Add the CustomPrincipalDecoder object to the list of subresources
	 * 
	 * @param value
	 *            The CustomPrincipalDecoder to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T customPrincipalDecoder(CustomPrincipalDecoder value) {
		this.subresources.customPrincipalDecoders.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a CustomPrincipalDecoder object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the CustomPrincipalDecoder resource
	 * @param config
	 *            The CustomPrincipalDecoderConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T customPrincipalDecoder(java.lang.String childKey,
			CustomPrincipalDecoderConsumer consumer) {
		CustomPrincipalDecoder<? extends CustomPrincipalDecoder> child = new CustomPrincipalDecoder<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		customPrincipalDecoder(child);
		return (T) this;
	}

	/**
	 * Create and configure a CustomPrincipalDecoder object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the CustomPrincipalDecoder resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T customPrincipalDecoder(java.lang.String childKey) {
		customPrincipalDecoder(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied CustomPrincipalDecoder object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T customPrincipalDecoder(CustomPrincipalDecoderSupplier supplier) {
		customPrincipalDecoder(supplier.get());
		return (T) this;
	}

	/**
	 * Add all SizeRotatingFileAuditLog objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of SizeRotatingFileAuditLog objects.
	 */
	@SuppressWarnings("unchecked")
	public T sizeRotatingFileAuditLogs(
			java.util.List<SizeRotatingFileAuditLog> value) {
		this.subresources.sizeRotatingFileAuditLogs = value;
		return (T) this;
	}

	/**
	 * Add the SizeRotatingFileAuditLog object to the list of subresources
	 * 
	 * @param value
	 *            The SizeRotatingFileAuditLog to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T sizeRotatingFileAuditLog(SizeRotatingFileAuditLog value) {
		this.subresources.sizeRotatingFileAuditLogs.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a SizeRotatingFileAuditLog object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the SizeRotatingFileAuditLog resource
	 * @param config
	 *            The SizeRotatingFileAuditLogConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T sizeRotatingFileAuditLog(java.lang.String childKey,
			SizeRotatingFileAuditLogConsumer consumer) {
		SizeRotatingFileAuditLog<? extends SizeRotatingFileAuditLog> child = new SizeRotatingFileAuditLog<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		sizeRotatingFileAuditLog(child);
		return (T) this;
	}

	/**
	 * Create and configure a SizeRotatingFileAuditLog object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the SizeRotatingFileAuditLog resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T sizeRotatingFileAuditLog(java.lang.String childKey) {
		sizeRotatingFileAuditLog(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied SizeRotatingFileAuditLog object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T sizeRotatingFileAuditLog(SizeRotatingFileAuditLogSupplier supplier) {
		sizeRotatingFileAuditLog(supplier.get());
		return (T) this;
	}

	/**
	 * Add all ConstantPermissionMapper objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ConstantPermissionMapper objects.
	 */
	@SuppressWarnings("unchecked")
	public T constantPermissionMappers(
			java.util.List<ConstantPermissionMapper> value) {
		this.subresources.constantPermissionMappers = value;
		return (T) this;
	}

	/**
	 * Add the ConstantPermissionMapper object to the list of subresources
	 * 
	 * @param value
	 *            The ConstantPermissionMapper to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T constantPermissionMapper(ConstantPermissionMapper value) {
		this.subresources.constantPermissionMappers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ConstantPermissionMapper object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ConstantPermissionMapper resource
	 * @param config
	 *            The ConstantPermissionMapperConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T constantPermissionMapper(java.lang.String childKey,
			ConstantPermissionMapperConsumer consumer) {
		ConstantPermissionMapper<? extends ConstantPermissionMapper> child = new ConstantPermissionMapper<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		constantPermissionMapper(child);
		return (T) this;
	}

	/**
	 * Create and configure a ConstantPermissionMapper object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ConstantPermissionMapper resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T constantPermissionMapper(java.lang.String childKey) {
		constantPermissionMapper(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ConstantPermissionMapper object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T constantPermissionMapper(ConstantPermissionMapperSupplier supplier) {
		constantPermissionMapper(supplier.get());
		return (T) this;
	}

	/**
	 * Add all TokenRealm objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of TokenRealm objects.
	 */
	@SuppressWarnings("unchecked")
	public T tokenRealms(java.util.List<TokenRealm> value) {
		this.subresources.tokenRealms = value;
		return (T) this;
	}

	/**
	 * Add the TokenRealm object to the list of subresources
	 * 
	 * @param value
	 *            The TokenRealm to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T tokenRealm(TokenRealm value) {
		this.subresources.tokenRealms.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a TokenRealm object to the list of subresources
	 * 
	 * @param key
	 *            The key for the TokenRealm resource
	 * @param config
	 *            The TokenRealmConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T tokenRealm(java.lang.String childKey, TokenRealmConsumer consumer) {
		TokenRealm<? extends TokenRealm> child = new TokenRealm<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		tokenRealm(child);
		return (T) this;
	}

	/**
	 * Create and configure a TokenRealm object to the list of subresources
	 * 
	 * @param key
	 *            The key for the TokenRealm resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T tokenRealm(java.lang.String childKey) {
		tokenRealm(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied TokenRealm object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T tokenRealm(TokenRealmSupplier supplier) {
		tokenRealm(supplier.get());
		return (T) this;
	}

	/**
	 * Add all ClientSslContext objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ClientSslContext objects.
	 */
	@SuppressWarnings("unchecked")
	public T clientSslContexts(java.util.List<ClientSslContext> value) {
		this.subresources.clientSslContexts = value;
		return (T) this;
	}

	/**
	 * Add the ClientSslContext object to the list of subresources
	 * 
	 * @param value
	 *            The ClientSslContext to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T clientSslContext(ClientSslContext value) {
		this.subresources.clientSslContexts.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ClientSslContext object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ClientSslContext resource
	 * @param config
	 *            The ClientSslContextConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T clientSslContext(java.lang.String childKey,
			ClientSslContextConsumer consumer) {
		ClientSslContext<? extends ClientSslContext> child = new ClientSslContext<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		clientSslContext(child);
		return (T) this;
	}

	/**
	 * Create and configure a ClientSslContext object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ClientSslContext resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T clientSslContext(java.lang.String childKey) {
		clientSslContext(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ClientSslContext object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T clientSslContext(ClientSslContextSupplier supplier) {
		clientSslContext(supplier.get());
		return (T) this;
	}

	/**
	 * Add all SecurityDomain objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of SecurityDomain objects.
	 */
	@SuppressWarnings("unchecked")
	public T securityDomains(java.util.List<SecurityDomain> value) {
		this.subresources.securityDomains = value;
		return (T) this;
	}

	/**
	 * Add the SecurityDomain object to the list of subresources
	 * 
	 * @param value
	 *            The SecurityDomain to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T securityDomain(SecurityDomain value) {
		this.subresources.securityDomains.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a SecurityDomain object to the list of subresources
	 * 
	 * @param key
	 *            The key for the SecurityDomain resource
	 * @param config
	 *            The SecurityDomainConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T securityDomain(java.lang.String childKey,
			SecurityDomainConsumer consumer) {
		SecurityDomain<? extends SecurityDomain> child = new SecurityDomain<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		securityDomain(child);
		return (T) this;
	}

	/**
	 * Create and configure a SecurityDomain object to the list of subresources
	 * 
	 * @param key
	 *            The key for the SecurityDomain resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T securityDomain(java.lang.String childKey) {
		securityDomain(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied SecurityDomain object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T securityDomain(SecurityDomainSupplier supplier) {
		securityDomain(supplier.get());
		return (T) this;
	}

	/**
	 * Add all ConstantRoleMapper objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ConstantRoleMapper objects.
	 */
	@SuppressWarnings("unchecked")
	public T constantRoleMappers(java.util.List<ConstantRoleMapper> value) {
		this.subresources.constantRoleMappers = value;
		return (T) this;
	}

	/**
	 * Add the ConstantRoleMapper object to the list of subresources
	 * 
	 * @param value
	 *            The ConstantRoleMapper to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T constantRoleMapper(ConstantRoleMapper value) {
		this.subresources.constantRoleMappers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ConstantRoleMapper object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ConstantRoleMapper resource
	 * @param config
	 *            The ConstantRoleMapperConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T constantRoleMapper(java.lang.String childKey,
			ConstantRoleMapperConsumer consumer) {
		ConstantRoleMapper<? extends ConstantRoleMapper> child = new ConstantRoleMapper<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		constantRoleMapper(child);
		return (T) this;
	}

	/**
	 * Create and configure a ConstantRoleMapper object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ConstantRoleMapper resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T constantRoleMapper(java.lang.String childKey) {
		constantRoleMapper(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ConstantRoleMapper object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T constantRoleMapper(ConstantRoleMapperSupplier supplier) {
		constantRoleMapper(supplier.get());
		return (T) this;
	}

	/**
	 * Add all IdentityRealm objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of IdentityRealm objects.
	 */
	@SuppressWarnings("unchecked")
	public T identityRealms(java.util.List<IdentityRealm> value) {
		this.subresources.identityRealms = value;
		return (T) this;
	}

	/**
	 * Add the IdentityRealm object to the list of subresources
	 * 
	 * @param value
	 *            The IdentityRealm to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T identityRealm(IdentityRealm value) {
		this.subresources.identityRealms.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a IdentityRealm object to the list of subresources
	 * 
	 * @param key
	 *            The key for the IdentityRealm resource
	 * @param config
	 *            The IdentityRealmConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T identityRealm(java.lang.String childKey,
			IdentityRealmConsumer consumer) {
		IdentityRealm<? extends IdentityRealm> child = new IdentityRealm<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		identityRealm(child);
		return (T) this;
	}

	/**
	 * Create and configure a IdentityRealm object to the list of subresources
	 * 
	 * @param key
	 *            The key for the IdentityRealm resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T identityRealm(java.lang.String childKey) {
		identityRealm(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied IdentityRealm object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T identityRealm(IdentityRealmSupplier supplier) {
		identityRealm(supplier.get());
		return (T) this;
	}

	/**
	 * Add all FilteringKeyStore objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of FilteringKeyStore objects.
	 */
	@SuppressWarnings("unchecked")
	public T filteringKeyStores(java.util.List<FilteringKeyStore> value) {
		this.subresources.filteringKeyStores = value;
		return (T) this;
	}

	/**
	 * Add the FilteringKeyStore object to the list of subresources
	 * 
	 * @param value
	 *            The FilteringKeyStore to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T filteringKeyStore(FilteringKeyStore value) {
		this.subresources.filteringKeyStores.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a FilteringKeyStore object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the FilteringKeyStore resource
	 * @param config
	 *            The FilteringKeyStoreConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T filteringKeyStore(java.lang.String childKey,
			FilteringKeyStoreConsumer consumer) {
		FilteringKeyStore<? extends FilteringKeyStore> child = new FilteringKeyStore<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		filteringKeyStore(child);
		return (T) this;
	}

	/**
	 * Create and configure a FilteringKeyStore object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the FilteringKeyStore resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T filteringKeyStore(java.lang.String childKey) {
		filteringKeyStore(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied FilteringKeyStore object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T filteringKeyStore(FilteringKeyStoreSupplier supplier) {
		filteringKeyStore(supplier.get());
		return (T) this;
	}

	/**
	 * Add all PropertiesRealm objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of PropertiesRealm objects.
	 */
	@SuppressWarnings("unchecked")
	public T propertiesRealms(java.util.List<PropertiesRealm> value) {
		this.subresources.propertiesRealms = value;
		return (T) this;
	}

	/**
	 * Add the PropertiesRealm object to the list of subresources
	 * 
	 * @param value
	 *            The PropertiesRealm to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T propertiesRealm(PropertiesRealm value) {
		this.subresources.propertiesRealms.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a PropertiesRealm object to the list of subresources
	 * 
	 * @param key
	 *            The key for the PropertiesRealm resource
	 * @param config
	 *            The PropertiesRealmConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T propertiesRealm(java.lang.String childKey,
			PropertiesRealmConsumer consumer) {
		PropertiesRealm<? extends PropertiesRealm> child = new PropertiesRealm<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		propertiesRealm(child);
		return (T) this;
	}

	/**
	 * Create and configure a PropertiesRealm object to the list of subresources
	 * 
	 * @param key
	 *            The key for the PropertiesRealm resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T propertiesRealm(java.lang.String childKey) {
		propertiesRealm(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied PropertiesRealm object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T propertiesRealm(PropertiesRealmSupplier supplier) {
		propertiesRealm(supplier.get());
		return (T) this;
	}

	/**
	 * Add all AggregatePrincipalDecoder objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of AggregatePrincipalDecoder objects.
	 */
	@SuppressWarnings("unchecked")
	public T aggregatePrincipalDecoders(
			java.util.List<AggregatePrincipalDecoder> value) {
		this.subresources.aggregatePrincipalDecoders = value;
		return (T) this;
	}

	/**
	 * Add the AggregatePrincipalDecoder object to the list of subresources
	 * 
	 * @param value
	 *            The AggregatePrincipalDecoder to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T aggregatePrincipalDecoder(AggregatePrincipalDecoder value) {
		this.subresources.aggregatePrincipalDecoders.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a AggregatePrincipalDecoder object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the AggregatePrincipalDecoder resource
	 * @param config
	 *            The AggregatePrincipalDecoderConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T aggregatePrincipalDecoder(java.lang.String childKey,
			AggregatePrincipalDecoderConsumer consumer) {
		AggregatePrincipalDecoder<? extends AggregatePrincipalDecoder> child = new AggregatePrincipalDecoder<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		aggregatePrincipalDecoder(child);
		return (T) this;
	}

	/**
	 * Create and configure a AggregatePrincipalDecoder object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the AggregatePrincipalDecoder resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T aggregatePrincipalDecoder(java.lang.String childKey) {
		aggregatePrincipalDecoder(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied AggregatePrincipalDecoder object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T aggregatePrincipalDecoder(
			AggregatePrincipalDecoderSupplier supplier) {
		aggregatePrincipalDecoder(supplier.get());
		return (T) this;
	}

	/**
	 * Add all AggregatePrincipalTransformer objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of AggregatePrincipalTransformer objects.
	 */
	@SuppressWarnings("unchecked")
	public T aggregatePrincipalTransformers(
			java.util.List<AggregatePrincipalTransformer> value) {
		this.subresources.aggregatePrincipalTransformers = value;
		return (T) this;
	}

	/**
	 * Add the AggregatePrincipalTransformer object to the list of subresources
	 * 
	 * @param value
	 *            The AggregatePrincipalTransformer to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T aggregatePrincipalTransformer(AggregatePrincipalTransformer value) {
		this.subresources.aggregatePrincipalTransformers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a AggregatePrincipalTransformer object to the list
	 * of subresources
	 * 
	 * @param key
	 *            The key for the AggregatePrincipalTransformer resource
	 * @param config
	 *            The AggregatePrincipalTransformerConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T aggregatePrincipalTransformer(java.lang.String childKey,
			AggregatePrincipalTransformerConsumer consumer) {
		AggregatePrincipalTransformer<? extends AggregatePrincipalTransformer> child = new AggregatePrincipalTransformer<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		aggregatePrincipalTransformer(child);
		return (T) this;
	}

	/**
	 * Create and configure a AggregatePrincipalTransformer object to the list
	 * of subresources
	 * 
	 * @param key
	 *            The key for the AggregatePrincipalTransformer resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T aggregatePrincipalTransformer(java.lang.String childKey) {
		aggregatePrincipalTransformer(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied AggregatePrincipalTransformer object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T aggregatePrincipalTransformer(
			AggregatePrincipalTransformerSupplier supplier) {
		aggregatePrincipalTransformer(supplier.get());
		return (T) this;
	}

	/**
	 * Add all ServerSslSniContext objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ServerSslSniContext objects.
	 */
	@SuppressWarnings("unchecked")
	public T serverSslSniContexts(java.util.List<ServerSslSniContext> value) {
		this.subresources.serverSslSniContexts = value;
		return (T) this;
	}

	/**
	 * Add the ServerSslSniContext object to the list of subresources
	 * 
	 * @param value
	 *            The ServerSslSniContext to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T serverSslSniContext(ServerSslSniContext value) {
		this.subresources.serverSslSniContexts.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ServerSslSniContext object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ServerSslSniContext resource
	 * @param config
	 *            The ServerSslSniContextConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T serverSslSniContext(java.lang.String childKey,
			ServerSslSniContextConsumer consumer) {
		ServerSslSniContext<? extends ServerSslSniContext> child = new ServerSslSniContext<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		serverSslSniContext(child);
		return (T) this;
	}

	/**
	 * Create and configure a ServerSslSniContext object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ServerSslSniContext resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T serverSslSniContext(java.lang.String childKey) {
		serverSslSniContext(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ServerSslSniContext object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T serverSslSniContext(ServerSslSniContextSupplier supplier) {
		serverSslSniContext(supplier.get());
		return (T) this;
	}

	/**
	 * Add all CustomCredentialSecurityFactory objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of CustomCredentialSecurityFactory objects.
	 */
	@SuppressWarnings("unchecked")
	public T customCredentialSecurityFactories(
			java.util.List<CustomCredentialSecurityFactory> value) {
		this.subresources.customCredentialSecurityFactories = value;
		return (T) this;
	}

	/**
	 * Add the CustomCredentialSecurityFactory object to the list of
	 * subresources
	 * 
	 * @param value
	 *            The CustomCredentialSecurityFactory to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T customCredentialSecurityFactory(
			CustomCredentialSecurityFactory value) {
		this.subresources.customCredentialSecurityFactories.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a CustomCredentialSecurityFactory object to the list
	 * of subresources
	 * 
	 * @param key
	 *            The key for the CustomCredentialSecurityFactory resource
	 * @param config
	 *            The CustomCredentialSecurityFactoryConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T customCredentialSecurityFactory(java.lang.String childKey,
			CustomCredentialSecurityFactoryConsumer consumer) {
		CustomCredentialSecurityFactory<? extends CustomCredentialSecurityFactory> child = new CustomCredentialSecurityFactory<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		customCredentialSecurityFactory(child);
		return (T) this;
	}

	/**
	 * Create and configure a CustomCredentialSecurityFactory object to the list
	 * of subresources
	 * 
	 * @param key
	 *            The key for the CustomCredentialSecurityFactory resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T customCredentialSecurityFactory(java.lang.String childKey) {
		customCredentialSecurityFactory(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied CustomCredentialSecurityFactory object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T customCredentialSecurityFactory(
			CustomCredentialSecurityFactorySupplier supplier) {
		customCredentialSecurityFactory(supplier.get());
		return (T) this;
	}

	/**
	 * Add all PeriodicRotatingFileAuditLog objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of PeriodicRotatingFileAuditLog objects.
	 */
	@SuppressWarnings("unchecked")
	public T periodicRotatingFileAuditLogs(
			java.util.List<PeriodicRotatingFileAuditLog> value) {
		this.subresources.periodicRotatingFileAuditLogs = value;
		return (T) this;
	}

	/**
	 * Add the PeriodicRotatingFileAuditLog object to the list of subresources
	 * 
	 * @param value
	 *            The PeriodicRotatingFileAuditLog to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T periodicRotatingFileAuditLog(PeriodicRotatingFileAuditLog value) {
		this.subresources.periodicRotatingFileAuditLogs.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a PeriodicRotatingFileAuditLog object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the PeriodicRotatingFileAuditLog resource
	 * @param config
	 *            The PeriodicRotatingFileAuditLogConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T periodicRotatingFileAuditLog(java.lang.String childKey,
			PeriodicRotatingFileAuditLogConsumer consumer) {
		PeriodicRotatingFileAuditLog<? extends PeriodicRotatingFileAuditLog> child = new PeriodicRotatingFileAuditLog<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		periodicRotatingFileAuditLog(child);
		return (T) this;
	}

	/**
	 * Create and configure a PeriodicRotatingFileAuditLog object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the PeriodicRotatingFileAuditLog resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T periodicRotatingFileAuditLog(java.lang.String childKey) {
		periodicRotatingFileAuditLog(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied PeriodicRotatingFileAuditLog object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T periodicRotatingFileAuditLog(
			PeriodicRotatingFileAuditLogSupplier supplier) {
		periodicRotatingFileAuditLog(supplier.get());
		return (T) this;
	}

	/**
	 * Add all SimplePermissionMapper objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of SimplePermissionMapper objects.
	 */
	@SuppressWarnings("unchecked")
	public T simplePermissionMappers(
			java.util.List<SimplePermissionMapper> value) {
		this.subresources.simplePermissionMappers = value;
		return (T) this;
	}

	/**
	 * Add the SimplePermissionMapper object to the list of subresources
	 * 
	 * @param value
	 *            The SimplePermissionMapper to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T simplePermissionMapper(SimplePermissionMapper value) {
		this.subresources.simplePermissionMappers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a SimplePermissionMapper object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the SimplePermissionMapper resource
	 * @param config
	 *            The SimplePermissionMapperConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T simplePermissionMapper(java.lang.String childKey,
			SimplePermissionMapperConsumer consumer) {
		SimplePermissionMapper<? extends SimplePermissionMapper> child = new SimplePermissionMapper<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		simplePermissionMapper(child);
		return (T) this;
	}

	/**
	 * Create and configure a SimplePermissionMapper object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the SimplePermissionMapper resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T simplePermissionMapper(java.lang.String childKey) {
		simplePermissionMapper(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied SimplePermissionMapper object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T simplePermissionMapper(SimplePermissionMapperSupplier supplier) {
		simplePermissionMapper(supplier.get());
		return (T) this;
	}

	/**
	 * Add all MappedRoleMapper objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of MappedRoleMapper objects.
	 */
	@SuppressWarnings("unchecked")
	public T mappedRoleMappers(java.util.List<MappedRoleMapper> value) {
		this.subresources.mappedRoleMappers = value;
		return (T) this;
	}

	/**
	 * Add the MappedRoleMapper object to the list of subresources
	 * 
	 * @param value
	 *            The MappedRoleMapper to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T mappedRoleMapper(MappedRoleMapper value) {
		this.subresources.mappedRoleMappers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a MappedRoleMapper object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the MappedRoleMapper resource
	 * @param config
	 *            The MappedRoleMapperConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T mappedRoleMapper(java.lang.String childKey,
			MappedRoleMapperConsumer consumer) {
		MappedRoleMapper<? extends MappedRoleMapper> child = new MappedRoleMapper<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		mappedRoleMapper(child);
		return (T) this;
	}

	/**
	 * Create and configure a MappedRoleMapper object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the MappedRoleMapper resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T mappedRoleMapper(java.lang.String childKey) {
		mappedRoleMapper(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied MappedRoleMapper object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T mappedRoleMapper(MappedRoleMapperSupplier supplier) {
		mappedRoleMapper(supplier.get());
		return (T) this;
	}

	/**
	 * Add all ConstantRealmMapper objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ConstantRealmMapper objects.
	 */
	@SuppressWarnings("unchecked")
	public T constantRealmMappers(java.util.List<ConstantRealmMapper> value) {
		this.subresources.constantRealmMappers = value;
		return (T) this;
	}

	/**
	 * Add the ConstantRealmMapper object to the list of subresources
	 * 
	 * @param value
	 *            The ConstantRealmMapper to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T constantRealmMapper(ConstantRealmMapper value) {
		this.subresources.constantRealmMappers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ConstantRealmMapper object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ConstantRealmMapper resource
	 * @param config
	 *            The ConstantRealmMapperConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T constantRealmMapper(java.lang.String childKey,
			ConstantRealmMapperConsumer consumer) {
		ConstantRealmMapper<? extends ConstantRealmMapper> child = new ConstantRealmMapper<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		constantRealmMapper(child);
		return (T) this;
	}

	/**
	 * Create and configure a ConstantRealmMapper object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ConstantRealmMapper resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T constantRealmMapper(java.lang.String childKey) {
		constantRealmMapper(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ConstantRealmMapper object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T constantRealmMapper(ConstantRealmMapperSupplier supplier) {
		constantRealmMapper(supplier.get());
		return (T) this;
	}

	/**
	 * Add all SimpleRoleDecoder objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of SimpleRoleDecoder objects.
	 */
	@SuppressWarnings("unchecked")
	public T simpleRoleDecoders(java.util.List<SimpleRoleDecoder> value) {
		this.subresources.simpleRoleDecoders = value;
		return (T) this;
	}

	/**
	 * Add the SimpleRoleDecoder object to the list of subresources
	 * 
	 * @param value
	 *            The SimpleRoleDecoder to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T simpleRoleDecoder(SimpleRoleDecoder value) {
		this.subresources.simpleRoleDecoders.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a SimpleRoleDecoder object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the SimpleRoleDecoder resource
	 * @param config
	 *            The SimpleRoleDecoderConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T simpleRoleDecoder(java.lang.String childKey,
			SimpleRoleDecoderConsumer consumer) {
		SimpleRoleDecoder<? extends SimpleRoleDecoder> child = new SimpleRoleDecoder<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		simpleRoleDecoder(child);
		return (T) this;
	}

	/**
	 * Create and configure a SimpleRoleDecoder object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the SimpleRoleDecoder resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T simpleRoleDecoder(java.lang.String childKey) {
		simpleRoleDecoder(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied SimpleRoleDecoder object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T simpleRoleDecoder(SimpleRoleDecoderSupplier supplier) {
		simpleRoleDecoder(supplier.get());
		return (T) this;
	}

	/**
	 * Add all ConfigurableSASLServerFactory objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ConfigurableSASLServerFactory objects.
	 */
	@SuppressWarnings("unchecked")
	public T configurableSaslServerFactories(
			java.util.List<ConfigurableSASLServerFactory> value) {
		this.subresources.configurableSaslServerFactories = value;
		return (T) this;
	}

	/**
	 * Add the ConfigurableSASLServerFactory object to the list of subresources
	 * 
	 * @param value
	 *            The ConfigurableSASLServerFactory to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T configurableSaslServerFactory(ConfigurableSASLServerFactory value) {
		this.subresources.configurableSaslServerFactories.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ConfigurableSASLServerFactory object to the list
	 * of subresources
	 * 
	 * @param key
	 *            The key for the ConfigurableSASLServerFactory resource
	 * @param config
	 *            The ConfigurableSASLServerFactoryConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T configurableSaslServerFactory(java.lang.String childKey,
			ConfigurableSASLServerFactoryConsumer consumer) {
		ConfigurableSASLServerFactory<? extends ConfigurableSASLServerFactory> child = new ConfigurableSASLServerFactory<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		configurableSaslServerFactory(child);
		return (T) this;
	}

	/**
	 * Create and configure a ConfigurableSASLServerFactory object to the list
	 * of subresources
	 * 
	 * @param key
	 *            The key for the ConfigurableSASLServerFactory resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T configurableSaslServerFactory(java.lang.String childKey) {
		configurableSaslServerFactory(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ConfigurableSASLServerFactory object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T configurableSaslServerFactory(
			ConfigurableSASLServerFactorySupplier supplier) {
		configurableSaslServerFactory(supplier.get());
		return (T) this;
	}

	/**
	 * Add all RegexValidatingPrincipalTransformer objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of RegexValidatingPrincipalTransformer objects.
	 */
	@SuppressWarnings("unchecked")
	public T regexValidatingPrincipalTransformers(
			java.util.List<RegexValidatingPrincipalTransformer> value) {
		this.subresources.regexValidatingPrincipalTransformers = value;
		return (T) this;
	}

	/**
	 * Add the RegexValidatingPrincipalTransformer object to the list of
	 * subresources
	 * 
	 * @param value
	 *            The RegexValidatingPrincipalTransformer to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T regexValidatingPrincipalTransformer(
			RegexValidatingPrincipalTransformer value) {
		this.subresources.regexValidatingPrincipalTransformers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a RegexValidatingPrincipalTransformer object to the
	 * list of subresources
	 * 
	 * @param key
	 *            The key for the RegexValidatingPrincipalTransformer resource
	 * @param config
	 *            The RegexValidatingPrincipalTransformerConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T regexValidatingPrincipalTransformer(java.lang.String childKey,
			RegexValidatingPrincipalTransformerConsumer consumer) {
		RegexValidatingPrincipalTransformer<? extends RegexValidatingPrincipalTransformer> child = new RegexValidatingPrincipalTransformer<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		regexValidatingPrincipalTransformer(child);
		return (T) this;
	}

	/**
	 * Create and configure a RegexValidatingPrincipalTransformer object to the
	 * list of subresources
	 * 
	 * @param key
	 *            The key for the RegexValidatingPrincipalTransformer resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T regexValidatingPrincipalTransformer(java.lang.String childKey) {
		regexValidatingPrincipalTransformer(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied RegexValidatingPrincipalTransformer object to the list
	 * of subresources
	 */
	@SuppressWarnings("unchecked")
	public T regexValidatingPrincipalTransformer(
			RegexValidatingPrincipalTransformerSupplier supplier) {
		regexValidatingPrincipalTransformer(supplier.get());
		return (T) this;
	}

	/**
	 * Add all ServiceLoaderSASLServerFactory objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ServiceLoaderSASLServerFactory objects.
	 */
	@SuppressWarnings("unchecked")
	public T serviceLoaderSaslServerFactories(
			java.util.List<ServiceLoaderSASLServerFactory> value) {
		this.subresources.serviceLoaderSaslServerFactories = value;
		return (T) this;
	}

	/**
	 * Add the ServiceLoaderSASLServerFactory object to the list of subresources
	 * 
	 * @param value
	 *            The ServiceLoaderSASLServerFactory to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T serviceLoaderSaslServerFactory(ServiceLoaderSASLServerFactory value) {
		this.subresources.serviceLoaderSaslServerFactories.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ServiceLoaderSASLServerFactory object to the list
	 * of subresources
	 * 
	 * @param key
	 *            The key for the ServiceLoaderSASLServerFactory resource
	 * @param config
	 *            The ServiceLoaderSASLServerFactoryConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T serviceLoaderSaslServerFactory(java.lang.String childKey,
			ServiceLoaderSASLServerFactoryConsumer consumer) {
		ServiceLoaderSASLServerFactory<? extends ServiceLoaderSASLServerFactory> child = new ServiceLoaderSASLServerFactory<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		serviceLoaderSaslServerFactory(child);
		return (T) this;
	}

	/**
	 * Create and configure a ServiceLoaderSASLServerFactory object to the list
	 * of subresources
	 * 
	 * @param key
	 *            The key for the ServiceLoaderSASLServerFactory resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T serviceLoaderSaslServerFactory(java.lang.String childKey) {
		serviceLoaderSaslServerFactory(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ServiceLoaderSASLServerFactory object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T serviceLoaderSaslServerFactory(
			ServiceLoaderSASLServerFactorySupplier supplier) {
		serviceLoaderSaslServerFactory(supplier.get());
		return (T) this;
	}

	/**
	 * Add all PermissionSet objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of PermissionSet objects.
	 */
	@SuppressWarnings("unchecked")
	public T permissionSets(java.util.List<PermissionSet> value) {
		this.subresources.permissionSets = value;
		return (T) this;
	}

	/**
	 * Add the PermissionSet object to the list of subresources
	 * 
	 * @param value
	 *            The PermissionSet to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T permissionSet(PermissionSet value) {
		this.subresources.permissionSets.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a PermissionSet object to the list of subresources
	 * 
	 * @param key
	 *            The key for the PermissionSet resource
	 * @param config
	 *            The PermissionSetConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T permissionSet(java.lang.String childKey,
			PermissionSetConsumer consumer) {
		PermissionSet<? extends PermissionSet> child = new PermissionSet<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		permissionSet(child);
		return (T) this;
	}

	/**
	 * Create and configure a PermissionSet object to the list of subresources
	 * 
	 * @param key
	 *            The key for the PermissionSet resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T permissionSet(java.lang.String childKey) {
		permissionSet(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied PermissionSet object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T permissionSet(PermissionSetSupplier supplier) {
		permissionSet(supplier.get());
		return (T) this;
	}

	/**
	 * Add all LdapKeyStore objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of LdapKeyStore objects.
	 */
	@SuppressWarnings("unchecked")
	public T ldapKeyStores(java.util.List<LdapKeyStore> value) {
		this.subresources.ldapKeyStores = value;
		return (T) this;
	}

	/**
	 * Add the LdapKeyStore object to the list of subresources
	 * 
	 * @param value
	 *            The LdapKeyStore to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T ldapKeyStore(LdapKeyStore value) {
		this.subresources.ldapKeyStores.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a LdapKeyStore object to the list of subresources
	 * 
	 * @param key
	 *            The key for the LdapKeyStore resource
	 * @param config
	 *            The LdapKeyStoreConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T ldapKeyStore(java.lang.String childKey,
			LdapKeyStoreConsumer consumer) {
		LdapKeyStore<? extends LdapKeyStore> child = new LdapKeyStore<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		ldapKeyStore(child);
		return (T) this;
	}

	/**
	 * Create and configure a LdapKeyStore object to the list of subresources
	 * 
	 * @param key
	 *            The key for the LdapKeyStore resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T ldapKeyStore(java.lang.String childKey) {
		ldapKeyStore(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied LdapKeyStore object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T ldapKeyStore(LdapKeyStoreSupplier supplier) {
		ldapKeyStore(supplier.get());
		return (T) this;
	}

	/**
	 * Add all X500AttributePrincipalDecoder objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of X500AttributePrincipalDecoder objects.
	 */
	@SuppressWarnings("unchecked")
	public T x500AttributePrincipalDecoders(
			java.util.List<X500AttributePrincipalDecoder> value) {
		this.subresources.x500AttributePrincipalDecoders = value;
		return (T) this;
	}

	/**
	 * Add the X500AttributePrincipalDecoder object to the list of subresources
	 * 
	 * @param value
	 *            The X500AttributePrincipalDecoder to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T x500AttributePrincipalDecoder(X500AttributePrincipalDecoder value) {
		this.subresources.x500AttributePrincipalDecoders.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a X500AttributePrincipalDecoder object to the list
	 * of subresources
	 * 
	 * @param key
	 *            The key for the X500AttributePrincipalDecoder resource
	 * @param config
	 *            The X500AttributePrincipalDecoderConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T x500AttributePrincipalDecoder(java.lang.String childKey,
			X500AttributePrincipalDecoderConsumer consumer) {
		X500AttributePrincipalDecoder<? extends X500AttributePrincipalDecoder> child = new X500AttributePrincipalDecoder<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		x500AttributePrincipalDecoder(child);
		return (T) this;
	}

	/**
	 * Create and configure a X500AttributePrincipalDecoder object to the list
	 * of subresources
	 * 
	 * @param key
	 *            The key for the X500AttributePrincipalDecoder resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T x500AttributePrincipalDecoder(java.lang.String childKey) {
		x500AttributePrincipalDecoder(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied X500AttributePrincipalDecoder object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T x500AttributePrincipalDecoder(
			X500AttributePrincipalDecoderSupplier supplier) {
		x500AttributePrincipalDecoder(supplier.get());
		return (T) this;
	}

	/**
	 * Add all DirContext objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of DirContext objects.
	 */
	@SuppressWarnings("unchecked")
	public T dirContexts(java.util.List<DirContext> value) {
		this.subresources.dirContexts = value;
		return (T) this;
	}

	/**
	 * Add the DirContext object to the list of subresources
	 * 
	 * @param value
	 *            The DirContext to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T dirContext(DirContext value) {
		this.subresources.dirContexts.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a DirContext object to the list of subresources
	 * 
	 * @param key
	 *            The key for the DirContext resource
	 * @param config
	 *            The DirContextConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T dirContext(java.lang.String childKey, DirContextConsumer consumer) {
		DirContext<? extends DirContext> child = new DirContext<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		dirContext(child);
		return (T) this;
	}

	/**
	 * Create and configure a DirContext object to the list of subresources
	 * 
	 * @param key
	 *            The key for the DirContext resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T dirContext(java.lang.String childKey) {
		dirContext(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied DirContext object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T dirContext(DirContextSupplier supplier) {
		dirContext(supplier.get());
		return (T) this;
	}

	/**
	 * Add all MappedRegexRealmMapper objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of MappedRegexRealmMapper objects.
	 */
	@SuppressWarnings("unchecked")
	public T mappedRegexRealmMappers(
			java.util.List<MappedRegexRealmMapper> value) {
		this.subresources.mappedRegexRealmMappers = value;
		return (T) this;
	}

	/**
	 * Add the MappedRegexRealmMapper object to the list of subresources
	 * 
	 * @param value
	 *            The MappedRegexRealmMapper to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T mappedRegexRealmMapper(MappedRegexRealmMapper value) {
		this.subresources.mappedRegexRealmMappers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a MappedRegexRealmMapper object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the MappedRegexRealmMapper resource
	 * @param config
	 *            The MappedRegexRealmMapperConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T mappedRegexRealmMapper(java.lang.String childKey,
			MappedRegexRealmMapperConsumer consumer) {
		MappedRegexRealmMapper<? extends MappedRegexRealmMapper> child = new MappedRegexRealmMapper<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		mappedRegexRealmMapper(child);
		return (T) this;
	}

	/**
	 * Create and configure a MappedRegexRealmMapper object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the MappedRegexRealmMapper resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T mappedRegexRealmMapper(java.lang.String childKey) {
		mappedRegexRealmMapper(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied MappedRegexRealmMapper object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T mappedRegexRealmMapper(MappedRegexRealmMapperSupplier supplier) {
		mappedRegexRealmMapper(supplier.get());
		return (T) this;
	}

	/**
	 * Add all SyslogAuditLog objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of SyslogAuditLog objects.
	 */
	@SuppressWarnings("unchecked")
	public T syslogAuditLogs(java.util.List<SyslogAuditLog> value) {
		this.subresources.syslogAuditLogs = value;
		return (T) this;
	}

	/**
	 * Add the SyslogAuditLog object to the list of subresources
	 * 
	 * @param value
	 *            The SyslogAuditLog to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T syslogAuditLog(SyslogAuditLog value) {
		this.subresources.syslogAuditLogs.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a SyslogAuditLog object to the list of subresources
	 * 
	 * @param key
	 *            The key for the SyslogAuditLog resource
	 * @param config
	 *            The SyslogAuditLogConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T syslogAuditLog(java.lang.String childKey,
			SyslogAuditLogConsumer consumer) {
		SyslogAuditLog<? extends SyslogAuditLog> child = new SyslogAuditLog<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		syslogAuditLog(child);
		return (T) this;
	}

	/**
	 * Create and configure a SyslogAuditLog object to the list of subresources
	 * 
	 * @param key
	 *            The key for the SyslogAuditLog resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T syslogAuditLog(java.lang.String childKey) {
		syslogAuditLog(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied SyslogAuditLog object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T syslogAuditLog(SyslogAuditLogSupplier supplier) {
		syslogAuditLog(supplier.get());
		return (T) this;
	}

	/**
	 * Add all AggregateSecurityEventListener objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of AggregateSecurityEventListener objects.
	 */
	@SuppressWarnings("unchecked")
	public T aggregateSecurityEventListeners(
			java.util.List<AggregateSecurityEventListener> value) {
		this.subresources.aggregateSecurityEventListeners = value;
		return (T) this;
	}

	/**
	 * Add the AggregateSecurityEventListener object to the list of subresources
	 * 
	 * @param value
	 *            The AggregateSecurityEventListener to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T aggregateSecurityEventListener(AggregateSecurityEventListener value) {
		this.subresources.aggregateSecurityEventListeners.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a AggregateSecurityEventListener object to the list
	 * of subresources
	 * 
	 * @param key
	 *            The key for the AggregateSecurityEventListener resource
	 * @param config
	 *            The AggregateSecurityEventListenerConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T aggregateSecurityEventListener(java.lang.String childKey,
			AggregateSecurityEventListenerConsumer consumer) {
		AggregateSecurityEventListener<? extends AggregateSecurityEventListener> child = new AggregateSecurityEventListener<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		aggregateSecurityEventListener(child);
		return (T) this;
	}

	/**
	 * Create and configure a AggregateSecurityEventListener object to the list
	 * of subresources
	 * 
	 * @param key
	 *            The key for the AggregateSecurityEventListener resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T aggregateSecurityEventListener(java.lang.String childKey) {
		aggregateSecurityEventListener(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied AggregateSecurityEventListener object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T aggregateSecurityEventListener(
			AggregateSecurityEventListenerSupplier supplier) {
		aggregateSecurityEventListener(supplier.get());
		return (T) this;
	}

	/**
	 * Add all ChainedPrincipalTransformer objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ChainedPrincipalTransformer objects.
	 */
	@SuppressWarnings("unchecked")
	public T chainedPrincipalTransformers(
			java.util.List<ChainedPrincipalTransformer> value) {
		this.subresources.chainedPrincipalTransformers = value;
		return (T) this;
	}

	/**
	 * Add the ChainedPrincipalTransformer object to the list of subresources
	 * 
	 * @param value
	 *            The ChainedPrincipalTransformer to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T chainedPrincipalTransformer(ChainedPrincipalTransformer value) {
		this.subresources.chainedPrincipalTransformers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ChainedPrincipalTransformer object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ChainedPrincipalTransformer resource
	 * @param config
	 *            The ChainedPrincipalTransformerConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T chainedPrincipalTransformer(java.lang.String childKey,
			ChainedPrincipalTransformerConsumer consumer) {
		ChainedPrincipalTransformer<? extends ChainedPrincipalTransformer> child = new ChainedPrincipalTransformer<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		chainedPrincipalTransformer(child);
		return (T) this;
	}

	/**
	 * Create and configure a ChainedPrincipalTransformer object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ChainedPrincipalTransformer resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T chainedPrincipalTransformer(java.lang.String childKey) {
		chainedPrincipalTransformer(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ChainedPrincipalTransformer object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T chainedPrincipalTransformer(
			ChainedPrincipalTransformerSupplier supplier) {
		chainedPrincipalTransformer(supplier.get());
		return (T) this;
	}

	/**
	 * Add all AuthenticationContext objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of AuthenticationContext objects.
	 */
	@SuppressWarnings("unchecked")
	public T authenticationContexts(java.util.List<AuthenticationContext> value) {
		this.subresources.authenticationContexts = value;
		return (T) this;
	}

	/**
	 * Add the AuthenticationContext object to the list of subresources
	 * 
	 * @param value
	 *            The AuthenticationContext to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T authenticationContext(AuthenticationContext value) {
		this.subresources.authenticationContexts.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a AuthenticationContext object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the AuthenticationContext resource
	 * @param config
	 *            The AuthenticationContextConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T authenticationContext(java.lang.String childKey,
			AuthenticationContextConsumer consumer) {
		AuthenticationContext<? extends AuthenticationContext> child = new AuthenticationContext<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		authenticationContext(child);
		return (T) this;
	}

	/**
	 * Create and configure a AuthenticationContext object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the AuthenticationContext resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T authenticationContext(java.lang.String childKey) {
		authenticationContext(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied AuthenticationContext object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T authenticationContext(AuthenticationContextSupplier supplier) {
		authenticationContext(supplier.get());
		return (T) this;
	}

	/**
	 * Add all FileAuditLog objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of FileAuditLog objects.
	 */
	@SuppressWarnings("unchecked")
	public T fileAuditLogs(java.util.List<FileAuditLog> value) {
		this.subresources.fileAuditLogs = value;
		return (T) this;
	}

	/**
	 * Add the FileAuditLog object to the list of subresources
	 * 
	 * @param value
	 *            The FileAuditLog to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T fileAuditLog(FileAuditLog value) {
		this.subresources.fileAuditLogs.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a FileAuditLog object to the list of subresources
	 * 
	 * @param key
	 *            The key for the FileAuditLog resource
	 * @param config
	 *            The FileAuditLogConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T fileAuditLog(java.lang.String childKey,
			FileAuditLogConsumer consumer) {
		FileAuditLog<? extends FileAuditLog> child = new FileAuditLog<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		fileAuditLog(child);
		return (T) this;
	}

	/**
	 * Create and configure a FileAuditLog object to the list of subresources
	 * 
	 * @param key
	 *            The key for the FileAuditLog resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T fileAuditLog(java.lang.String childKey) {
		fileAuditLog(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied FileAuditLog object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T fileAuditLog(FileAuditLogSupplier supplier) {
		fileAuditLog(supplier.get());
		return (T) this;
	}

	/**
	 * Add all KeyStoreRealm objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of KeyStoreRealm objects.
	 */
	@SuppressWarnings("unchecked")
	public T keyStoreRealms(java.util.List<KeyStoreRealm> value) {
		this.subresources.keyStoreRealms = value;
		return (T) this;
	}

	/**
	 * Add the KeyStoreRealm object to the list of subresources
	 * 
	 * @param value
	 *            The KeyStoreRealm to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T keyStoreRealm(KeyStoreRealm value) {
		this.subresources.keyStoreRealms.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a KeyStoreRealm object to the list of subresources
	 * 
	 * @param key
	 *            The key for the KeyStoreRealm resource
	 * @param config
	 *            The KeyStoreRealmConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T keyStoreRealm(java.lang.String childKey,
			KeyStoreRealmConsumer consumer) {
		KeyStoreRealm<? extends KeyStoreRealm> child = new KeyStoreRealm<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		keyStoreRealm(child);
		return (T) this;
	}

	/**
	 * Create and configure a KeyStoreRealm object to the list of subresources
	 * 
	 * @param key
	 *            The key for the KeyStoreRealm resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T keyStoreRealm(java.lang.String childKey) {
		keyStoreRealm(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied KeyStoreRealm object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T keyStoreRealm(KeyStoreRealmSupplier supplier) {
		keyStoreRealm(supplier.get());
		return (T) this;
	}

	/**
	 * Add all Policy objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of Policy objects.
	 */
	@SuppressWarnings("unchecked")
	public T policies(java.util.List<Policy> value) {
		this.subresources.policies = value;
		return (T) this;
	}

	/**
	 * Add the Policy object to the list of subresources
	 * 
	 * @param value
	 *            The Policy to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T policy(Policy value) {
		this.subresources.policies.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a Policy object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Policy resource
	 * @param config
	 *            The PolicyConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T policy(java.lang.String childKey, PolicyConsumer consumer) {
		Policy<? extends Policy> child = new Policy<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		policy(child);
		return (T) this;
	}

	/**
	 * Create and configure a Policy object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Policy resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T policy(java.lang.String childKey) {
		policy(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied Policy object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T policy(PolicySupplier supplier) {
		policy(supplier.get());
		return (T) this;
	}

	/**
	 * Add all AuthenticationConfiguration objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of AuthenticationConfiguration objects.
	 */
	@SuppressWarnings("unchecked")
	public T authenticationConfigurations(
			java.util.List<AuthenticationConfiguration> value) {
		this.subresources.authenticationConfigurations = value;
		return (T) this;
	}

	/**
	 * Add the AuthenticationConfiguration object to the list of subresources
	 * 
	 * @param value
	 *            The AuthenticationConfiguration to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T authenticationConfiguration(AuthenticationConfiguration value) {
		this.subresources.authenticationConfigurations.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a AuthenticationConfiguration object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the AuthenticationConfiguration resource
	 * @param config
	 *            The AuthenticationConfigurationConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T authenticationConfiguration(java.lang.String childKey,
			AuthenticationConfigurationConsumer consumer) {
		AuthenticationConfiguration<? extends AuthenticationConfiguration> child = new AuthenticationConfiguration<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		authenticationConfiguration(child);
		return (T) this;
	}

	/**
	 * Create and configure a AuthenticationConfiguration object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the AuthenticationConfiguration resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T authenticationConfiguration(java.lang.String childKey) {
		authenticationConfiguration(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied AuthenticationConfiguration object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T authenticationConfiguration(
			AuthenticationConfigurationSupplier supplier) {
		authenticationConfiguration(supplier.get());
		return (T) this;
	}

	/**
	 * Add all ProviderSASLServerFactory objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ProviderSASLServerFactory objects.
	 */
	@SuppressWarnings("unchecked")
	public T providerSaslServerFactories(
			java.util.List<ProviderSASLServerFactory> value) {
		this.subresources.providerSaslServerFactories = value;
		return (T) this;
	}

	/**
	 * Add the ProviderSASLServerFactory object to the list of subresources
	 * 
	 * @param value
	 *            The ProviderSASLServerFactory to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T providerSaslServerFactory(ProviderSASLServerFactory value) {
		this.subresources.providerSaslServerFactories.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ProviderSASLServerFactory object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ProviderSASLServerFactory resource
	 * @param config
	 *            The ProviderSASLServerFactoryConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T providerSaslServerFactory(java.lang.String childKey,
			ProviderSASLServerFactoryConsumer consumer) {
		ProviderSASLServerFactory<? extends ProviderSASLServerFactory> child = new ProviderSASLServerFactory<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		providerSaslServerFactory(child);
		return (T) this;
	}

	/**
	 * Create and configure a ProviderSASLServerFactory object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ProviderSASLServerFactory resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T providerSaslServerFactory(java.lang.String childKey) {
		providerSaslServerFactory(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ProviderSASLServerFactory object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T providerSaslServerFactory(
			ProviderSASLServerFactorySupplier supplier) {
		providerSaslServerFactory(supplier.get());
		return (T) this;
	}

	/**
	 * Add all CustomModifiableRealm objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of CustomModifiableRealm objects.
	 */
	@SuppressWarnings("unchecked")
	public T customModifiableRealms(java.util.List<CustomModifiableRealm> value) {
		this.subresources.customModifiableRealms = value;
		return (T) this;
	}

	/**
	 * Add the CustomModifiableRealm object to the list of subresources
	 * 
	 * @param value
	 *            The CustomModifiableRealm to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T customModifiableRealm(CustomModifiableRealm value) {
		this.subresources.customModifiableRealms.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a CustomModifiableRealm object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the CustomModifiableRealm resource
	 * @param config
	 *            The CustomModifiableRealmConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T customModifiableRealm(java.lang.String childKey,
			CustomModifiableRealmConsumer consumer) {
		CustomModifiableRealm<? extends CustomModifiableRealm> child = new CustomModifiableRealm<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		customModifiableRealm(child);
		return (T) this;
	}

	/**
	 * Create and configure a CustomModifiableRealm object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the CustomModifiableRealm resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T customModifiableRealm(java.lang.String childKey) {
		customModifiableRealm(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied CustomModifiableRealm object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T customModifiableRealm(CustomModifiableRealmSupplier supplier) {
		customModifiableRealm(supplier.get());
		return (T) this;
	}

	/**
	 * Add all AddPrefixRoleMapper objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of AddPrefixRoleMapper objects.
	 */
	@SuppressWarnings("unchecked")
	public T addPrefixRoleMappers(java.util.List<AddPrefixRoleMapper> value) {
		this.subresources.addPrefixRoleMappers = value;
		return (T) this;
	}

	/**
	 * Add the AddPrefixRoleMapper object to the list of subresources
	 * 
	 * @param value
	 *            The AddPrefixRoleMapper to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T addPrefixRoleMapper(AddPrefixRoleMapper value) {
		this.subresources.addPrefixRoleMappers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a AddPrefixRoleMapper object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the AddPrefixRoleMapper resource
	 * @param config
	 *            The AddPrefixRoleMapperConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T addPrefixRoleMapper(java.lang.String childKey,
			AddPrefixRoleMapperConsumer consumer) {
		AddPrefixRoleMapper<? extends AddPrefixRoleMapper> child = new AddPrefixRoleMapper<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		addPrefixRoleMapper(child);
		return (T) this;
	}

	/**
	 * Create and configure a AddPrefixRoleMapper object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the AddPrefixRoleMapper resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T addPrefixRoleMapper(java.lang.String childKey) {
		addPrefixRoleMapper(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied AddPrefixRoleMapper object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T addPrefixRoleMapper(AddPrefixRoleMapperSupplier supplier) {
		addPrefixRoleMapper(supplier.get());
		return (T) this;
	}

	/**
	 * Add all AggregateHTTPServerMechanismFactory objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of AggregateHTTPServerMechanismFactory objects.
	 */
	@SuppressWarnings("unchecked")
	public T aggregateHttpServerMechanismFactories(
			java.util.List<AggregateHTTPServerMechanismFactory> value) {
		this.subresources.aggregateHttpServerMechanismFactories = value;
		return (T) this;
	}

	/**
	 * Add the AggregateHTTPServerMechanismFactory object to the list of
	 * subresources
	 * 
	 * @param value
	 *            The AggregateHTTPServerMechanismFactory to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T aggregateHttpServerMechanismFactory(
			AggregateHTTPServerMechanismFactory value) {
		this.subresources.aggregateHttpServerMechanismFactories.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a AggregateHTTPServerMechanismFactory object to the
	 * list of subresources
	 * 
	 * @param key
	 *            The key for the AggregateHTTPServerMechanismFactory resource
	 * @param config
	 *            The AggregateHTTPServerMechanismFactoryConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T aggregateHttpServerMechanismFactory(java.lang.String childKey,
			AggregateHTTPServerMechanismFactoryConsumer consumer) {
		AggregateHTTPServerMechanismFactory<? extends AggregateHTTPServerMechanismFactory> child = new AggregateHTTPServerMechanismFactory<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		aggregateHttpServerMechanismFactory(child);
		return (T) this;
	}

	/**
	 * Create and configure a AggregateHTTPServerMechanismFactory object to the
	 * list of subresources
	 * 
	 * @param key
	 *            The key for the AggregateHTTPServerMechanismFactory resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T aggregateHttpServerMechanismFactory(java.lang.String childKey) {
		aggregateHttpServerMechanismFactory(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied AggregateHTTPServerMechanismFactory object to the list
	 * of subresources
	 */
	@SuppressWarnings("unchecked")
	public T aggregateHttpServerMechanismFactory(
			AggregateHTTPServerMechanismFactorySupplier supplier) {
		aggregateHttpServerMechanismFactory(supplier.get());
		return (T) this;
	}

	/**
	 * Add all CustomRealmMapper objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of CustomRealmMapper objects.
	 */
	@SuppressWarnings("unchecked")
	public T customRealmMappers(java.util.List<CustomRealmMapper> value) {
		this.subresources.customRealmMappers = value;
		return (T) this;
	}

	/**
	 * Add the CustomRealmMapper object to the list of subresources
	 * 
	 * @param value
	 *            The CustomRealmMapper to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T customRealmMapper(CustomRealmMapper value) {
		this.subresources.customRealmMappers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a CustomRealmMapper object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the CustomRealmMapper resource
	 * @param config
	 *            The CustomRealmMapperConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T customRealmMapper(java.lang.String childKey,
			CustomRealmMapperConsumer consumer) {
		CustomRealmMapper<? extends CustomRealmMapper> child = new CustomRealmMapper<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		customRealmMapper(child);
		return (T) this;
	}

	/**
	 * Create and configure a CustomRealmMapper object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the CustomRealmMapper resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T customRealmMapper(java.lang.String childKey) {
		customRealmMapper(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied CustomRealmMapper object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T customRealmMapper(CustomRealmMapperSupplier supplier) {
		customRealmMapper(supplier.get());
		return (T) this;
	}

	/**
	 * Add all RegexPrincipalTransformer objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of RegexPrincipalTransformer objects.
	 */
	@SuppressWarnings("unchecked")
	public T regexPrincipalTransformers(
			java.util.List<RegexPrincipalTransformer> value) {
		this.subresources.regexPrincipalTransformers = value;
		return (T) this;
	}

	/**
	 * Add the RegexPrincipalTransformer object to the list of subresources
	 * 
	 * @param value
	 *            The RegexPrincipalTransformer to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T regexPrincipalTransformer(RegexPrincipalTransformer value) {
		this.subresources.regexPrincipalTransformers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a RegexPrincipalTransformer object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the RegexPrincipalTransformer resource
	 * @param config
	 *            The RegexPrincipalTransformerConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T regexPrincipalTransformer(java.lang.String childKey,
			RegexPrincipalTransformerConsumer consumer) {
		RegexPrincipalTransformer<? extends RegexPrincipalTransformer> child = new RegexPrincipalTransformer<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		regexPrincipalTransformer(child);
		return (T) this;
	}

	/**
	 * Create and configure a RegexPrincipalTransformer object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the RegexPrincipalTransformer resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T regexPrincipalTransformer(java.lang.String childKey) {
		regexPrincipalTransformer(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied RegexPrincipalTransformer object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T regexPrincipalTransformer(
			RegexPrincipalTransformerSupplier supplier) {
		regexPrincipalTransformer(supplier.get());
		return (T) this;
	}

	/**
	 * Add all TrustManager objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of TrustManager objects.
	 */
	@SuppressWarnings("unchecked")
	public T trustManagers(java.util.List<TrustManager> value) {
		this.subresources.trustManagers = value;
		return (T) this;
	}

	/**
	 * Add the TrustManager object to the list of subresources
	 * 
	 * @param value
	 *            The TrustManager to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T trustManager(TrustManager value) {
		this.subresources.trustManagers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a TrustManager object to the list of subresources
	 * 
	 * @param key
	 *            The key for the TrustManager resource
	 * @param config
	 *            The TrustManagerConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T trustManager(java.lang.String childKey,
			TrustManagerConsumer consumer) {
		TrustManager<? extends TrustManager> child = new TrustManager<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		trustManager(child);
		return (T) this;
	}

	/**
	 * Create and configure a TrustManager object to the list of subresources
	 * 
	 * @param key
	 *            The key for the TrustManager resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T trustManager(java.lang.String childKey) {
		trustManager(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied TrustManager object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T trustManager(TrustManagerSupplier supplier) {
		trustManager(supplier.get());
		return (T) this;
	}

	/**
	 * Add all MechanismProviderFilteringSASLServerFactory objects to this
	 * subresource
	 * 
	 * @return this
	 * @param value
	 *            List of MechanismProviderFilteringSASLServerFactory objects.
	 */
	@SuppressWarnings("unchecked")
	public T mechanismProviderFilteringSaslServerFactories(
			java.util.List<MechanismProviderFilteringSASLServerFactory> value) {
		this.subresources.mechanismProviderFilteringSaslServerFactories = value;
		return (T) this;
	}

	/**
	 * Add the MechanismProviderFilteringSASLServerFactory object to the list of
	 * subresources
	 * 
	 * @param value
	 *            The MechanismProviderFilteringSASLServerFactory to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T mechanismProviderFilteringSaslServerFactory(
			MechanismProviderFilteringSASLServerFactory value) {
		this.subresources.mechanismProviderFilteringSaslServerFactories
				.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a MechanismProviderFilteringSASLServerFactory object
	 * to the list of subresources
	 * 
	 * @param key
	 *            The key for the MechanismProviderFilteringSASLServerFactory
	 *            resource
	 * @param config
	 *            The MechanismProviderFilteringSASLServerFactoryConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T mechanismProviderFilteringSaslServerFactory(
			java.lang.String childKey,
			MechanismProviderFilteringSASLServerFactoryConsumer consumer) {
		MechanismProviderFilteringSASLServerFactory<? extends MechanismProviderFilteringSASLServerFactory> child = new MechanismProviderFilteringSASLServerFactory<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		mechanismProviderFilteringSaslServerFactory(child);
		return (T) this;
	}

	/**
	 * Create and configure a MechanismProviderFilteringSASLServerFactory object
	 * to the list of subresources
	 * 
	 * @param key
	 *            The key for the MechanismProviderFilteringSASLServerFactory
	 *            resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T mechanismProviderFilteringSaslServerFactory(
			java.lang.String childKey) {
		mechanismProviderFilteringSaslServerFactory(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied MechanismProviderFilteringSASLServerFactory object to
	 * the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T mechanismProviderFilteringSaslServerFactory(
			MechanismProviderFilteringSASLServerFactorySupplier supplier) {
		mechanismProviderFilteringSaslServerFactory(supplier.get());
		return (T) this;
	}

	/**
	 * Add all LdapRealm objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of LdapRealm objects.
	 */
	@SuppressWarnings("unchecked")
	public T ldapRealms(java.util.List<LdapRealm> value) {
		this.subresources.ldapRealms = value;
		return (T) this;
	}

	/**
	 * Add the LdapRealm object to the list of subresources
	 * 
	 * @param value
	 *            The LdapRealm to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T ldapRealm(LdapRealm value) {
		this.subresources.ldapRealms.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a LdapRealm object to the list of subresources
	 * 
	 * @param key
	 *            The key for the LdapRealm resource
	 * @param config
	 *            The LdapRealmConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T ldapRealm(java.lang.String childKey, LdapRealmConsumer consumer) {
		LdapRealm<? extends LdapRealm> child = new LdapRealm<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		ldapRealm(child);
		return (T) this;
	}

	/**
	 * Create and configure a LdapRealm object to the list of subresources
	 * 
	 * @param key
	 *            The key for the LdapRealm resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T ldapRealm(java.lang.String childKey) {
		ldapRealm(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied LdapRealm object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T ldapRealm(LdapRealmSupplier supplier) {
		ldapRealm(supplier.get());
		return (T) this;
	}

	/**
	 * Add all AggregateProviders objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of AggregateProviders objects.
	 */
	@SuppressWarnings("unchecked")
	public T aggregateProviders(java.util.List<AggregateProviders> value) {
		this.subresources.aggregateProviders = value;
		return (T) this;
	}

	/**
	 * Add the AggregateProviders object to the list of subresources
	 * 
	 * @param value
	 *            The AggregateProviders to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T aggregateProviders(AggregateProviders value) {
		this.subresources.aggregateProviders.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a AggregateProviders object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the AggregateProviders resource
	 * @param config
	 *            The AggregateProvidersConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T aggregateProviders(java.lang.String childKey,
			AggregateProvidersConsumer consumer) {
		AggregateProviders<? extends AggregateProviders> child = new AggregateProviders<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		aggregateProviders(child);
		return (T) this;
	}

	/**
	 * Create and configure a AggregateProviders object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the AggregateProviders resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T aggregateProviders(java.lang.String childKey) {
		aggregateProviders(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied AggregateProviders object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T aggregateProviders(AggregateProvidersSupplier supplier) {
		aggregateProviders(supplier.get());
		return (T) this;
	}

	/**
	 * Add all KeyStore objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of KeyStore objects.
	 */
	@SuppressWarnings("unchecked")
	public T keyStores(java.util.List<KeyStore> value) {
		this.subresources.keyStores = value;
		return (T) this;
	}

	/**
	 * Add the KeyStore object to the list of subresources
	 * 
	 * @param value
	 *            The KeyStore to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T keyStore(KeyStore value) {
		this.subresources.keyStores.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a KeyStore object to the list of subresources
	 * 
	 * @param key
	 *            The key for the KeyStore resource
	 * @param config
	 *            The KeyStoreConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T keyStore(java.lang.String childKey, KeyStoreConsumer consumer) {
		KeyStore<? extends KeyStore> child = new KeyStore<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		keyStore(child);
		return (T) this;
	}

	/**
	 * Create and configure a KeyStore object to the list of subresources
	 * 
	 * @param key
	 *            The key for the KeyStore resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T keyStore(java.lang.String childKey) {
		keyStore(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied KeyStore object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T keyStore(KeyStoreSupplier supplier) {
		keyStore(supplier.get());
		return (T) this;
	}

	/**
	 * Add all HTTPAuthenticationFactory objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of HTTPAuthenticationFactory objects.
	 */
	@SuppressWarnings("unchecked")
	public T httpAuthenticationFactories(
			java.util.List<HTTPAuthenticationFactory> value) {
		this.subresources.httpAuthenticationFactories = value;
		return (T) this;
	}

	/**
	 * Add the HTTPAuthenticationFactory object to the list of subresources
	 * 
	 * @param value
	 *            The HTTPAuthenticationFactory to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T httpAuthenticationFactory(HTTPAuthenticationFactory value) {
		this.subresources.httpAuthenticationFactories.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a HTTPAuthenticationFactory object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the HTTPAuthenticationFactory resource
	 * @param config
	 *            The HTTPAuthenticationFactoryConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T httpAuthenticationFactory(java.lang.String childKey,
			HTTPAuthenticationFactoryConsumer consumer) {
		HTTPAuthenticationFactory<? extends HTTPAuthenticationFactory> child = new HTTPAuthenticationFactory<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		httpAuthenticationFactory(child);
		return (T) this;
	}

	/**
	 * Create and configure a HTTPAuthenticationFactory object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the HTTPAuthenticationFactory resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T httpAuthenticationFactory(java.lang.String childKey) {
		httpAuthenticationFactory(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied HTTPAuthenticationFactory object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T httpAuthenticationFactory(
			HTTPAuthenticationFactorySupplier supplier) {
		httpAuthenticationFactory(supplier.get());
		return (T) this;
	}

	/**
	 * Add all AggregateSASLServerFactory objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of AggregateSASLServerFactory objects.
	 */
	@SuppressWarnings("unchecked")
	public T aggregateSaslServerFactories(
			java.util.List<AggregateSASLServerFactory> value) {
		this.subresources.aggregateSaslServerFactories = value;
		return (T) this;
	}

	/**
	 * Add the AggregateSASLServerFactory object to the list of subresources
	 * 
	 * @param value
	 *            The AggregateSASLServerFactory to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T aggregateSaslServerFactory(AggregateSASLServerFactory value) {
		this.subresources.aggregateSaslServerFactories.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a AggregateSASLServerFactory object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the AggregateSASLServerFactory resource
	 * @param config
	 *            The AggregateSASLServerFactoryConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T aggregateSaslServerFactory(java.lang.String childKey,
			AggregateSASLServerFactoryConsumer consumer) {
		AggregateSASLServerFactory<? extends AggregateSASLServerFactory> child = new AggregateSASLServerFactory<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		aggregateSaslServerFactory(child);
		return (T) this;
	}

	/**
	 * Create and configure a AggregateSASLServerFactory object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the AggregateSASLServerFactory resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T aggregateSaslServerFactory(java.lang.String childKey) {
		aggregateSaslServerFactory(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied AggregateSASLServerFactory object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T aggregateSaslServerFactory(
			AggregateSASLServerFactorySupplier supplier) {
		aggregateSaslServerFactory(supplier.get());
		return (T) this;
	}

	/**
	 * Add all SimpleRegexRealmMapper objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of SimpleRegexRealmMapper objects.
	 */
	@SuppressWarnings("unchecked")
	public T simpleRegexRealmMappers(
			java.util.List<SimpleRegexRealmMapper> value) {
		this.subresources.simpleRegexRealmMappers = value;
		return (T) this;
	}

	/**
	 * Add the SimpleRegexRealmMapper object to the list of subresources
	 * 
	 * @param value
	 *            The SimpleRegexRealmMapper to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T simpleRegexRealmMapper(SimpleRegexRealmMapper value) {
		this.subresources.simpleRegexRealmMappers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a SimpleRegexRealmMapper object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the SimpleRegexRealmMapper resource
	 * @param config
	 *            The SimpleRegexRealmMapperConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T simpleRegexRealmMapper(java.lang.String childKey,
			SimpleRegexRealmMapperConsumer consumer) {
		SimpleRegexRealmMapper<? extends SimpleRegexRealmMapper> child = new SimpleRegexRealmMapper<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		simpleRegexRealmMapper(child);
		return (T) this;
	}

	/**
	 * Create and configure a SimpleRegexRealmMapper object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the SimpleRegexRealmMapper resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T simpleRegexRealmMapper(java.lang.String childKey) {
		simpleRegexRealmMapper(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied SimpleRegexRealmMapper object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T simpleRegexRealmMapper(SimpleRegexRealmMapperSupplier supplier) {
		simpleRegexRealmMapper(supplier.get());
		return (T) this;
	}

	/**
	 * Add all CachingRealm objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of CachingRealm objects.
	 */
	@SuppressWarnings("unchecked")
	public T cachingRealms(java.util.List<CachingRealm> value) {
		this.subresources.cachingRealms = value;
		return (T) this;
	}

	/**
	 * Add the CachingRealm object to the list of subresources
	 * 
	 * @param value
	 *            The CachingRealm to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T cachingRealm(CachingRealm value) {
		this.subresources.cachingRealms.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a CachingRealm object to the list of subresources
	 * 
	 * @param key
	 *            The key for the CachingRealm resource
	 * @param config
	 *            The CachingRealmConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T cachingRealm(java.lang.String childKey,
			CachingRealmConsumer consumer) {
		CachingRealm<? extends CachingRealm> child = new CachingRealm<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		cachingRealm(child);
		return (T) this;
	}

	/**
	 * Create and configure a CachingRealm object to the list of subresources
	 * 
	 * @param key
	 *            The key for the CachingRealm resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T cachingRealm(java.lang.String childKey) {
		cachingRealm(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied CachingRealm object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T cachingRealm(CachingRealmSupplier supplier) {
		cachingRealm(supplier.get());
		return (T) this;
	}

	/**
	 * Add all KeyManager objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of KeyManager objects.
	 */
	@SuppressWarnings("unchecked")
	public T keyManagers(java.util.List<KeyManager> value) {
		this.subresources.keyManagers = value;
		return (T) this;
	}

	/**
	 * Add the KeyManager object to the list of subresources
	 * 
	 * @param value
	 *            The KeyManager to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T keyManager(KeyManager value) {
		this.subresources.keyManagers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a KeyManager object to the list of subresources
	 * 
	 * @param key
	 *            The key for the KeyManager resource
	 * @param config
	 *            The KeyManagerConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T keyManager(java.lang.String childKey, KeyManagerConsumer consumer) {
		KeyManager<? extends KeyManager> child = new KeyManager<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		keyManager(child);
		return (T) this;
	}

	/**
	 * Create and configure a KeyManager object to the list of subresources
	 * 
	 * @param key
	 *            The key for the KeyManager resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T keyManager(java.lang.String childKey) {
		keyManager(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied KeyManager object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T keyManager(KeyManagerSupplier supplier) {
		keyManager(supplier.get());
		return (T) this;
	}

	/**
	 * Add all ServerSslContext objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ServerSslContext objects.
	 */
	@SuppressWarnings("unchecked")
	public T serverSslContexts(java.util.List<ServerSslContext> value) {
		this.subresources.serverSslContexts = value;
		return (T) this;
	}

	/**
	 * Add the ServerSslContext object to the list of subresources
	 * 
	 * @param value
	 *            The ServerSslContext to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T serverSslContext(ServerSslContext value) {
		this.subresources.serverSslContexts.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ServerSslContext object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ServerSslContext resource
	 * @param config
	 *            The ServerSslContextConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T serverSslContext(java.lang.String childKey,
			ServerSslContextConsumer consumer) {
		ServerSslContext<? extends ServerSslContext> child = new ServerSslContext<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		serverSslContext(child);
		return (T) this;
	}

	/**
	 * Create and configure a ServerSslContext object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ServerSslContext resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T serverSslContext(java.lang.String childKey) {
		serverSslContext(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ServerSslContext object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T serverSslContext(ServerSslContextSupplier supplier) {
		serverSslContext(supplier.get());
		return (T) this;
	}

	/**
	 * Add all AddSuffixRoleMapper objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of AddSuffixRoleMapper objects.
	 */
	@SuppressWarnings("unchecked")
	public T addSuffixRoleMappers(java.util.List<AddSuffixRoleMapper> value) {
		this.subresources.addSuffixRoleMappers = value;
		return (T) this;
	}

	/**
	 * Add the AddSuffixRoleMapper object to the list of subresources
	 * 
	 * @param value
	 *            The AddSuffixRoleMapper to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T addSuffixRoleMapper(AddSuffixRoleMapper value) {
		this.subresources.addSuffixRoleMappers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a AddSuffixRoleMapper object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the AddSuffixRoleMapper resource
	 * @param config
	 *            The AddSuffixRoleMapperConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T addSuffixRoleMapper(java.lang.String childKey,
			AddSuffixRoleMapperConsumer consumer) {
		AddSuffixRoleMapper<? extends AddSuffixRoleMapper> child = new AddSuffixRoleMapper<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		addSuffixRoleMapper(child);
		return (T) this;
	}

	/**
	 * Create and configure a AddSuffixRoleMapper object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the AddSuffixRoleMapper resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T addSuffixRoleMapper(java.lang.String childKey) {
		addSuffixRoleMapper(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied AddSuffixRoleMapper object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T addSuffixRoleMapper(AddSuffixRoleMapperSupplier supplier) {
		addSuffixRoleMapper(supplier.get());
		return (T) this;
	}

	/**
	 * Add all CustomSecurityEventListener objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of CustomSecurityEventListener objects.
	 */
	@SuppressWarnings("unchecked")
	public T customSecurityEventListeners(
			java.util.List<CustomSecurityEventListener> value) {
		this.subresources.customSecurityEventListeners = value;
		return (T) this;
	}

	/**
	 * Add the CustomSecurityEventListener object to the list of subresources
	 * 
	 * @param value
	 *            The CustomSecurityEventListener to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T customSecurityEventListener(CustomSecurityEventListener value) {
		this.subresources.customSecurityEventListeners.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a CustomSecurityEventListener object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the CustomSecurityEventListener resource
	 * @param config
	 *            The CustomSecurityEventListenerConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T customSecurityEventListener(java.lang.String childKey,
			CustomSecurityEventListenerConsumer consumer) {
		CustomSecurityEventListener<? extends CustomSecurityEventListener> child = new CustomSecurityEventListener<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		customSecurityEventListener(child);
		return (T) this;
	}

	/**
	 * Create and configure a CustomSecurityEventListener object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the CustomSecurityEventListener resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T customSecurityEventListener(java.lang.String childKey) {
		customSecurityEventListener(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied CustomSecurityEventListener object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T customSecurityEventListener(
			CustomSecurityEventListenerSupplier supplier) {
		customSecurityEventListener(supplier.get());
		return (T) this;
	}

	/**
	 * Add all CustomPermissionMapper objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of CustomPermissionMapper objects.
	 */
	@SuppressWarnings("unchecked")
	public T customPermissionMappers(
			java.util.List<CustomPermissionMapper> value) {
		this.subresources.customPermissionMappers = value;
		return (T) this;
	}

	/**
	 * Add the CustomPermissionMapper object to the list of subresources
	 * 
	 * @param value
	 *            The CustomPermissionMapper to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T customPermissionMapper(CustomPermissionMapper value) {
		this.subresources.customPermissionMappers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a CustomPermissionMapper object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the CustomPermissionMapper resource
	 * @param config
	 *            The CustomPermissionMapperConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T customPermissionMapper(java.lang.String childKey,
			CustomPermissionMapperConsumer consumer) {
		CustomPermissionMapper<? extends CustomPermissionMapper> child = new CustomPermissionMapper<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		customPermissionMapper(child);
		return (T) this;
	}

	/**
	 * Create and configure a CustomPermissionMapper object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the CustomPermissionMapper resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T customPermissionMapper(java.lang.String childKey) {
		customPermissionMapper(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied CustomPermissionMapper object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T customPermissionMapper(CustomPermissionMapperSupplier supplier) {
		customPermissionMapper(supplier.get());
		return (T) this;
	}

	/**
	 * Add all ConcatenatingPrincipalDecoder objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ConcatenatingPrincipalDecoder objects.
	 */
	@SuppressWarnings("unchecked")
	public T concatenatingPrincipalDecoders(
			java.util.List<ConcatenatingPrincipalDecoder> value) {
		this.subresources.concatenatingPrincipalDecoders = value;
		return (T) this;
	}

	/**
	 * Add the ConcatenatingPrincipalDecoder object to the list of subresources
	 * 
	 * @param value
	 *            The ConcatenatingPrincipalDecoder to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T concatenatingPrincipalDecoder(ConcatenatingPrincipalDecoder value) {
		this.subresources.concatenatingPrincipalDecoders.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ConcatenatingPrincipalDecoder object to the list
	 * of subresources
	 * 
	 * @param key
	 *            The key for the ConcatenatingPrincipalDecoder resource
	 * @param config
	 *            The ConcatenatingPrincipalDecoderConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T concatenatingPrincipalDecoder(java.lang.String childKey,
			ConcatenatingPrincipalDecoderConsumer consumer) {
		ConcatenatingPrincipalDecoder<? extends ConcatenatingPrincipalDecoder> child = new ConcatenatingPrincipalDecoder<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		concatenatingPrincipalDecoder(child);
		return (T) this;
	}

	/**
	 * Create and configure a ConcatenatingPrincipalDecoder object to the list
	 * of subresources
	 * 
	 * @param key
	 *            The key for the ConcatenatingPrincipalDecoder resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T concatenatingPrincipalDecoder(java.lang.String childKey) {
		concatenatingPrincipalDecoder(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ConcatenatingPrincipalDecoder object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T concatenatingPrincipalDecoder(
			ConcatenatingPrincipalDecoderSupplier supplier) {
		concatenatingPrincipalDecoder(supplier.get());
		return (T) this;
	}

	/**
	 * Child mutators for Elytron
	 */
	public static class ElytronResources {
		/**
		 * A custom principal transformer definition.
		 */
		@ResourceDocumentation("A custom principal transformer definition.")
		@SubresourceInfo("customPrincipalTransformer")
		private List<CustomPrincipalTransformer> customPrincipalTransformers = new java.util.ArrayList<>();
		/**
		 * Definition of a principal decoder that always returns the same
		 * constant.
		 */
		@ResourceDocumentation("Definition of a principal decoder that always returns the same constant.")
		@SubresourceInfo("constantPrincipalDecoder")
		private List<ConstantPrincipalDecoder> constantPrincipalDecoders = new java.util.ArrayList<>();
		/**
		 * A realm definition that is an aggregation of two realms, one for the
		 * authentication steps and one for loading the identity for the
		 * authorization steps.
		 */
		@ResourceDocumentation("A realm definition that is an aggregation of two realms, one for the authentication steps and one for loading the identity for the authorization steps.")
		@SubresourceInfo("aggregateRealm")
		private List<AggregateRealm> aggregateRealms = new java.util.ArrayList<>();
		/**
		 * Definition of a custom RoleMapper
		 */
		@ResourceDocumentation("Definition of a custom RoleMapper")
		@SubresourceInfo("customRoleMapper")
		private List<CustomRoleMapper> customRoleMappers = new java.util.ArrayList<>();
		/**
		 * A simple security realm definition backed by the filesystem.
		 */
		@ResourceDocumentation("A simple security realm definition backed by the filesystem.")
		@SubresourceInfo("filesystemRealm")
		private List<FilesystemRealm> filesystemRealms = new java.util.ArrayList<>();
		/**
		 * A certificate authority account definition.
		 */
		@ResourceDocumentation("A certificate authority account definition.")
		@SubresourceInfo("certificateAuthorityAccount")
		private List<CertificateAuthorityAccount> certificateAuthorityAccounts = new java.util.ArrayList<>();
		/**
		 * Definition of a logical permission mapper.
		 */
		@ResourceDocumentation("Definition of a logical permission mapper.")
		@SubresourceInfo("logicalPermissionMapper")
		private List<LogicalPermissionMapper> logicalPermissionMappers = new java.util.ArrayList<>();
		/**
		 * A principal transformer definition for a PrincipalTransformer that
		 * always returns the same constant.
		 */
		@ResourceDocumentation("A principal transformer definition for a PrincipalTransformer that always returns the same constant.")
		@SubresourceInfo("constantPrincipalTransformer")
		private List<ConstantPrincipalTransformer> constantPrincipalTransformers = new java.util.ArrayList<>();
		/**
		 * A custom realm definitions can implement either the SecurityRealm
		 * interface or the ModifiableSecurityRealm interface. Regardless of
		 * which interface is implemented management operations will not be
		 * exposed to manage the realm. However other services that depend on
		 * the realm will still be able to perform a type check and cast to gain
		 * access to the modification API.
		 */
		@ResourceDocumentation("A custom realm definitions can implement either the SecurityRealm interface or the ModifiableSecurityRealm interface. Regardless of which interface is implemented management operations will not be exposed to manage the realm.  However other services that depend on the realm will still be able to perform a type check and cast to gain access to the modification API.")
		@SubresourceInfo("customRealm")
		private List<CustomRealm> customRealms = new java.util.ArrayList<>();
		/**
		 * Resource containing the association of a SecurityDomain with a
		 * SaslServerFactory.
		 */
		@ResourceDocumentation("Resource containing the association of a SecurityDomain with a SaslServerFactory.")
		@SubresourceInfo("saslAuthenticationFactory")
		private List<SASLAuthenticationFactory> saslAuthenticationFactories = new java.util.ArrayList<>();
		/**
		 * A http server factory definition where the http server factory is an
		 * aggregation of factories identified using a ServiceLoader
		 */
		@ResourceDocumentation("A http server factory definition where the http server factory is an aggregation of factories identified using a ServiceLoader")
		@SubresourceInfo("serviceLoaderHttpServerMechanismFactory")
		private List<ServiceLoaderHTTPServerMechanismFactory> serviceLoaderHttpServerMechanismFactories = new java.util.ArrayList<>();
		/**
		 * A security realm definition backed by database using JDBC.
		 */
		@ResourceDocumentation("A security realm definition backed by database using JDBC.")
		@SubresourceInfo("jdbcRealm")
		private List<JDBCRealm> jdbcRealms = new java.util.ArrayList<>();
		/**
		 * Resource containing the JASPI ServerAuthModule configuration for the
		 * servlet profile.
		 */
		@ResourceDocumentation("Resource containing the JASPI ServerAuthModule configuration for the servlet profile.")
		@SubresourceInfo("jaspiConfiguration")
		private List<JaspiConfiguration> jaspiConfigurations = new java.util.ArrayList<>();
		/**
		 * Definition of a custom RoleDecoder
		 */
		@ResourceDocumentation("Definition of a custom RoleDecoder")
		@SubresourceInfo("customRoleDecoder")
		private List<CustomRoleDecoder> customRoleDecoders = new java.util.ArrayList<>();
		/**
		 * Credential store to keep alias for sensitive information such as
		 * passwords for external services.
		 */
		@ResourceDocumentation("Credential store to keep alias for sensitive information such as passwords for external services.")
		@SubresourceInfo("credentialStore")
		private List<CredentialStore> credentialStores = new java.util.ArrayList<>();
		/**
		 * A security factory for obtaining a GSSCredential for use during
		 * authentication.
		 */
		@ResourceDocumentation("A security factory for obtaining a GSSCredential for use during authentication.")
		@SubresourceInfo("kerberosSecurityFactory")
		private List<KerberosSecurityFactory> kerberosSecurityFactories = new java.util.ArrayList<>();
		/**
		 * A HTTP server factory definition that wraps another HTTP server
		 * factory and applies the specified configuration and filtering.
		 */
		@ResourceDocumentation("A HTTP server factory definition that wraps another HTTP server factory and applies the specified configuration and filtering.")
		@SubresourceInfo("configurableHttpServerMechanismFactory")
		private List<ConfigurableHTTPServerMechanismFactory> configurableHttpServerMechanismFactories = new java.util.ArrayList<>();
		/**
		 * A http server factory definition where the http server factory is an
		 * aggregation of factories from the Provider[]
		 */
		@ResourceDocumentation("A http server factory definition where the http server factory is an aggregation of factories from the Provider[]")
		@SubresourceInfo("providerHttpServerMechanismFactory")
		private List<ProviderHTTPServerMechanismFactory> providerHttpServerMechanismFactories = new java.util.ArrayList<>();
		/**
		 * A RoleMapper definition for a RoleMapper that performs a logical
		 * operation using two referenced RoleMappers.
		 */
		@ResourceDocumentation("A RoleMapper definition for a RoleMapper that performs a logical operation using two referenced RoleMappers.")
		@SubresourceInfo("logicalRoleMapper")
		private List<LogicalRoleMapper> logicalRoleMappers = new java.util.ArrayList<>();
		/**
		 * A role mapper definition where the role mapper is an aggregation of
		 * other role mappers.
		 */
		@ResourceDocumentation("A role mapper definition where the role mapper is an aggregation of other role mappers.")
		@SubresourceInfo("aggregateRoleMapper")
		private List<AggregateRoleMapper> aggregateRoleMappers = new java.util.ArrayList<>();
		/**
		 * A definition for a Provider loader.
		 */
		@ResourceDocumentation("A definition for a Provider loader.")
		@SubresourceInfo("providerLoader")
		private List<ProviderLoader> providerLoaders = new java.util.ArrayList<>();
		/**
		 * Definition of a custom principal decoder
		 */
		@ResourceDocumentation("Definition of a custom principal decoder")
		@SubresourceInfo("customPrincipalDecoder")
		private List<CustomPrincipalDecoder> customPrincipalDecoders = new java.util.ArrayList<>();
		/**
		 * An audit log definition for persisting an audit log to a local files
		 * rotating the log after the size of the file grows beyond a certain
		 * point and keeping a fixed number of backups.
		 */
		@ResourceDocumentation("An audit log definition for persisting an audit log to a local files rotating the log after the size of the file grows beyond a certain point and keeping a fixed number of backups.")
		@SubresourceInfo("sizeRotatingFileAuditLog")
		private List<SizeRotatingFileAuditLog> sizeRotatingFileAuditLogs = new java.util.ArrayList<>();
		/**
		 * Definition of a permission mapper that always returns the same
		 * constant.
		 */
		@ResourceDocumentation("Definition of a permission mapper that always returns the same constant.")
		@SubresourceInfo("constantPermissionMapper")
		private List<ConstantPermissionMapper> constantPermissionMappers = new java.util.ArrayList<>();
		/**
		 * A security realm definition capable of validating and extracting
		 * identities from security tokens.
		 */
		@ResourceDocumentation("A security realm definition capable of validating and extracting identities from security tokens.")
		@SubresourceInfo("tokenRealm")
		private List<TokenRealm> tokenRealms = new java.util.ArrayList<>();
		/**
		 * An SSLContext for use on the client side of a connection.
		 */
		@ResourceDocumentation("An SSLContext for use on the client side of a connection.")
		@SubresourceInfo("clientSslContext")
		private List<ClientSslContext> clientSslContexts = new java.util.ArrayList<>();
		/**
		 * A security domain definition.
		 */
		@ResourceDocumentation("A security domain definition.")
		@SubresourceInfo("securityDomain")
		private List<SecurityDomain> securityDomains = new java.util.ArrayList<>();
		/**
		 * A role mapper definition where a constant set of roles is always
		 * returned.
		 */
		@ResourceDocumentation("A role mapper definition where a constant set of roles is always returned.")
		@SubresourceInfo("constantRoleMapper")
		private List<ConstantRoleMapper> constantRoleMappers = new java.util.ArrayList<>();
		/**
		 * Realm definition for a realm which contains a single pre-defined
		 * identity.
		 */
		@ResourceDocumentation("Realm definition for a realm which contains a single pre-defined identity.")
		@SubresourceInfo("identityRealm")
		private List<IdentityRealm> identityRealms = new java.util.ArrayList<>();
		/**
		 * A filtering KeyStore definition.
		 */
		@ResourceDocumentation("A filtering KeyStore definition.")
		@SubresourceInfo("filteringKeyStore")
		private List<FilteringKeyStore> filteringKeyStores = new java.util.ArrayList<>();
		/**
		 * A security realm definition backed by properties files.
		 */
		@ResourceDocumentation("A security realm definition backed by properties files.")
		@SubresourceInfo("propertiesRealm")
		private List<PropertiesRealm> propertiesRealms = new java.util.ArrayList<>();
		/**
		 * A principal decoder definition where the principal decoder is an
		 * aggregation of other principal decoders.
		 */
		@ResourceDocumentation("A principal decoder definition where the principal decoder is an aggregation of other principal decoders.")
		@SubresourceInfo("aggregatePrincipalDecoder")
		private List<AggregatePrincipalDecoder> aggregatePrincipalDecoders = new java.util.ArrayList<>();
		/**
		 * A principal transformer aggregating more principal transformers.
		 * Original principal is tried to be transformed by individual
		 * transformers until one return non-null principal - that is returned.
		 */
		@ResourceDocumentation("A principal transformer aggregating more principal transformers. Original principal is tried to be transformed by individual transformers until one return non-null principal - that is returned.")
		@SubresourceInfo("aggregatePrincipalTransformer")
		private List<AggregatePrincipalTransformer> aggregatePrincipalTransformers = new java.util.ArrayList<>();
		/**
		 * A server side SNI Aware SSLContext that selects between an underlying
		 * context based on the provided SNI name
		 */
		@ResourceDocumentation("A server side SNI Aware SSLContext that selects between an underlying context based on the provided SNI name")
		@SubresourceInfo("serverSslSniContext")
		private List<ServerSslSniContext> serverSslSniContexts = new java.util.ArrayList<>();
		/**
		 * A custom credential SecurityFactory definition.
		 */
		@ResourceDocumentation("A custom credential SecurityFactory definition.")
		@SubresourceInfo("customCredentialSecurityFactory")
		private List<CustomCredentialSecurityFactory> customCredentialSecurityFactories = new java.util.ArrayList<>();
		/**
		 * An audit log definition for persisting an audit log to a local files
		 * rotating the log after a time period derived from the given suffix
		 * string, which should be in a format understood by
		 * java.time.format.DateTimeFormatter.
		 */
		@ResourceDocumentation("An audit log definition for persisting an audit log to a local files rotating the log after a time period derived from the given suffix string, which should be in a format understood by java.time.format.DateTimeFormatter.")
		@SubresourceInfo("periodicRotatingFileAuditLog")
		private List<PeriodicRotatingFileAuditLog> periodicRotatingFileAuditLogs = new java.util.ArrayList<>();
		/**
		 * Definition of a simple configured permission mapper.
		 */
		@ResourceDocumentation("Definition of a simple configured permission mapper.")
		@SubresourceInfo("simplePermissionMapper")
		private List<SimplePermissionMapper> simplePermissionMappers = new java.util.ArrayList<>();
		/**
		 * A RoleMapper definition for a RoleMapper that performs a mapping
		 * based on configured map.
		 */
		@ResourceDocumentation("A RoleMapper definition for a RoleMapper that performs a mapping based on configured map.")
		@SubresourceInfo("mappedRoleMapper")
		private List<MappedRoleMapper> mappedRoleMappers = new java.util.ArrayList<>();
		/**
		 * Definition of a constant RealmMapper that always returns the same
		 * value.
		 */
		@ResourceDocumentation("Definition of a constant RealmMapper that always returns the same value.")
		@SubresourceInfo("constantRealmMapper")
		private List<ConstantRealmMapper> constantRealmMappers = new java.util.ArrayList<>();
		/**
		 * Definition of a simple RoleDecoder that takes a single attribute and
		 * maps it directly to roles.
		 */
		@ResourceDocumentation("Definition of a simple RoleDecoder that takes a single attribute and maps it directly to roles.")
		@SubresourceInfo("simpleRoleDecoder")
		private List<SimpleRoleDecoder> simpleRoleDecoders = new java.util.ArrayList<>();
		/**
		 * A SaslServerFactory definition that wraps another SaslServerFactory
		 * and applies the specified configuration and filtering.
		 */
		@ResourceDocumentation("A SaslServerFactory definition that wraps another SaslServerFactory and applies the specified configuration and filtering.")
		@SubresourceInfo("configurableSaslServerFactory")
		private List<ConfigurableSASLServerFactory> configurableSaslServerFactories = new java.util.ArrayList<>();
		/**
		 * A regular expression based principal transformer which uses the
		 * regular expression to validate the name.
		 */
		@ResourceDocumentation("A regular expression based principal transformer which uses the regular expression to validate the name.")
		@SubresourceInfo("regexValidatingPrincipalTransformer")
		private List<RegexValidatingPrincipalTransformer> regexValidatingPrincipalTransformers = new java.util.ArrayList<>();
		/**
		 * A sasl server factory definition where the sasl server factory is an
		 * aggregation of factories identified using a ServiceLoader
		 */
		@ResourceDocumentation("A sasl server factory definition where the sasl server factory is an aggregation of factories identified using a ServiceLoader")
		@SubresourceInfo("serviceLoaderSaslServerFactory")
		private List<ServiceLoaderSASLServerFactory> serviceLoaderSaslServerFactories = new java.util.ArrayList<>();
		/**
		 * Definition of a permission set.
		 */
		@ResourceDocumentation("Definition of a permission set.")
		@SubresourceInfo("permissionSet")
		private List<PermissionSet> permissionSets = new java.util.ArrayList<>();
		/**
		 * A LdapKeyStore definition.
		 */
		@ResourceDocumentation("A LdapKeyStore definition.")
		@SubresourceInfo("ldapKeyStore")
		private List<LdapKeyStore> ldapKeyStores = new java.util.ArrayList<>();
		/**
		 * Definition of a X.500 attribute based principal decoder
		 */
		@ResourceDocumentation("Definition of a X.500 attribute based principal decoder")
		@SubresourceInfo("x500AttributePrincipalDecoder")
		private List<X500AttributePrincipalDecoder> x500AttributePrincipalDecoders = new java.util.ArrayList<>();
		/**
		 * The configuration to connect to a directory (LDAP) server.
		 */
		@ResourceDocumentation("The configuration to connect to a directory (LDAP) server.")
		@SubresourceInfo("dirContext")
		private List<DirContext> dirContexts = new java.util.ArrayList<>();
		/**
		 * Definition of a RealmMapper implementation that first uses a regular
		 * expression to extract the realm name, this is then converted using
		 * the configured mapping of realm names.
		 */
		@ResourceDocumentation("Definition of a RealmMapper implementation that first uses a regular expression to extract the realm name, this is then converted using the configured mapping of realm names.")
		@SubresourceInfo("mappedRegexRealmMapper")
		private List<MappedRegexRealmMapper> mappedRegexRealmMappers = new java.util.ArrayList<>();
		/**
		 * An audit logger that sends audit events to a remote syslog server.
		 */
		@ResourceDocumentation("An audit logger that sends audit events to a remote syslog server.")
		@SubresourceInfo("syslogAuditLog")
		private List<SyslogAuditLog> syslogAuditLogs = new java.util.ArrayList<>();
		/**
		 * An aggregation of two or more security event listener resources.
		 */
		@ResourceDocumentation("An aggregation of two or more security event listener resources.")
		@SubresourceInfo("aggregateSecurityEventListener")
		private List<AggregateSecurityEventListener> aggregateSecurityEventListeners = new java.util.ArrayList<>();
		/**
		 * A principal transformer definition where the principal transformer is
		 * a chaining of other principal transformers.
		 */
		@ResourceDocumentation("A principal transformer definition where the principal transformer is a chaining of other principal transformers.")
		@SubresourceInfo("chainedPrincipalTransformer")
		private List<ChainedPrincipalTransformer> chainedPrincipalTransformers = new java.util.ArrayList<>();
		/**
		 * An individual authentication context definition.
		 */
		@ResourceDocumentation("An individual authentication context definition.")
		@SubresourceInfo("authenticationContext")
		private List<AuthenticationContext> authenticationContexts = new java.util.ArrayList<>();
		/**
		 * An audit logger that logs to a local file.
		 */
		@ResourceDocumentation("An audit logger that logs to a local file.")
		@SubresourceInfo("fileAuditLog")
		private List<FileAuditLog> fileAuditLogs = new java.util.ArrayList<>();
		/**
		 * A security realm definition backed by a key store.
		 */
		@ResourceDocumentation("A security realm definition backed by a key store.")
		@SubresourceInfo("keyStoreRealm")
		private List<KeyStoreRealm> keyStoreRealms = new java.util.ArrayList<>();
		/**
		 * A definition that sets up a policy provider.
		 */
		@ResourceDocumentation("A definition that sets up a policy provider.")
		@SubresourceInfo("policy")
		private List<Policy> policies = new java.util.ArrayList<>();
		/**
		 * An individual authentication configuration definition.
		 */
		@ResourceDocumentation("An individual authentication configuration definition.")
		@SubresourceInfo("authenticationConfiguration")
		private List<AuthenticationConfiguration> authenticationConfigurations = new java.util.ArrayList<>();
		/**
		 * A sasl server factory definition where the sasl server factory is an
		 * aggregation of factories from the Provider[]
		 */
		@ResourceDocumentation("A sasl server factory definition where the sasl server factory is an aggregation of factories from the Provider[]")
		@SubresourceInfo("providerSaslServerFactory")
		private List<ProviderSASLServerFactory> providerSaslServerFactories = new java.util.ArrayList<>();
		/**
		 * Custom realm configured as being modifiable will be expected to
		 * implement the ModifiableSecurityRealm interface. By configuring a
		 * realm as being modifiable management operations will be made
		 * available to manipulate the realm.
		 */
		@ResourceDocumentation("Custom realm configured as being modifiable will be expected to implement the ModifiableSecurityRealm interface. By configuring a realm as being modifiable management operations will be made available to manipulate the realm.")
		@SubresourceInfo("customModifiableRealm")
		private List<CustomModifiableRealm> customModifiableRealms = new java.util.ArrayList<>();
		/**
		 * A role mapper definition for a role mapper that adds a prefix to each
		 * provided.
		 */
		@ResourceDocumentation("A role mapper definition for a role mapper that adds a prefix to each provided.")
		@SubresourceInfo("addPrefixRoleMapper")
		private List<AddPrefixRoleMapper> addPrefixRoleMappers = new java.util.ArrayList<>();
		/**
		 * A http server factory definition where the http server factory is an
		 * aggregation of other http server factories.
		 */
		@ResourceDocumentation("A http server factory definition where the http server factory is an aggregation of other http server factories.")
		@SubresourceInfo("aggregateHttpServerMechanismFactory")
		private List<AggregateHTTPServerMechanismFactory> aggregateHttpServerMechanismFactories = new java.util.ArrayList<>();
		/**
		 * Definition of a custom RealmMapper
		 */
		@ResourceDocumentation("Definition of a custom RealmMapper")
		@SubresourceInfo("customRealmMapper")
		private List<CustomRealmMapper> customRealmMappers = new java.util.ArrayList<>();
		/**
		 * A regular expression based principal transformer
		 */
		@ResourceDocumentation("A regular expression based principal transformer")
		@SubresourceInfo("regexPrincipalTransformer")
		private List<RegexPrincipalTransformer> regexPrincipalTransformers = new java.util.ArrayList<>();
		/**
		 * A trust manager definition for creating the TrustManager[] as used to
		 * create an SSLContext.
		 */
		@ResourceDocumentation("A trust manager definition for creating the TrustManager[] as used to create an SSLContext.")
		@SubresourceInfo("trustManager")
		private List<TrustManager> trustManagers = new java.util.ArrayList<>();
		/**
		 * A SaslServerFactory definition that wraps another SaslServerFactory
		 * and enables filtering of mechanisms based on the mechanism name and
		 * Provider name and version. Any mechanisms loaded by factories not
		 * located using a Provider will not be filtered by this definition.
		 */
		@ResourceDocumentation("A SaslServerFactory definition that wraps another SaslServerFactory and enables filtering of mechanisms based on the mechanism name and Provider name and version. Any mechanisms loaded by factories not located using a Provider will not be filtered by this definition.")
		@SubresourceInfo("mechanismProviderFilteringSaslServerFactory")
		private List<MechanismProviderFilteringSASLServerFactory> mechanismProviderFilteringSaslServerFactories = new java.util.ArrayList<>();
		/**
		 * A security realm definition backed by LDAP.
		 */
		@ResourceDocumentation("A security realm definition backed by LDAP.")
		@SubresourceInfo("ldapRealm")
		private List<LdapRealm> ldapRealms = new java.util.ArrayList<>();
		/**
		 * An aggregation of two or more Provider[] resources.
		 */
		@ResourceDocumentation("An aggregation of two or more Provider[] resources.")
		@SubresourceInfo("aggregateProviders")
		private List<AggregateProviders> aggregateProviders = new java.util.ArrayList<>();
		/**
		 * A KeyStore definition.
		 */
		@ResourceDocumentation("A KeyStore definition.")
		@SubresourceInfo("keyStore")
		private List<KeyStore> keyStores = new java.util.ArrayList<>();
		/**
		 * Resource containing the association of a SecurityDomain with a
		 * HttpServerAuthenticationMechanismFactory.
		 */
		@ResourceDocumentation("Resource containing the association of a SecurityDomain with a HttpServerAuthenticationMechanismFactory.")
		@SubresourceInfo("httpAuthenticationFactory")
		private List<HTTPAuthenticationFactory> httpAuthenticationFactories = new java.util.ArrayList<>();
		/**
		 * A sasl server factory definition where the sasl server factory is an
		 * aggregation of other sasl server factories.
		 */
		@ResourceDocumentation("A sasl server factory definition where the sasl server factory is an aggregation of other sasl server factories.")
		@SubresourceInfo("aggregateSaslServerFactory")
		private List<AggregateSASLServerFactory> aggregateSaslServerFactories = new java.util.ArrayList<>();
		/**
		 * Definition of a simple RealmMapper that attempts to extract the realm
		 * name using the capture group from the regular expression, if that
		 * does not provide a match then the delegate RealmMapper is used
		 * instead.
		 */
		@ResourceDocumentation("Definition of a simple RealmMapper that attempts to extract the realm name using the capture group from the regular expression, if that does not provide a match then the delegate RealmMapper is used instead.")
		@SubresourceInfo("simpleRegexRealmMapper")
		private List<SimpleRegexRealmMapper> simpleRegexRealmMappers = new java.util.ArrayList<>();
		/**
		 * A realm definition that enables caching to another security realm.
		 * Caching strategy is LRU (Least Recently Used) where least accessed
		 * entries are discarded when maximum number of entries is reached.
		 */
		@ResourceDocumentation("A realm definition that enables caching to another security realm. Caching strategy is LRU (Least Recently Used) where least accessed entries are discarded when maximum number of entries is reached.")
		@SubresourceInfo("cachingRealm")
		private List<CachingRealm> cachingRealms = new java.util.ArrayList<>();
		/**
		 * A key manager definition for creating the KeyManager as used to
		 * create an SSLContext.
		 */
		@ResourceDocumentation("A key manager definition for creating the KeyManager as used to create an SSLContext.")
		@SubresourceInfo("keyManager")
		private List<KeyManager> keyManagers = new java.util.ArrayList<>();
		/**
		 * An SSLContext for use on the server side of a connection.
		 */
		@ResourceDocumentation("An SSLContext for use on the server side of a connection.")
		@SubresourceInfo("serverSslContext")
		private List<ServerSslContext> serverSslContexts = new java.util.ArrayList<>();
		/**
		 * A role mapper definition for a role mapper that adds a suffix to each
		 * provided.
		 */
		@ResourceDocumentation("A role mapper definition for a role mapper that adds a suffix to each provided.")
		@SubresourceInfo("addSuffixRoleMapper")
		private List<AddSuffixRoleMapper> addSuffixRoleMappers = new java.util.ArrayList<>();
		/**
		 * A custom security event listener. (Audit logger for example.)
		 */
		@ResourceDocumentation("A custom security event listener. (Audit logger for example.)")
		@SubresourceInfo("customSecurityEventListener")
		private List<CustomSecurityEventListener> customSecurityEventListeners = new java.util.ArrayList<>();
		/**
		 * Definition of a custom permission mapper.
		 */
		@ResourceDocumentation("Definition of a custom permission mapper.")
		@SubresourceInfo("customPermissionMapper")
		private List<CustomPermissionMapper> customPermissionMappers = new java.util.ArrayList<>();
		/**
		 * A principal decoder definition where the principal decoder is a
		 * concatenation of other principal decoders.
		 */
		@ResourceDocumentation("A principal decoder definition where the principal decoder is a concatenation of other principal decoders.")
		@SubresourceInfo("concatenatingPrincipalDecoder")
		private List<ConcatenatingPrincipalDecoder> concatenatingPrincipalDecoders = new java.util.ArrayList<>();

		/**
		 * Get the list of CustomPrincipalTransformer resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<CustomPrincipalTransformer> customPrincipalTransformers() {
			return this.customPrincipalTransformers;
		}

		public CustomPrincipalTransformer customPrincipalTransformer(
				java.lang.String key) {
			return this.customPrincipalTransformers.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of ConstantPrincipalDecoder resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ConstantPrincipalDecoder> constantPrincipalDecoders() {
			return this.constantPrincipalDecoders;
		}

		public ConstantPrincipalDecoder constantPrincipalDecoder(
				java.lang.String key) {
			return this.constantPrincipalDecoders.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of AggregateRealm resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<AggregateRealm> aggregateRealms() {
			return this.aggregateRealms;
		}

		public AggregateRealm aggregateRealm(java.lang.String key) {
			return this.aggregateRealms.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of CustomRoleMapper resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<CustomRoleMapper> customRoleMappers() {
			return this.customRoleMappers;
		}

		public CustomRoleMapper customRoleMapper(java.lang.String key) {
			return this.customRoleMappers.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of FilesystemRealm resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<FilesystemRealm> filesystemRealms() {
			return this.filesystemRealms;
		}

		public FilesystemRealm filesystemRealm(java.lang.String key) {
			return this.filesystemRealms.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of CertificateAuthorityAccount resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<CertificateAuthorityAccount> certificateAuthorityAccounts() {
			return this.certificateAuthorityAccounts;
		}

		public CertificateAuthorityAccount certificateAuthorityAccount(
				java.lang.String key) {
			return this.certificateAuthorityAccounts.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of LogicalPermissionMapper resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<LogicalPermissionMapper> logicalPermissionMappers() {
			return this.logicalPermissionMappers;
		}

		public LogicalPermissionMapper logicalPermissionMapper(
				java.lang.String key) {
			return this.logicalPermissionMappers.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of ConstantPrincipalTransformer resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ConstantPrincipalTransformer> constantPrincipalTransformers() {
			return this.constantPrincipalTransformers;
		}

		public ConstantPrincipalTransformer constantPrincipalTransformer(
				java.lang.String key) {
			return this.constantPrincipalTransformers.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of CustomRealm resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<CustomRealm> customRealms() {
			return this.customRealms;
		}

		public CustomRealm customRealm(java.lang.String key) {
			return this.customRealms.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of SASLAuthenticationFactory resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<SASLAuthenticationFactory> saslAuthenticationFactories() {
			return this.saslAuthenticationFactories;
		}

		public SASLAuthenticationFactory saslAuthenticationFactory(
				java.lang.String key) {
			return this.saslAuthenticationFactories.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of ServiceLoaderHTTPServerMechanismFactory resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ServiceLoaderHTTPServerMechanismFactory> serviceLoaderHttpServerMechanismFactories() {
			return this.serviceLoaderHttpServerMechanismFactories;
		}

		public ServiceLoaderHTTPServerMechanismFactory serviceLoaderHttpServerMechanismFactory(
				java.lang.String key) {
			return this.serviceLoaderHttpServerMechanismFactories.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of JDBCRealm resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<JDBCRealm> jdbcRealms() {
			return this.jdbcRealms;
		}

		public JDBCRealm jdbcRealm(java.lang.String key) {
			return this.jdbcRealms.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
		/**
		 * Get the list of JaspiConfiguration resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<JaspiConfiguration> jaspiConfigurations() {
			return this.jaspiConfigurations;
		}

		public JaspiConfiguration jaspiConfiguration(java.lang.String key) {
			return this.jaspiConfigurations.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of CustomRoleDecoder resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<CustomRoleDecoder> customRoleDecoders() {
			return this.customRoleDecoders;
		}

		public CustomRoleDecoder customRoleDecoder(java.lang.String key) {
			return this.customRoleDecoders.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of CredentialStore resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<CredentialStore> credentialStores() {
			return this.credentialStores;
		}

		public CredentialStore credentialStore(java.lang.String key) {
			return this.credentialStores.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of KerberosSecurityFactory resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<KerberosSecurityFactory> kerberosSecurityFactories() {
			return this.kerberosSecurityFactories;
		}

		public KerberosSecurityFactory kerberosSecurityFactory(
				java.lang.String key) {
			return this.kerberosSecurityFactories.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of ConfigurableHTTPServerMechanismFactory resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ConfigurableHTTPServerMechanismFactory> configurableHttpServerMechanismFactories() {
			return this.configurableHttpServerMechanismFactories;
		}

		public ConfigurableHTTPServerMechanismFactory configurableHttpServerMechanismFactory(
				java.lang.String key) {
			return this.configurableHttpServerMechanismFactories.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of ProviderHTTPServerMechanismFactory resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ProviderHTTPServerMechanismFactory> providerHttpServerMechanismFactories() {
			return this.providerHttpServerMechanismFactories;
		}

		public ProviderHTTPServerMechanismFactory providerHttpServerMechanismFactory(
				java.lang.String key) {
			return this.providerHttpServerMechanismFactories.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of LogicalRoleMapper resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<LogicalRoleMapper> logicalRoleMappers() {
			return this.logicalRoleMappers;
		}

		public LogicalRoleMapper logicalRoleMapper(java.lang.String key) {
			return this.logicalRoleMappers.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of AggregateRoleMapper resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<AggregateRoleMapper> aggregateRoleMappers() {
			return this.aggregateRoleMappers;
		}

		public AggregateRoleMapper aggregateRoleMapper(java.lang.String key) {
			return this.aggregateRoleMappers.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of ProviderLoader resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ProviderLoader> providerLoaders() {
			return this.providerLoaders;
		}

		public ProviderLoader providerLoader(java.lang.String key) {
			return this.providerLoaders.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of CustomPrincipalDecoder resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<CustomPrincipalDecoder> customPrincipalDecoders() {
			return this.customPrincipalDecoders;
		}

		public CustomPrincipalDecoder customPrincipalDecoder(
				java.lang.String key) {
			return this.customPrincipalDecoders.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of SizeRotatingFileAuditLog resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<SizeRotatingFileAuditLog> sizeRotatingFileAuditLogs() {
			return this.sizeRotatingFileAuditLogs;
		}

		public SizeRotatingFileAuditLog sizeRotatingFileAuditLog(
				java.lang.String key) {
			return this.sizeRotatingFileAuditLogs.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of ConstantPermissionMapper resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ConstantPermissionMapper> constantPermissionMappers() {
			return this.constantPermissionMappers;
		}

		public ConstantPermissionMapper constantPermissionMapper(
				java.lang.String key) {
			return this.constantPermissionMappers.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of TokenRealm resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<TokenRealm> tokenRealms() {
			return this.tokenRealms;
		}

		public TokenRealm tokenRealm(java.lang.String key) {
			return this.tokenRealms.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of ClientSslContext resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ClientSslContext> clientSslContexts() {
			return this.clientSslContexts;
		}

		public ClientSslContext clientSslContext(java.lang.String key) {
			return this.clientSslContexts.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of SecurityDomain resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<SecurityDomain> securityDomains() {
			return this.securityDomains;
		}

		public SecurityDomain securityDomain(java.lang.String key) {
			return this.securityDomains.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of ConstantRoleMapper resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ConstantRoleMapper> constantRoleMappers() {
			return this.constantRoleMappers;
		}

		public ConstantRoleMapper constantRoleMapper(java.lang.String key) {
			return this.constantRoleMappers.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of IdentityRealm resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<IdentityRealm> identityRealms() {
			return this.identityRealms;
		}

		public IdentityRealm identityRealm(java.lang.String key) {
			return this.identityRealms.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of FilteringKeyStore resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<FilteringKeyStore> filteringKeyStores() {
			return this.filteringKeyStores;
		}

		public FilteringKeyStore filteringKeyStore(java.lang.String key) {
			return this.filteringKeyStores.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of PropertiesRealm resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<PropertiesRealm> propertiesRealms() {
			return this.propertiesRealms;
		}

		public PropertiesRealm propertiesRealm(java.lang.String key) {
			return this.propertiesRealms.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of AggregatePrincipalDecoder resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<AggregatePrincipalDecoder> aggregatePrincipalDecoders() {
			return this.aggregatePrincipalDecoders;
		}

		public AggregatePrincipalDecoder aggregatePrincipalDecoder(
				java.lang.String key) {
			return this.aggregatePrincipalDecoders.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of AggregatePrincipalTransformer resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<AggregatePrincipalTransformer> aggregatePrincipalTransformers() {
			return this.aggregatePrincipalTransformers;
		}

		public AggregatePrincipalTransformer aggregatePrincipalTransformer(
				java.lang.String key) {
			return this.aggregatePrincipalTransformers.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of ServerSslSniContext resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ServerSslSniContext> serverSslSniContexts() {
			return this.serverSslSniContexts;
		}

		public ServerSslSniContext serverSslSniContext(java.lang.String key) {
			return this.serverSslSniContexts.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of CustomCredentialSecurityFactory resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<CustomCredentialSecurityFactory> customCredentialSecurityFactories() {
			return this.customCredentialSecurityFactories;
		}

		public CustomCredentialSecurityFactory customCredentialSecurityFactory(
				java.lang.String key) {
			return this.customCredentialSecurityFactories.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of PeriodicRotatingFileAuditLog resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<PeriodicRotatingFileAuditLog> periodicRotatingFileAuditLogs() {
			return this.periodicRotatingFileAuditLogs;
		}

		public PeriodicRotatingFileAuditLog periodicRotatingFileAuditLog(
				java.lang.String key) {
			return this.periodicRotatingFileAuditLogs.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of SimplePermissionMapper resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<SimplePermissionMapper> simplePermissionMappers() {
			return this.simplePermissionMappers;
		}

		public SimplePermissionMapper simplePermissionMapper(
				java.lang.String key) {
			return this.simplePermissionMappers.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of MappedRoleMapper resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<MappedRoleMapper> mappedRoleMappers() {
			return this.mappedRoleMappers;
		}

		public MappedRoleMapper mappedRoleMapper(java.lang.String key) {
			return this.mappedRoleMappers.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of ConstantRealmMapper resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ConstantRealmMapper> constantRealmMappers() {
			return this.constantRealmMappers;
		}

		public ConstantRealmMapper constantRealmMapper(java.lang.String key) {
			return this.constantRealmMappers.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of SimpleRoleDecoder resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<SimpleRoleDecoder> simpleRoleDecoders() {
			return this.simpleRoleDecoders;
		}

		public SimpleRoleDecoder simpleRoleDecoder(java.lang.String key) {
			return this.simpleRoleDecoders.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of ConfigurableSASLServerFactory resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ConfigurableSASLServerFactory> configurableSaslServerFactories() {
			return this.configurableSaslServerFactories;
		}

		public ConfigurableSASLServerFactory configurableSaslServerFactory(
				java.lang.String key) {
			return this.configurableSaslServerFactories.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of RegexValidatingPrincipalTransformer resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<RegexValidatingPrincipalTransformer> regexValidatingPrincipalTransformers() {
			return this.regexValidatingPrincipalTransformers;
		}

		public RegexValidatingPrincipalTransformer regexValidatingPrincipalTransformer(
				java.lang.String key) {
			return this.regexValidatingPrincipalTransformers.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of ServiceLoaderSASLServerFactory resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ServiceLoaderSASLServerFactory> serviceLoaderSaslServerFactories() {
			return this.serviceLoaderSaslServerFactories;
		}

		public ServiceLoaderSASLServerFactory serviceLoaderSaslServerFactory(
				java.lang.String key) {
			return this.serviceLoaderSaslServerFactories.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of PermissionSet resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<PermissionSet> permissionSets() {
			return this.permissionSets;
		}

		public PermissionSet permissionSet(java.lang.String key) {
			return this.permissionSets.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of LdapKeyStore resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<LdapKeyStore> ldapKeyStores() {
			return this.ldapKeyStores;
		}

		public LdapKeyStore ldapKeyStore(java.lang.String key) {
			return this.ldapKeyStores.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of X500AttributePrincipalDecoder resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<X500AttributePrincipalDecoder> x500AttributePrincipalDecoders() {
			return this.x500AttributePrincipalDecoders;
		}

		public X500AttributePrincipalDecoder x500AttributePrincipalDecoder(
				java.lang.String key) {
			return this.x500AttributePrincipalDecoders.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of DirContext resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<DirContext> dirContexts() {
			return this.dirContexts;
		}

		public DirContext dirContext(java.lang.String key) {
			return this.dirContexts.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of MappedRegexRealmMapper resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<MappedRegexRealmMapper> mappedRegexRealmMappers() {
			return this.mappedRegexRealmMappers;
		}

		public MappedRegexRealmMapper mappedRegexRealmMapper(
				java.lang.String key) {
			return this.mappedRegexRealmMappers.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of SyslogAuditLog resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<SyslogAuditLog> syslogAuditLogs() {
			return this.syslogAuditLogs;
		}

		public SyslogAuditLog syslogAuditLog(java.lang.String key) {
			return this.syslogAuditLogs.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of AggregateSecurityEventListener resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<AggregateSecurityEventListener> aggregateSecurityEventListeners() {
			return this.aggregateSecurityEventListeners;
		}

		public AggregateSecurityEventListener aggregateSecurityEventListener(
				java.lang.String key) {
			return this.aggregateSecurityEventListeners.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of ChainedPrincipalTransformer resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ChainedPrincipalTransformer> chainedPrincipalTransformers() {
			return this.chainedPrincipalTransformers;
		}

		public ChainedPrincipalTransformer chainedPrincipalTransformer(
				java.lang.String key) {
			return this.chainedPrincipalTransformers.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of AuthenticationContext resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<AuthenticationContext> authenticationContexts() {
			return this.authenticationContexts;
		}

		public AuthenticationContext authenticationContext(java.lang.String key) {
			return this.authenticationContexts.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of FileAuditLog resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<FileAuditLog> fileAuditLogs() {
			return this.fileAuditLogs;
		}

		public FileAuditLog fileAuditLog(java.lang.String key) {
			return this.fileAuditLogs.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of KeyStoreRealm resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<KeyStoreRealm> keyStoreRealms() {
			return this.keyStoreRealms;
		}

		public KeyStoreRealm keyStoreRealm(java.lang.String key) {
			return this.keyStoreRealms.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of Policy resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<Policy> policies() {
			return this.policies;
		}

		public Policy policy(java.lang.String key) {
			return this.policies.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
		/**
		 * Get the list of AuthenticationConfiguration resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<AuthenticationConfiguration> authenticationConfigurations() {
			return this.authenticationConfigurations;
		}

		public AuthenticationConfiguration authenticationConfiguration(
				java.lang.String key) {
			return this.authenticationConfigurations.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of ProviderSASLServerFactory resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ProviderSASLServerFactory> providerSaslServerFactories() {
			return this.providerSaslServerFactories;
		}

		public ProviderSASLServerFactory providerSaslServerFactory(
				java.lang.String key) {
			return this.providerSaslServerFactories.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of CustomModifiableRealm resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<CustomModifiableRealm> customModifiableRealms() {
			return this.customModifiableRealms;
		}

		public CustomModifiableRealm customModifiableRealm(java.lang.String key) {
			return this.customModifiableRealms.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of AddPrefixRoleMapper resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<AddPrefixRoleMapper> addPrefixRoleMappers() {
			return this.addPrefixRoleMappers;
		}

		public AddPrefixRoleMapper addPrefixRoleMapper(java.lang.String key) {
			return this.addPrefixRoleMappers.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of AggregateHTTPServerMechanismFactory resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<AggregateHTTPServerMechanismFactory> aggregateHttpServerMechanismFactories() {
			return this.aggregateHttpServerMechanismFactories;
		}

		public AggregateHTTPServerMechanismFactory aggregateHttpServerMechanismFactory(
				java.lang.String key) {
			return this.aggregateHttpServerMechanismFactories.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of CustomRealmMapper resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<CustomRealmMapper> customRealmMappers() {
			return this.customRealmMappers;
		}

		public CustomRealmMapper customRealmMapper(java.lang.String key) {
			return this.customRealmMappers.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of RegexPrincipalTransformer resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<RegexPrincipalTransformer> regexPrincipalTransformers() {
			return this.regexPrincipalTransformers;
		}

		public RegexPrincipalTransformer regexPrincipalTransformer(
				java.lang.String key) {
			return this.regexPrincipalTransformers.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of TrustManager resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<TrustManager> trustManagers() {
			return this.trustManagers;
		}

		public TrustManager trustManager(java.lang.String key) {
			return this.trustManagers.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of MechanismProviderFilteringSASLServerFactory resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<MechanismProviderFilteringSASLServerFactory> mechanismProviderFilteringSaslServerFactories() {
			return this.mechanismProviderFilteringSaslServerFactories;
		}

		public MechanismProviderFilteringSASLServerFactory mechanismProviderFilteringSaslServerFactory(
				java.lang.String key) {
			return this.mechanismProviderFilteringSaslServerFactories.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of LdapRealm resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<LdapRealm> ldapRealms() {
			return this.ldapRealms;
		}

		public LdapRealm ldapRealm(java.lang.String key) {
			return this.ldapRealms.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
		/**
		 * Get the list of AggregateProviders resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<AggregateProviders> aggregateProviders() {
			return this.aggregateProviders;
		}

		public AggregateProviders aggregateProviders(java.lang.String key) {
			return this.aggregateProviders.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of KeyStore resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<KeyStore> keyStores() {
			return this.keyStores;
		}

		public KeyStore keyStore(java.lang.String key) {
			return this.keyStores.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
		/**
		 * Get the list of HTTPAuthenticationFactory resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<HTTPAuthenticationFactory> httpAuthenticationFactories() {
			return this.httpAuthenticationFactories;
		}

		public HTTPAuthenticationFactory httpAuthenticationFactory(
				java.lang.String key) {
			return this.httpAuthenticationFactories.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of AggregateSASLServerFactory resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<AggregateSASLServerFactory> aggregateSaslServerFactories() {
			return this.aggregateSaslServerFactories;
		}

		public AggregateSASLServerFactory aggregateSaslServerFactory(
				java.lang.String key) {
			return this.aggregateSaslServerFactories.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of SimpleRegexRealmMapper resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<SimpleRegexRealmMapper> simpleRegexRealmMappers() {
			return this.simpleRegexRealmMappers;
		}

		public SimpleRegexRealmMapper simpleRegexRealmMapper(
				java.lang.String key) {
			return this.simpleRegexRealmMappers.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of CachingRealm resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<CachingRealm> cachingRealms() {
			return this.cachingRealms;
		}

		public CachingRealm cachingRealm(java.lang.String key) {
			return this.cachingRealms.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of KeyManager resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<KeyManager> keyManagers() {
			return this.keyManagers;
		}

		public KeyManager keyManager(java.lang.String key) {
			return this.keyManagers.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of ServerSslContext resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ServerSslContext> serverSslContexts() {
			return this.serverSslContexts;
		}

		public ServerSslContext serverSslContext(java.lang.String key) {
			return this.serverSslContexts.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of AddSuffixRoleMapper resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<AddSuffixRoleMapper> addSuffixRoleMappers() {
			return this.addSuffixRoleMappers;
		}

		public AddSuffixRoleMapper addSuffixRoleMapper(java.lang.String key) {
			return this.addSuffixRoleMappers.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of CustomSecurityEventListener resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<CustomSecurityEventListener> customSecurityEventListeners() {
			return this.customSecurityEventListeners;
		}

		public CustomSecurityEventListener customSecurityEventListener(
				java.lang.String key) {
			return this.customSecurityEventListeners.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of CustomPermissionMapper resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<CustomPermissionMapper> customPermissionMappers() {
			return this.customPermissionMappers;
		}

		public CustomPermissionMapper customPermissionMapper(
				java.lang.String key) {
			return this.customPermissionMappers.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of ConcatenatingPrincipalDecoder resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ConcatenatingPrincipalDecoder> concatenatingPrincipalDecoders() {
			return this.concatenatingPrincipalDecoders;
		}

		public ConcatenatingPrincipalDecoder concatenatingPrincipalDecoder(
				java.lang.String key) {
			return this.concatenatingPrincipalDecoders.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
	}

	/**
	 * The default authentication context to be associated with all deployments.
	 */
	@ModelNodeBinding(detypedName = "default-authentication-context")
	public String defaultAuthenticationContext() {
		return this.defaultAuthenticationContext;
	}

	/**
	 * The default authentication context to be associated with all deployments.
	 */
	@SuppressWarnings("unchecked")
	public T defaultAuthenticationContext(java.lang.String value) {
		Object oldValue = this.defaultAuthenticationContext;
		this.defaultAuthenticationContext = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("defaultAuthenticationContext",
					oldValue, value);
		return (T) this;
	}

	/**
	 * Reference to the SSLContext which should be globally registered as the
	 * default.
	 */
	@ModelNodeBinding(detypedName = "default-ssl-context")
	public String defaultSslContext() {
		return this.defaultSslContext;
	}

	/**
	 * Reference to the SSLContext which should be globally registered as the
	 * default.
	 */
	@SuppressWarnings("unchecked")
	public T defaultSslContext(java.lang.String value) {
		Object oldValue = this.defaultSslContext;
		this.defaultSslContext = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("defaultSslContext", oldValue, value);
		return (T) this;
	}

	/**
	 * A list of providers that are not allowed, and will be removed from the
	 * providers list.
	 */
	@ModelNodeBinding(detypedName = "disallowed-providers")
	public List<String> disallowedProviders() {
		return this.disallowedProviders;
	}

	/**
	 * A list of providers that are not allowed, and will be removed from the
	 * providers list.
	 */
	@SuppressWarnings("unchecked")
	public T disallowedProviders(java.util.List<String> value) {
		Object oldValue = this.disallowedProviders;
		this.disallowedProviders = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("disallowedProviders", oldValue, value);
		return (T) this;
	}

	/**
	 * A list of providers that are not allowed, and will be removed from the
	 * providers list.
	 */
	@SuppressWarnings("unchecked")
	public T disallowedProvider(String value) {
		if (this.disallowedProviders == null) {
			this.disallowedProviders = new java.util.ArrayList<>();
		}
		this.disallowedProviders.add(value);
		return (T) this;
	}

	/**
	 * A list of providers that are not allowed, and will be removed from the
	 * providers list.
	 */
	@SuppressWarnings("unchecked")
	public T disallowedProviders(String... args) {
		disallowedProviders(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}

	/**
	 * Reference to the Providers that should be registered after all existing
	 * Providers.
	 */
	@ModelNodeBinding(detypedName = "final-providers")
	public String finalProviders() {
		return this.finalProviders;
	}

	/**
	 * Reference to the Providers that should be registered after all existing
	 * Providers.
	 */
	@SuppressWarnings("unchecked")
	public T finalProviders(java.lang.String value) {
		Object oldValue = this.finalProviders;
		this.finalProviders = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("finalProviders", oldValue, value);
		return (T) this;
	}

	/**
	 * Reference to the Providers that should be registered ahead of all
	 * existing Providers.
	 */
	@ModelNodeBinding(detypedName = "initial-providers")
	public String initialProviders() {
		return this.initialProviders;
	}

	/**
	 * Reference to the Providers that should be registered ahead of all
	 * existing Providers.
	 */
	@SuppressWarnings("unchecked")
	public T initialProviders(java.lang.String value) {
		Object oldValue = this.initialProviders;
		this.initialProviders = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("initialProviders", oldValue, value);
		return (T) this;
	}

	/**
	 * Should the Elytron JASPI factory be globally registered?
	 */
	@ModelNodeBinding(detypedName = "register-jaspi-factory")
	public Boolean registerJaspiFactory() {
		return this.registerJaspiFactory;
	}

	/**
	 * Should the Elytron JASPI factory be globally registered?
	 */
	@SuppressWarnings("unchecked")
	public T registerJaspiFactory(java.lang.Boolean value) {
		Object oldValue = this.registerJaspiFactory;
		this.registerJaspiFactory = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("registerJaspiFactory", oldValue, value);
		return (T) this;
	}

	/**
	 * Security properties to be set.
	 */
	@ModelNodeBinding(detypedName = "security-properties")
	public Map securityProperties() {
		return this.securityProperties;
	}

	/**
	 * Security properties to be set.
	 */
	@SuppressWarnings("unchecked")
	public T securityProperties(java.util.Map value) {
		Object oldValue = this.securityProperties;
		this.securityProperties = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("securityProperties", oldValue, value);
		return (T) this;
	}

	/**
	 * Security properties to be set.
	 */
	@SuppressWarnings("unchecked")
	public T securityProperty(java.lang.String key, java.lang.Object value) {
		if (this.securityProperties == null) {
			this.securityProperties = new java.util.HashMap<>();
		}
		this.securityProperties.put(key, value);
		return (T) this;
	}
}