package org.wildfly.swarm.config;

import org.wildfly.swarm.config.JCA;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface JCAConsumer<T extends JCA<T>> {

	/**
	 * Configure a pre-constructed instance of JCA resource
	 * 
	 * @parameter Instance of JCA to configure
	 * @return nothing
	 */
	void accept(T value);

	default JCAConsumer<T> andThen(JCAConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}