package org.wildfly.swarm.config;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.jmx.ResolvedExposeModel;
import org.wildfly.swarm.config.jmx.ResolvedExposeModelConsumer;
import org.wildfly.swarm.config.jmx.ResolvedExposeModelSupplier;
import org.wildfly.swarm.config.jmx.AuditLogConfiguration;
import org.wildfly.swarm.config.jmx.AuditLogConfigurationConsumer;
import org.wildfly.swarm.config.jmx.AuditLogConfigurationSupplier;
import org.wildfly.swarm.config.jmx.JMXRemotingConnector;
import org.wildfly.swarm.config.jmx.JMXRemotingConnectorConsumer;
import org.wildfly.swarm.config.jmx.JMXRemotingConnectorSupplier;
import org.wildfly.swarm.config.jmx.ExpressionExposeModel;
import org.wildfly.swarm.config.jmx.ExpressionExposeModelConsumer;
import org.wildfly.swarm.config.jmx.ExpressionExposeModelSupplier;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * The configuration of the JMX subsystem.
 */
@Address("/subsystem=jmx")
@ResourceType("subsystem")
@Implicit
public class JMX<T extends JMX<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private JMXResources subresources = new JMXResources();
	@AttributeDocumentation("Whether or not core MBeans, i.e. mbeans not coming from the model controller, should be considered sensitive.")
	private Boolean nonCoreMbeanSensitivity;
	@AttributeDocumentation("Alias for the existence of the 'resolved' model controller jmx facade. When writing, if set to 'true' it will add the 'resolved' model controller jmx facade resource with the default domain name.")
	private Boolean showModel;

	public JMX() {
		super();
		this.key = "jmx";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public JMXResources subresources() {
		return this.subresources;
	}

	/**
	 * The configuration for exposing the 'resolved' model controller in the
	 * MBeanServer. This facade will expose all simple attributes and operation
	 * parameters as their type in the underlying model. Reads return the
	 * resolved expression if used, or the raw value. You may not use
	 * expressions when writing attributes and setting operation parameters.
	 */
	@SuppressWarnings("unchecked")
	public T resolvedExposeModel(ResolvedExposeModel value) {
		this.subresources.resolvedExposeModel = value;
		return (T) this;
	}

	/**
	 * The configuration for exposing the 'resolved' model controller in the
	 * MBeanServer. This facade will expose all simple attributes and operation
	 * parameters as their type in the underlying model. Reads return the
	 * resolved expression if used, or the raw value. You may not use
	 * expressions when writing attributes and setting operation parameters.
	 */
	@SuppressWarnings("unchecked")
	public T resolvedExposeModel(ResolvedExposeModelConsumer consumer) {
		ResolvedExposeModel<? extends ResolvedExposeModel> child = new ResolvedExposeModel<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.resolvedExposeModel = child;
		return (T) this;
	}

	/**
	 * The configuration for exposing the 'resolved' model controller in the
	 * MBeanServer. This facade will expose all simple attributes and operation
	 * parameters as their type in the underlying model. Reads return the
	 * resolved expression if used, or the raw value. You may not use
	 * expressions when writing attributes and setting operation parameters.
	 */
	@SuppressWarnings("unchecked")
	public T resolvedExposeModel() {
		ResolvedExposeModel<? extends ResolvedExposeModel> child = new ResolvedExposeModel<>();
		this.subresources.resolvedExposeModel = child;
		return (T) this;
	}

	/**
	 * The configuration for exposing the 'resolved' model controller in the
	 * MBeanServer. This facade will expose all simple attributes and operation
	 * parameters as their type in the underlying model. Reads return the
	 * resolved expression if used, or the raw value. You may not use
	 * expressions when writing attributes and setting operation parameters.
	 */
	@SuppressWarnings("unchecked")
	public T resolvedExposeModel(ResolvedExposeModelSupplier supplier) {
		this.subresources.resolvedExposeModel = supplier.get();
		return (T) this;
	}

	/**
	 * The management audit logging top-level resource.
	 */
	@SuppressWarnings("unchecked")
	public T auditLogConfiguration(AuditLogConfiguration value) {
		this.subresources.auditLogConfiguration = value;
		return (T) this;
	}

	/**
	 * The management audit logging top-level resource.
	 */
	@SuppressWarnings("unchecked")
	public T auditLogConfiguration(AuditLogConfigurationConsumer consumer) {
		AuditLogConfiguration<? extends AuditLogConfiguration> child = new AuditLogConfiguration<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.auditLogConfiguration = child;
		return (T) this;
	}

	/**
	 * The management audit logging top-level resource.
	 */
	@SuppressWarnings("unchecked")
	public T auditLogConfiguration() {
		AuditLogConfiguration<? extends AuditLogConfiguration> child = new AuditLogConfiguration<>();
		this.subresources.auditLogConfiguration = child;
		return (T) this;
	}

	/**
	 * The management audit logging top-level resource.
	 */
	@SuppressWarnings("unchecked")
	public T auditLogConfiguration(AuditLogConfigurationSupplier supplier) {
		this.subresources.auditLogConfiguration = supplier.get();
		return (T) this;
	}

	/**
	 * A JBoss remoting connector for the JMX subsystem.
	 */
	@SuppressWarnings("unchecked")
	public T jmxRemotingConnector(JMXRemotingConnector value) {
		this.subresources.jmxRemotingConnector = value;
		return (T) this;
	}

	/**
	 * A JBoss remoting connector for the JMX subsystem.
	 */
	@SuppressWarnings("unchecked")
	public T jmxRemotingConnector(JMXRemotingConnectorConsumer consumer) {
		JMXRemotingConnector<? extends JMXRemotingConnector> child = new JMXRemotingConnector<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.jmxRemotingConnector = child;
		return (T) this;
	}

	/**
	 * A JBoss remoting connector for the JMX subsystem.
	 */
	@SuppressWarnings("unchecked")
	public T jmxRemotingConnector() {
		JMXRemotingConnector<? extends JMXRemotingConnector> child = new JMXRemotingConnector<>();
		this.subresources.jmxRemotingConnector = child;
		return (T) this;
	}

	/**
	 * A JBoss remoting connector for the JMX subsystem.
	 */
	@SuppressWarnings("unchecked")
	public T jmxRemotingConnector(JMXRemotingConnectorSupplier supplier) {
		this.subresources.jmxRemotingConnector = supplier.get();
		return (T) this;
	}

	/**
	 * The configuration for exposing the 'expression' model controller in the
	 * MBeanServer. This facade will expose all simple attributes and operation
	 * parameters as String. Reads return the unresolved expression. You may use
	 * expressions when writing attributes and setting operation parameters.
	 */
	@SuppressWarnings("unchecked")
	public T expressionExposeModel(ExpressionExposeModel value) {
		this.subresources.expressionExposeModel = value;
		return (T) this;
	}

	/**
	 * The configuration for exposing the 'expression' model controller in the
	 * MBeanServer. This facade will expose all simple attributes and operation
	 * parameters as String. Reads return the unresolved expression. You may use
	 * expressions when writing attributes and setting operation parameters.
	 */
	@SuppressWarnings("unchecked")
	public T expressionExposeModel(ExpressionExposeModelConsumer consumer) {
		ExpressionExposeModel<? extends ExpressionExposeModel> child = new ExpressionExposeModel<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.expressionExposeModel = child;
		return (T) this;
	}

	/**
	 * The configuration for exposing the 'expression' model controller in the
	 * MBeanServer. This facade will expose all simple attributes and operation
	 * parameters as String. Reads return the unresolved expression. You may use
	 * expressions when writing attributes and setting operation parameters.
	 */
	@SuppressWarnings("unchecked")
	public T expressionExposeModel() {
		ExpressionExposeModel<? extends ExpressionExposeModel> child = new ExpressionExposeModel<>();
		this.subresources.expressionExposeModel = child;
		return (T) this;
	}

	/**
	 * The configuration for exposing the 'expression' model controller in the
	 * MBeanServer. This facade will expose all simple attributes and operation
	 * parameters as String. Reads return the unresolved expression. You may use
	 * expressions when writing attributes and setting operation parameters.
	 */
	@SuppressWarnings("unchecked")
	public T expressionExposeModel(ExpressionExposeModelSupplier supplier) {
		this.subresources.expressionExposeModel = supplier.get();
		return (T) this;
	}

	/**
	 * Child mutators for JMX
	 */
	public static class JMXResources {
		@SingletonResource
		@ResourceDocumentation("The configuration for exposing the 'resolved' model controller in the MBeanServer. This facade will expose all simple attributes and operation parameters as their type in the underlying model. Reads return the resolved expression if used, or the raw value. You may not use expressions when writing attributes and setting operation parameters.")
		private ResolvedExposeModel resolvedExposeModel;
		@SingletonResource
		@ResourceDocumentation("The management audit logging top-level resource.")
		private AuditLogConfiguration auditLogConfiguration;
		@SingletonResource
		@ResourceDocumentation("A JBoss remoting connector for the JMX subsystem.")
		private JMXRemotingConnector jmxRemotingConnector;
		@SingletonResource
		@ResourceDocumentation("The configuration for exposing the 'expression' model controller in the MBeanServer. This facade will expose all simple attributes and operation parameters as String. Reads return the unresolved expression. You may use expressions when writing attributes and setting operation parameters.")
		private ExpressionExposeModel expressionExposeModel;

		/**
		 * The configuration for exposing the 'resolved' model controller in the
		 * MBeanServer. This facade will expose all simple attributes and
		 * operation parameters as their type in the underlying model. Reads
		 * return the resolved expression if used, or the raw value. You may not
		 * use expressions when writing attributes and setting operation
		 * parameters.
		 */
		@Subresource
		public ResolvedExposeModel resolvedExposeModel() {
			return this.resolvedExposeModel;
		}

		/**
		 * The management audit logging top-level resource.
		 */
		@Subresource
		public AuditLogConfiguration auditLogConfiguration() {
			return this.auditLogConfiguration;
		}

		/**
		 * A JBoss remoting connector for the JMX subsystem.
		 */
		@Subresource
		public JMXRemotingConnector jmxRemotingConnector() {
			return this.jmxRemotingConnector;
		}

		/**
		 * The configuration for exposing the 'expression' model controller in
		 * the MBeanServer. This facade will expose all simple attributes and
		 * operation parameters as String. Reads return the unresolved
		 * expression. You may use expressions when writing attributes and
		 * setting operation parameters.
		 */
		@Subresource
		public ExpressionExposeModel expressionExposeModel() {
			return this.expressionExposeModel;
		}
	}

	/**
	 * Whether or not core MBeans, i.e. mbeans not coming from the model
	 * controller, should be considered sensitive.
	 */
	@ModelNodeBinding(detypedName = "non-core-mbean-sensitivity")
	public Boolean nonCoreMbeanSensitivity() {
		return this.nonCoreMbeanSensitivity;
	}

	/**
	 * Whether or not core MBeans, i.e. mbeans not coming from the model
	 * controller, should be considered sensitive.
	 */
	@SuppressWarnings("unchecked")
	public T nonCoreMbeanSensitivity(java.lang.Boolean value) {
		Object oldValue = this.nonCoreMbeanSensitivity;
		this.nonCoreMbeanSensitivity = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("nonCoreMbeanSensitivity", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Alias for the existence of the 'resolved' model controller jmx facade.
	 * When writing, if set to 'true' it will add the 'resolved' model
	 * controller jmx facade resource with the default domain name.
	 */
	@ModelNodeBinding(detypedName = "show-model")
	public Boolean showModel() {
		return this.showModel;
	}

	/**
	 * Alias for the existence of the 'resolved' model controller jmx facade.
	 * When writing, if set to 'true' it will add the 'resolved' model
	 * controller jmx facade resource with the default domain name.
	 */
	@SuppressWarnings("unchecked")
	public T showModel(java.lang.Boolean value) {
		Object oldValue = this.showModel;
		this.showModel = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("showModel", oldValue, value);
		return (T) this;
	}
}