package org.wildfly.swarm.config;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * The JSF subsystem
 */
@Address("/subsystem=jsf")
@ResourceType("subsystem")
@Implicit
public class JSF<T extends JSF<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("Default JSF implementation slot")
	private String defaultJsfImplSlot;
	@AttributeDocumentation("Specifies whether or not DOCTYPE declarations in JSF deployments should be disallowed. This setting can be overridden at the deployment level.")
	private Boolean disallowDoctypeDecl;

	public JSF() {
		super();
		this.key = "jsf";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Default JSF implementation slot
	 */
	@ModelNodeBinding(detypedName = "default-jsf-impl-slot")
	public String defaultJsfImplSlot() {
		return this.defaultJsfImplSlot;
	}

	/**
	 * Default JSF implementation slot
	 */
	@SuppressWarnings("unchecked")
	public T defaultJsfImplSlot(java.lang.String value) {
		Object oldValue = this.defaultJsfImplSlot;
		this.defaultJsfImplSlot = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("defaultJsfImplSlot", oldValue, value);
		return (T) this;
	}

	/**
	 * Specifies whether or not DOCTYPE declarations in JSF deployments should
	 * be disallowed. This setting can be overridden at the deployment level.
	 */
	@ModelNodeBinding(detypedName = "disallow-doctype-decl")
	public Boolean disallowDoctypeDecl() {
		return this.disallowDoctypeDecl;
	}

	/**
	 * Specifies whether or not DOCTYPE declarations in JSF deployments should
	 * be disallowed. This setting can be overridden at the deployment level.
	 */
	@SuppressWarnings("unchecked")
	public T disallowDoctypeDecl(java.lang.Boolean value) {
		Object oldValue = this.disallowDoctypeDecl;
		this.disallowDoctypeDecl = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("disallowDoctypeDecl", oldValue, value);
		return (T) this;
	}
}