package org.wildfly.swarm.config;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.messaging.activemq.DiscoveryGroupConsumer;
import org.wildfly.swarm.config.messaging.activemq.DiscoveryGroupSupplier;
import org.wildfly.swarm.config.messaging.activemq.DiscoveryGroup;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.messaging.activemq.HTTPConnectorConsumer;
import org.wildfly.swarm.config.messaging.activemq.HTTPConnectorSupplier;
import org.wildfly.swarm.config.messaging.activemq.HTTPConnector;
import org.wildfly.swarm.config.messaging.activemq.PooledConnectionFactoryConsumer;
import org.wildfly.swarm.config.messaging.activemq.PooledConnectionFactorySupplier;
import org.wildfly.swarm.config.messaging.activemq.PooledConnectionFactory;
import org.wildfly.swarm.config.messaging.activemq.ServerConsumer;
import org.wildfly.swarm.config.messaging.activemq.ServerSupplier;
import org.wildfly.swarm.config.messaging.activemq.Server;
import org.wildfly.swarm.config.messaging.activemq.ConnectorConsumer;
import org.wildfly.swarm.config.messaging.activemq.ConnectorSupplier;
import org.wildfly.swarm.config.messaging.activemq.Connector;
import org.wildfly.swarm.config.messaging.activemq.ConnectionFactoryConsumer;
import org.wildfly.swarm.config.messaging.activemq.ConnectionFactorySupplier;
import org.wildfly.swarm.config.messaging.activemq.ConnectionFactory;
import org.wildfly.swarm.config.messaging.activemq.RemoteConnectorConsumer;
import org.wildfly.swarm.config.messaging.activemq.RemoteConnectorSupplier;
import org.wildfly.swarm.config.messaging.activemq.RemoteConnector;
import org.wildfly.swarm.config.messaging.activemq.InVMConnectorConsumer;
import org.wildfly.swarm.config.messaging.activemq.InVMConnectorSupplier;
import org.wildfly.swarm.config.messaging.activemq.InVMConnector;
import org.wildfly.swarm.config.messaging.activemq.JMSBridgeConsumer;
import org.wildfly.swarm.config.messaging.activemq.JMSBridgeSupplier;
import org.wildfly.swarm.config.messaging.activemq.JMSBridge;
import org.wildfly.swarm.config.messaging.activemq.ExternalJMSQueueConsumer;
import org.wildfly.swarm.config.messaging.activemq.ExternalJMSQueueSupplier;
import org.wildfly.swarm.config.messaging.activemq.ExternalJMSQueue;
import org.wildfly.swarm.config.messaging.activemq.ExternalJMSTopicConsumer;
import org.wildfly.swarm.config.messaging.activemq.ExternalJMSTopicSupplier;
import org.wildfly.swarm.config.messaging.activemq.ExternalJMSTopic;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * The messaging-activemq subsystem.
 */
@Address("/subsystem=messaging-activemq")
@ResourceType("subsystem")
@Implicit
public class MessagingActiveMQ<T extends MessagingActiveMQ<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private MessagingActiveMQResources subresources = new MessagingActiveMQResources();
	@AttributeDocumentation("Maximum size of the pool of threads used by all ActiveMQ clients running inside this server. If the attribute is undefined (by default), ActiveMQ will configure it to be 8 x the number of available processors.")
	private Integer globalClientScheduledThreadPoolMaxSize;
	@AttributeDocumentation("Maximum size of the pool of scheduled threads used by all ActiveMQ clients running inside this server.")
	private Integer globalClientThreadPoolMaxSize;

	public MessagingActiveMQ() {
		super();
		this.key = "messaging-activemq";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public MessagingActiveMQResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all DiscoveryGroup objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of DiscoveryGroup objects.
	 */
	@SuppressWarnings("unchecked")
	public T discoveryGroups(java.util.List<DiscoveryGroup> value) {
		this.subresources.discoveryGroups = value;
		return (T) this;
	}

	/**
	 * Add the DiscoveryGroup object to the list of subresources
	 * 
	 * @param value
	 *            The DiscoveryGroup to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T discoveryGroup(DiscoveryGroup value) {
		this.subresources.discoveryGroups.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a DiscoveryGroup object to the list of subresources
	 * 
	 * @param key
	 *            The key for the DiscoveryGroup resource
	 * @param config
	 *            The DiscoveryGroupConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T discoveryGroup(java.lang.String childKey,
			DiscoveryGroupConsumer consumer) {
		DiscoveryGroup<? extends DiscoveryGroup> child = new DiscoveryGroup<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		discoveryGroup(child);
		return (T) this;
	}

	/**
	 * Create and configure a DiscoveryGroup object to the list of subresources
	 * 
	 * @param key
	 *            The key for the DiscoveryGroup resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T discoveryGroup(java.lang.String childKey) {
		discoveryGroup(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied DiscoveryGroup object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T discoveryGroup(DiscoveryGroupSupplier supplier) {
		discoveryGroup(supplier.get());
		return (T) this;
	}

	/**
	 * Add all HTTPConnector objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of HTTPConnector objects.
	 */
	@SuppressWarnings("unchecked")
	public T httpConnectors(java.util.List<HTTPConnector> value) {
		this.subresources.httpConnectors = value;
		return (T) this;
	}

	/**
	 * Add the HTTPConnector object to the list of subresources
	 * 
	 * @param value
	 *            The HTTPConnector to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T httpConnector(HTTPConnector value) {
		this.subresources.httpConnectors.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a HTTPConnector object to the list of subresources
	 * 
	 * @param key
	 *            The key for the HTTPConnector resource
	 * @param config
	 *            The HTTPConnectorConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T httpConnector(java.lang.String childKey,
			HTTPConnectorConsumer consumer) {
		HTTPConnector<? extends HTTPConnector> child = new HTTPConnector<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		httpConnector(child);
		return (T) this;
	}

	/**
	 * Create and configure a HTTPConnector object to the list of subresources
	 * 
	 * @param key
	 *            The key for the HTTPConnector resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T httpConnector(java.lang.String childKey) {
		httpConnector(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied HTTPConnector object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T httpConnector(HTTPConnectorSupplier supplier) {
		httpConnector(supplier.get());
		return (T) this;
	}

	/**
	 * Add all PooledConnectionFactory objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of PooledConnectionFactory objects.
	 */
	@SuppressWarnings("unchecked")
	public T pooledConnectionFactories(
			java.util.List<PooledConnectionFactory> value) {
		this.subresources.pooledConnectionFactories = value;
		return (T) this;
	}

	/**
	 * Add the PooledConnectionFactory object to the list of subresources
	 * 
	 * @param value
	 *            The PooledConnectionFactory to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T pooledConnectionFactory(PooledConnectionFactory value) {
		this.subresources.pooledConnectionFactories.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a PooledConnectionFactory object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the PooledConnectionFactory resource
	 * @param config
	 *            The PooledConnectionFactoryConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T pooledConnectionFactory(java.lang.String childKey,
			PooledConnectionFactoryConsumer consumer) {
		PooledConnectionFactory<? extends PooledConnectionFactory> child = new PooledConnectionFactory<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		pooledConnectionFactory(child);
		return (T) this;
	}

	/**
	 * Create and configure a PooledConnectionFactory object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the PooledConnectionFactory resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T pooledConnectionFactory(java.lang.String childKey) {
		pooledConnectionFactory(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied PooledConnectionFactory object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T pooledConnectionFactory(PooledConnectionFactorySupplier supplier) {
		pooledConnectionFactory(supplier.get());
		return (T) this;
	}

	/**
	 * Add all Server objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of Server objects.
	 */
	@SuppressWarnings("unchecked")
	public T servers(java.util.List<Server> value) {
		this.subresources.servers = value;
		return (T) this;
	}

	/**
	 * Add the Server object to the list of subresources
	 * 
	 * @param value
	 *            The Server to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T server(Server value) {
		this.subresources.servers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a Server object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Server resource
	 * @param config
	 *            The ServerConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T server(java.lang.String childKey, ServerConsumer consumer) {
		Server<? extends Server> child = new Server<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		server(child);
		return (T) this;
	}

	/**
	 * Create and configure a Server object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Server resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T server(java.lang.String childKey) {
		server(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied Server object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T server(ServerSupplier supplier) {
		server(supplier.get());
		return (T) this;
	}

	/**
	 * Add all Connector objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of Connector objects.
	 */
	@SuppressWarnings("unchecked")
	public T connectors(java.util.List<Connector> value) {
		this.subresources.connectors = value;
		return (T) this;
	}

	/**
	 * Add the Connector object to the list of subresources
	 * 
	 * @param value
	 *            The Connector to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T connector(Connector value) {
		this.subresources.connectors.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a Connector object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Connector resource
	 * @param config
	 *            The ConnectorConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T connector(java.lang.String childKey, ConnectorConsumer consumer) {
		Connector<? extends Connector> child = new Connector<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		connector(child);
		return (T) this;
	}

	/**
	 * Create and configure a Connector object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Connector resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T connector(java.lang.String childKey) {
		connector(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied Connector object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T connector(ConnectorSupplier supplier) {
		connector(supplier.get());
		return (T) this;
	}

	/**
	 * Add all ConnectionFactory objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ConnectionFactory objects.
	 */
	@SuppressWarnings("unchecked")
	public T connectionFactories(java.util.List<ConnectionFactory> value) {
		this.subresources.connectionFactories = value;
		return (T) this;
	}

	/**
	 * Add the ConnectionFactory object to the list of subresources
	 * 
	 * @param value
	 *            The ConnectionFactory to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T connectionFactory(ConnectionFactory value) {
		this.subresources.connectionFactories.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ConnectionFactory object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ConnectionFactory resource
	 * @param config
	 *            The ConnectionFactoryConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T connectionFactory(java.lang.String childKey,
			ConnectionFactoryConsumer consumer) {
		ConnectionFactory<? extends ConnectionFactory> child = new ConnectionFactory<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		connectionFactory(child);
		return (T) this;
	}

	/**
	 * Create and configure a ConnectionFactory object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ConnectionFactory resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T connectionFactory(java.lang.String childKey) {
		connectionFactory(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ConnectionFactory object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T connectionFactory(ConnectionFactorySupplier supplier) {
		connectionFactory(supplier.get());
		return (T) this;
	}

	/**
	 * Add all RemoteConnector objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of RemoteConnector objects.
	 */
	@SuppressWarnings("unchecked")
	public T remoteConnectors(java.util.List<RemoteConnector> value) {
		this.subresources.remoteConnectors = value;
		return (T) this;
	}

	/**
	 * Add the RemoteConnector object to the list of subresources
	 * 
	 * @param value
	 *            The RemoteConnector to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T remoteConnector(RemoteConnector value) {
		this.subresources.remoteConnectors.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a RemoteConnector object to the list of subresources
	 * 
	 * @param key
	 *            The key for the RemoteConnector resource
	 * @param config
	 *            The RemoteConnectorConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T remoteConnector(java.lang.String childKey,
			RemoteConnectorConsumer consumer) {
		RemoteConnector<? extends RemoteConnector> child = new RemoteConnector<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		remoteConnector(child);
		return (T) this;
	}

	/**
	 * Create and configure a RemoteConnector object to the list of subresources
	 * 
	 * @param key
	 *            The key for the RemoteConnector resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T remoteConnector(java.lang.String childKey) {
		remoteConnector(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied RemoteConnector object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T remoteConnector(RemoteConnectorSupplier supplier) {
		remoteConnector(supplier.get());
		return (T) this;
	}

	/**
	 * Add all InVMConnector objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of InVMConnector objects.
	 */
	@SuppressWarnings("unchecked")
	public T inVmConnectors(java.util.List<InVMConnector> value) {
		this.subresources.inVmConnectors = value;
		return (T) this;
	}

	/**
	 * Add the InVMConnector object to the list of subresources
	 * 
	 * @param value
	 *            The InVMConnector to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T inVmConnector(InVMConnector value) {
		this.subresources.inVmConnectors.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a InVMConnector object to the list of subresources
	 * 
	 * @param key
	 *            The key for the InVMConnector resource
	 * @param config
	 *            The InVMConnectorConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T inVmConnector(java.lang.String childKey,
			InVMConnectorConsumer consumer) {
		InVMConnector<? extends InVMConnector> child = new InVMConnector<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		inVmConnector(child);
		return (T) this;
	}

	/**
	 * Create and configure a InVMConnector object to the list of subresources
	 * 
	 * @param key
	 *            The key for the InVMConnector resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T inVmConnector(java.lang.String childKey) {
		inVmConnector(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied InVMConnector object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T inVmConnector(InVMConnectorSupplier supplier) {
		inVmConnector(supplier.get());
		return (T) this;
	}

	/**
	 * Add all JMSBridge objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of JMSBridge objects.
	 */
	@SuppressWarnings("unchecked")
	public T jmsBridges(java.util.List<JMSBridge> value) {
		this.subresources.jmsBridges = value;
		return (T) this;
	}

	/**
	 * Add the JMSBridge object to the list of subresources
	 * 
	 * @param value
	 *            The JMSBridge to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T jmsBridge(JMSBridge value) {
		this.subresources.jmsBridges.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a JMSBridge object to the list of subresources
	 * 
	 * @param key
	 *            The key for the JMSBridge resource
	 * @param config
	 *            The JMSBridgeConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T jmsBridge(java.lang.String childKey, JMSBridgeConsumer consumer) {
		JMSBridge<? extends JMSBridge> child = new JMSBridge<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		jmsBridge(child);
		return (T) this;
	}

	/**
	 * Create and configure a JMSBridge object to the list of subresources
	 * 
	 * @param key
	 *            The key for the JMSBridge resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T jmsBridge(java.lang.String childKey) {
		jmsBridge(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied JMSBridge object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T jmsBridge(JMSBridgeSupplier supplier) {
		jmsBridge(supplier.get());
		return (T) this;
	}

	/**
	 * Add all ExternalJMSQueue objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ExternalJMSQueue objects.
	 */
	@SuppressWarnings("unchecked")
	public T externalJmsQueues(java.util.List<ExternalJMSQueue> value) {
		this.subresources.externalJmsQueues = value;
		return (T) this;
	}

	/**
	 * Add the ExternalJMSQueue object to the list of subresources
	 * 
	 * @param value
	 *            The ExternalJMSQueue to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T externalJmsQueue(ExternalJMSQueue value) {
		this.subresources.externalJmsQueues.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ExternalJMSQueue object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ExternalJMSQueue resource
	 * @param config
	 *            The ExternalJMSQueueConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T externalJmsQueue(java.lang.String childKey,
			ExternalJMSQueueConsumer consumer) {
		ExternalJMSQueue<? extends ExternalJMSQueue> child = new ExternalJMSQueue<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		externalJmsQueue(child);
		return (T) this;
	}

	/**
	 * Create and configure a ExternalJMSQueue object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ExternalJMSQueue resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T externalJmsQueue(java.lang.String childKey) {
		externalJmsQueue(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ExternalJMSQueue object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T externalJmsQueue(ExternalJMSQueueSupplier supplier) {
		externalJmsQueue(supplier.get());
		return (T) this;
	}

	/**
	 * Add all ExternalJMSTopic objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ExternalJMSTopic objects.
	 */
	@SuppressWarnings("unchecked")
	public T externalJmsTopics(java.util.List<ExternalJMSTopic> value) {
		this.subresources.externalJmsTopics = value;
		return (T) this;
	}

	/**
	 * Add the ExternalJMSTopic object to the list of subresources
	 * 
	 * @param value
	 *            The ExternalJMSTopic to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T externalJmsTopic(ExternalJMSTopic value) {
		this.subresources.externalJmsTopics.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ExternalJMSTopic object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ExternalJMSTopic resource
	 * @param config
	 *            The ExternalJMSTopicConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T externalJmsTopic(java.lang.String childKey,
			ExternalJMSTopicConsumer consumer) {
		ExternalJMSTopic<? extends ExternalJMSTopic> child = new ExternalJMSTopic<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		externalJmsTopic(child);
		return (T) this;
	}

	/**
	 * Create and configure a ExternalJMSTopic object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ExternalJMSTopic resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T externalJmsTopic(java.lang.String childKey) {
		externalJmsTopic(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ExternalJMSTopic object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T externalJmsTopic(ExternalJMSTopicSupplier supplier) {
		externalJmsTopic(supplier.get());
		return (T) this;
	}

	/**
	 * Child mutators for MessagingActiveMQ
	 */
	public static class MessagingActiveMQResources {
		/**
		 * Multicast group to listen to receive broadcast from other servers
		 * announcing their connectors.
		 */
		@ResourceDocumentation("Multicast group to listen to receive broadcast from other servers announcing their connectors.")
		@SubresourceInfo("discoveryGroup")
		private List<DiscoveryGroup> discoveryGroups = new java.util.ArrayList<>();
		/**
		 * Used by a remote client to define how it connects to a server over
		 * HTTP.
		 */
		@ResourceDocumentation("Used by a remote client to define how it connects to a server over HTTP.")
		@SubresourceInfo("httpConnector")
		private List<HTTPConnector> httpConnectors = new java.util.ArrayList<>();
		/**
		 * Defines a managed connection factory.
		 */
		@ResourceDocumentation("Defines a managed connection factory.")
		@SubresourceInfo("pooledConnectionFactory")
		private List<PooledConnectionFactory> pooledConnectionFactories = new java.util.ArrayList<>();
		/**
		 * An ActiveMQ server instance.
		 */
		@ResourceDocumentation("An ActiveMQ server instance.")
		@SubresourceInfo("server")
		private List<Server> servers = new java.util.ArrayList<>();
		/**
		 * A connector can be used by a client to define how it connects to a
		 * server.
		 */
		@ResourceDocumentation("A connector can be used by a client to define how it connects to a server.")
		@SubresourceInfo("connector")
		private List<Connector> connectors = new java.util.ArrayList<>();
		/**
		 * Defines a connection factory.
		 */
		@ResourceDocumentation("Defines a connection factory.")
		@SubresourceInfo("connectionFactory")
		private List<ConnectionFactory> connectionFactories = new java.util.ArrayList<>();
		/**
		 * Used by a remote client to define how it connects to a server.
		 */
		@ResourceDocumentation("Used by a remote client to define how it connects to a server.")
		@SubresourceInfo("remoteConnector")
		private List<RemoteConnector> remoteConnectors = new java.util.ArrayList<>();
		/**
		 * Used by an in-VM client to define how it connects to a server.
		 */
		@ResourceDocumentation("Used by an in-VM client to define how it connects to a server.")
		@SubresourceInfo("inVmConnector")
		private List<InVMConnector> inVmConnectors = new java.util.ArrayList<>();
		/**
		 * A JMS bridge instance.
		 */
		@ResourceDocumentation("A JMS bridge instance.")
		@SubresourceInfo("jmsBridge")
		private List<JMSBridge> jmsBridges = new java.util.ArrayList<>();
		/**
		 * Defines a JMS queue to a remote broker.
		 */
		@ResourceDocumentation("Defines a JMS queue to a remote broker.")
		@SubresourceInfo("externalJmsQueue")
		private List<ExternalJMSQueue> externalJmsQueues = new java.util.ArrayList<>();
		/**
		 * Defines a JMS topic to a remote broker.
		 */
		@ResourceDocumentation("Defines a JMS topic to a remote broker.")
		@SubresourceInfo("externalJmsTopic")
		private List<ExternalJMSTopic> externalJmsTopics = new java.util.ArrayList<>();

		/**
		 * Get the list of DiscoveryGroup resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<DiscoveryGroup> discoveryGroups() {
			return this.discoveryGroups;
		}

		public DiscoveryGroup discoveryGroup(java.lang.String key) {
			return this.discoveryGroups.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of HTTPConnector resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<HTTPConnector> httpConnectors() {
			return this.httpConnectors;
		}

		public HTTPConnector httpConnector(java.lang.String key) {
			return this.httpConnectors.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of PooledConnectionFactory resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<PooledConnectionFactory> pooledConnectionFactories() {
			return this.pooledConnectionFactories;
		}

		public PooledConnectionFactory pooledConnectionFactory(
				java.lang.String key) {
			return this.pooledConnectionFactories.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of Server resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<Server> servers() {
			return this.servers;
		}

		public Server server(java.lang.String key) {
			return this.servers.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
		/**
		 * Get the list of Connector resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<Connector> connectors() {
			return this.connectors;
		}

		public Connector connector(java.lang.String key) {
			return this.connectors.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
		/**
		 * Get the list of ConnectionFactory resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ConnectionFactory> connectionFactories() {
			return this.connectionFactories;
		}

		public ConnectionFactory connectionFactory(java.lang.String key) {
			return this.connectionFactories.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of RemoteConnector resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<RemoteConnector> remoteConnectors() {
			return this.remoteConnectors;
		}

		public RemoteConnector remoteConnector(java.lang.String key) {
			return this.remoteConnectors.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of InVMConnector resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<InVMConnector> inVmConnectors() {
			return this.inVmConnectors;
		}

		public InVMConnector inVmConnector(java.lang.String key) {
			return this.inVmConnectors.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of JMSBridge resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<JMSBridge> jmsBridges() {
			return this.jmsBridges;
		}

		public JMSBridge jmsBridge(java.lang.String key) {
			return this.jmsBridges.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
		/**
		 * Get the list of ExternalJMSQueue resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ExternalJMSQueue> externalJmsQueues() {
			return this.externalJmsQueues;
		}

		public ExternalJMSQueue externalJmsQueue(java.lang.String key) {
			return this.externalJmsQueues.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of ExternalJMSTopic resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ExternalJMSTopic> externalJmsTopics() {
			return this.externalJmsTopics;
		}

		public ExternalJMSTopic externalJmsTopic(java.lang.String key) {
			return this.externalJmsTopics.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
	}

	/**
	 * Maximum size of the pool of threads used by all ActiveMQ clients running
	 * inside this server. If the attribute is undefined (by default), ActiveMQ
	 * will configure it to be 8 x the number of available processors.
	 */
	@ModelNodeBinding(detypedName = "global-client-scheduled-thread-pool-max-size")
	public Integer globalClientScheduledThreadPoolMaxSize() {
		return this.globalClientScheduledThreadPoolMaxSize;
	}

	/**
	 * Maximum size of the pool of threads used by all ActiveMQ clients running
	 * inside this server. If the attribute is undefined (by default), ActiveMQ
	 * will configure it to be 8 x the number of available processors.
	 */
	@SuppressWarnings("unchecked")
	public T globalClientScheduledThreadPoolMaxSize(java.lang.Integer value) {
		Object oldValue = this.globalClientScheduledThreadPoolMaxSize;
		this.globalClientScheduledThreadPoolMaxSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange(
					"globalClientScheduledThreadPoolMaxSize", oldValue, value);
		return (T) this;
	}

	/**
	 * Maximum size of the pool of scheduled threads used by all ActiveMQ
	 * clients running inside this server.
	 */
	@ModelNodeBinding(detypedName = "global-client-thread-pool-max-size")
	public Integer globalClientThreadPoolMaxSize() {
		return this.globalClientThreadPoolMaxSize;
	}

	/**
	 * Maximum size of the pool of scheduled threads used by all ActiveMQ
	 * clients running inside this server.
	 */
	@SuppressWarnings("unchecked")
	public T globalClientThreadPoolMaxSize(java.lang.Integer value) {
		Object oldValue = this.globalClientThreadPoolMaxSize;
		this.globalClientThreadPoolMaxSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("globalClientThreadPoolMaxSize",
					oldValue, value);
		return (T) this;
	}
}