package org.wildfly.swarm.config;

import org.wildfly.swarm.config.MessagingActiveMQ;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface MessagingActiveMQConsumer<T extends MessagingActiveMQ<T>> {

	/**
	 * Configure a pre-constructed instance of MessagingActiveMQ resource
	 * 
	 * @parameter Instance of MessagingActiveMQ to configure
	 * @return nothing
	 */
	void accept(T value);

	default MessagingActiveMQConsumer<T> andThen(
			MessagingActiveMQConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}