package org.wildfly.swarm.config;

import org.wildfly.swarm.config.Undertow;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface UndertowConsumer<T extends Undertow<T>> {

	/**
	 * Configure a pre-constructed instance of Undertow resource
	 * 
	 * @parameter Instance of Undertow to configure
	 * @return nothing
	 */
	void accept(T value);

	default UndertowConsumer<T> andThen(UndertowConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}