package org.wildfly.swarm.config.datasources;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Arrays;
import java.util.stream.Collectors;

/**
 * Service that make a JDBC driver available for use in the runtime
 */
@Address("/subsystem=datasources/jdbc-driver=*")
@ResourceType("jdbc-driver")
public class JDBCDriver<T extends JDBCDriver<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The available properties for the datasource-class, and xa-datasource-class for the jdbc-driver")
	private List<Object> datasourceClassInfo;
	@AttributeDocumentation("The name of the deployment unit from which the driver was loaded")
	private String deploymentName;
	@AttributeDocumentation("The fully qualified class name of the java.sql.Driver implementation")
	private String driverClassName;
	@AttributeDocumentation("The fully qualified class name of the javax.sql.DataSource implementation")
	private String driverDatasourceClassName;
	@AttributeDocumentation("The driver's major version number")
	private Integer driverMajorVersion;
	@AttributeDocumentation("The driver's minor version number")
	private Integer driverMinorVersion;
	@AttributeDocumentation("The name of the module from which the driver was loaded, if it was loaded from the module path")
	private String driverModuleName;
	@AttributeDocumentation("Defines the JDBC driver the datasource should use. It is a symbolic name matching the the name of installed driver. In case the driver is deployed as jar, the name is the name of deployment unit")
	private String driverName;
	@AttributeDocumentation("The fully qualified class name of the javax.sql.XADataSource implementation")
	private String driverXaDatasourceClassName;
	@AttributeDocumentation("Whether or not the driver is JDBC compliant")
	private Boolean jdbcCompliant;
	@AttributeDocumentation("The slot of the module from which the driver was loaded, if it was loaded from the module path")
	private String moduleSlot;
	@AttributeDocumentation("Domain Profile in which driver is defined. Null in case of standalone server")
	private String profile;
	@AttributeDocumentation("XA datasource class")
	private String xaDatasourceClass;

	public JDBCDriver(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The available properties for the datasource-class, and
	 * xa-datasource-class for the jdbc-driver
	 */
	@ModelNodeBinding(detypedName = "datasource-class-info")
	public List<Object> datasourceClassInfo() {
		return this.datasourceClassInfo;
	}

	/**
	 * The available properties for the datasource-class, and
	 * xa-datasource-class for the jdbc-driver
	 */
	@SuppressWarnings("unchecked")
	public T datasourceClassInfo(java.util.List<Object> value) {
		Object oldValue = this.datasourceClassInfo;
		this.datasourceClassInfo = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("datasourceClassInfo", oldValue, value);
		return (T) this;
	}

	/**
	 * The available properties for the datasource-class, and
	 * xa-datasource-class for the jdbc-driver
	 */
	@SuppressWarnings("unchecked")
	public T datasourceClassInfo(Object value) {
		if (this.datasourceClassInfo == null) {
			this.datasourceClassInfo = new java.util.ArrayList<>();
		}
		this.datasourceClassInfo.add(value);
		return (T) this;
	}

	/**
	 * The available properties for the datasource-class, and
	 * xa-datasource-class for the jdbc-driver
	 */
	@SuppressWarnings("unchecked")
	public T datasourceClassInfo(Object... args) {
		datasourceClassInfo(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}

	/**
	 * The name of the deployment unit from which the driver was loaded
	 */
	@ModelNodeBinding(detypedName = "deployment-name")
	public String deploymentName() {
		return this.deploymentName;
	}

	/**
	 * The name of the deployment unit from which the driver was loaded
	 */
	@SuppressWarnings("unchecked")
	public T deploymentName(java.lang.String value) {
		Object oldValue = this.deploymentName;
		this.deploymentName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("deploymentName", oldValue, value);
		return (T) this;
	}

	/**
	 * The fully qualified class name of the java.sql.Driver implementation
	 */
	@ModelNodeBinding(detypedName = "driver-class-name")
	public String driverClassName() {
		return this.driverClassName;
	}

	/**
	 * The fully qualified class name of the java.sql.Driver implementation
	 */
	@SuppressWarnings("unchecked")
	public T driverClassName(java.lang.String value) {
		Object oldValue = this.driverClassName;
		this.driverClassName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("driverClassName", oldValue, value);
		return (T) this;
	}

	/**
	 * The fully qualified class name of the javax.sql.DataSource implementation
	 */
	@ModelNodeBinding(detypedName = "driver-datasource-class-name")
	public String driverDatasourceClassName() {
		return this.driverDatasourceClassName;
	}

	/**
	 * The fully qualified class name of the javax.sql.DataSource implementation
	 */
	@SuppressWarnings("unchecked")
	public T driverDatasourceClassName(java.lang.String value) {
		Object oldValue = this.driverDatasourceClassName;
		this.driverDatasourceClassName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("driverDatasourceClassName", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The driver's major version number
	 */
	@ModelNodeBinding(detypedName = "driver-major-version")
	public Integer driverMajorVersion() {
		return this.driverMajorVersion;
	}

	/**
	 * The driver's major version number
	 */
	@SuppressWarnings("unchecked")
	public T driverMajorVersion(java.lang.Integer value) {
		Object oldValue = this.driverMajorVersion;
		this.driverMajorVersion = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("driverMajorVersion", oldValue, value);
		return (T) this;
	}

	/**
	 * The driver's minor version number
	 */
	@ModelNodeBinding(detypedName = "driver-minor-version")
	public Integer driverMinorVersion() {
		return this.driverMinorVersion;
	}

	/**
	 * The driver's minor version number
	 */
	@SuppressWarnings("unchecked")
	public T driverMinorVersion(java.lang.Integer value) {
		Object oldValue = this.driverMinorVersion;
		this.driverMinorVersion = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("driverMinorVersion", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the module from which the driver was loaded, if it was loaded
	 * from the module path
	 */
	@ModelNodeBinding(detypedName = "driver-module-name")
	public String driverModuleName() {
		return this.driverModuleName;
	}

	/**
	 * The name of the module from which the driver was loaded, if it was loaded
	 * from the module path
	 */
	@SuppressWarnings("unchecked")
	public T driverModuleName(java.lang.String value) {
		Object oldValue = this.driverModuleName;
		this.driverModuleName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("driverModuleName", oldValue, value);
		return (T) this;
	}

	/**
	 * Defines the JDBC driver the datasource should use. It is a symbolic name
	 * matching the the name of installed driver. In case the driver is deployed
	 * as jar, the name is the name of deployment unit
	 */
	@ModelNodeBinding(detypedName = "driver-name")
	public String driverName() {
		return this.driverName;
	}

	/**
	 * Defines the JDBC driver the datasource should use. It is a symbolic name
	 * matching the the name of installed driver. In case the driver is deployed
	 * as jar, the name is the name of deployment unit
	 */
	@SuppressWarnings("unchecked")
	public T driverName(java.lang.String value) {
		Object oldValue = this.driverName;
		this.driverName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("driverName", oldValue, value);
		return (T) this;
	}

	/**
	 * The fully qualified class name of the javax.sql.XADataSource
	 * implementation
	 */
	@ModelNodeBinding(detypedName = "driver-xa-datasource-class-name")
	public String driverXaDatasourceClassName() {
		return this.driverXaDatasourceClassName;
	}

	/**
	 * The fully qualified class name of the javax.sql.XADataSource
	 * implementation
	 */
	@SuppressWarnings("unchecked")
	public T driverXaDatasourceClassName(java.lang.String value) {
		Object oldValue = this.driverXaDatasourceClassName;
		this.driverXaDatasourceClassName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("driverXaDatasourceClassName",
					oldValue, value);
		return (T) this;
	}

	/**
	 * Whether or not the driver is JDBC compliant
	 */
	@ModelNodeBinding(detypedName = "jdbc-compliant")
	public Boolean jdbcCompliant() {
		return this.jdbcCompliant;
	}

	/**
	 * Whether or not the driver is JDBC compliant
	 */
	@SuppressWarnings("unchecked")
	public T jdbcCompliant(java.lang.Boolean value) {
		Object oldValue = this.jdbcCompliant;
		this.jdbcCompliant = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("jdbcCompliant", oldValue, value);
		return (T) this;
	}

	/**
	 * The slot of the module from which the driver was loaded, if it was loaded
	 * from the module path
	 */
	@ModelNodeBinding(detypedName = "module-slot")
	public String moduleSlot() {
		return this.moduleSlot;
	}

	/**
	 * The slot of the module from which the driver was loaded, if it was loaded
	 * from the module path
	 */
	@SuppressWarnings("unchecked")
	public T moduleSlot(java.lang.String value) {
		Object oldValue = this.moduleSlot;
		this.moduleSlot = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("moduleSlot", oldValue, value);
		return (T) this;
	}

	/**
	 * Domain Profile in which driver is defined. Null in case of standalone
	 * server
	 */
	@ModelNodeBinding(detypedName = "profile")
	public String profile() {
		return this.profile;
	}

	/**
	 * Domain Profile in which driver is defined. Null in case of standalone
	 * server
	 */
	@SuppressWarnings("unchecked")
	public T profile(java.lang.String value) {
		Object oldValue = this.profile;
		this.profile = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("profile", oldValue, value);
		return (T) this;
	}

	/**
	 * XA datasource class
	 */
	@ModelNodeBinding(detypedName = "xa-datasource-class")
	public String xaDatasourceClass() {
		return this.xaDatasourceClass;
	}

	/**
	 * XA datasource class
	 */
	@SuppressWarnings("unchecked")
	public T xaDatasourceClass(java.lang.String value) {
		Object oldValue = this.xaDatasourceClass;
		this.xaDatasourceClass = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("xaDatasourceClass", oldValue, value);
		return (T) this;
	}
}