package org.wildfly.swarm.config.datasources;

import org.wildfly.swarm.config.datasources.JDBCDriver;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface JDBCDriverConsumer<T extends JDBCDriver<T>> {

	/**
	 * Configure a pre-constructed instance of JDBCDriver resource
	 * 
	 * @parameter Instance of JDBCDriver to configure
	 * @return nothing
	 */
	void accept(T value);

	default JDBCDriverConsumer<T> andThen(JDBCDriverConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}